/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.Camera;
import api.graphics.IObjectController;
import api.graphics.Mesh;
import api.graphics.Model;
import api.graphics.ModelInstance;
import api.graphics.PbrMaterial;
import api.graphics.Shader;
import api.graphics.geometry.MeshBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ObjectRotator
implements IObjectController {
    private ModelInstance target;
    private Camera camera;
    private ModelInstance renderable;
    private PbrMaterial highlightMtl;
    private Mesh hovered;
    private Mesh xRing;
    private Mesh yRing;
    private Mesh zRing;
    private boolean onDrag;
    private Vector2f offset = new Vector2f();

    public ObjectRotator(Camera camera) {
        this.camera = camera;
        this.createRenderable();
    }

    private void createRenderable() {
        PbrMaterial xMaterial = new PbrMaterial();
        xMaterial.setAlbedo(new Vector3f(1.0f, 0.0f, 0.0f));
        xMaterial.setOpacity(0.5f);
        PbrMaterial yMaterial = new PbrMaterial();
        yMaterial.setAlbedo(new Vector3f(0.0f, 1.0f, 0.0f));
        yMaterial.setOpacity(0.5f);
        PbrMaterial zMaterial = new PbrMaterial();
        zMaterial.setAlbedo(new Vector3f(0.0f, 0.0f, 1.0f));
        zMaterial.setOpacity(0.5f);
        float radians90 = (float)Math.toRadians(90.0);
        this.xRing = MeshBuilder.createRing(0.04f, 1.0f, 128, 16, xMaterial, new Matrix4f().rotate(-radians90, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)).scale(0.75f));
        this.yRing = MeshBuilder.createRing(0.04f, 1.0f, 128, 16, yMaterial, new Matrix4f().scale(0.75f));
        this.zRing = MeshBuilder.createRing(0.04f, 1.0f, 128, 16, zMaterial, new Matrix4f().rotate(radians90, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).scale(0.75f));
        Mesh parent = new Mesh(this.xRing, this.yRing, this.zRing);
        parent.setLocalTransform(new Matrix4f().scale(0.2f));
        Model model = new Model(parent);
        this.renderable = new ModelInstance(model);
        this.highlightMtl = new PbrMaterial();
        this.highlightMtl.setAlbedo(new Vector3f(1.0f, 1.0f, 0.0f));
        this.highlightMtl.setMetalness(0.04f);
        this.highlightMtl.setRoughness(1.0f);
    }

    public void rottate(Vector2f delta) {
    }

    @Override
    public boolean mouseDoubleClick(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseUp(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseMove(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseScrolled(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    @Override
    public void draw(Shader shader, Camera camera) {
    }

    @Override
    public ModelInstance getRenderable() {
        return this.renderable;
    }

    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    @Override
    public void drawVertices(Camera camera) {
    }

    @Override
    public void drawSilhouette(Camera camera) {
    }

    @Override
    public ModelInstance getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(ModelInstance instance) {
        this.target = instance;
    }
}

