package org.frs.structures.grid;

import java.util.ArrayList;
import java.util.Iterator;

public class GridIterator implements Iterator<Cell> {

	private final  ArrayList<Cell> cells = new ArrayList<Cell>();
	private int index = 0;
	
	public GridIterator(Grid grid) {
		flatten(grid);
	}
	
	private void flatten(Grid grid) {
		for(int i = 0; i < grid.getCells().length; i++) {
			for(int j =0; j < grid.getCells()[0].length; j++) {
				cells.add(grid.getCells()[i][j]);
			}
		}
	}


	@Override
	public boolean hasNext() {
		return index < cells.size();
	}

	@Override
	public Cell next() {
		return cells.get(index++);
	}

}
