package gdxapp.object3d;

import java.io.File;
import java.io.Serializable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.utils.Disposable;
import dressing.model.persistence.mappers.MapperProvider;

public class ObjectModel implements Serializable, Disposable {
	
	private String modelDir;
	private transient Model model;
	private ModelInfo info;
	
	private boolean loaded;
	
	
	public ObjectModel() {}
	
	public ObjectModel(String modelPath) {
		super();
		this.modelDir = modelPath;
	}
	
	public ObjectModel(Model model, ModelInfo adj) {
		this.model = model;
		this.info = adj;
		loaded = model!=null;
	}
	
	public boolean load() {
		if(loadModel()) {
			if(info == null)
				loadInfo();
			return true;
		}
		return false;
	}


	private boolean loadModel() {
		File modelFile = new File(modelDir + File.separator + "model.g3dj");
		if(!modelFile.exists()) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					MessageDialog.openError(new Shell(Display.getCurrent()), "error", "failed to load model from " + modelDir);
				}
			});
			return false;
		}
		model = ModelsLoader.getInstance().loadModel(modelFile);
		loaded = model!=null;
		return loaded;
	}
	
	private void loadInfo() {
		File infoFile = new File(modelDir + File.separator + "info.xml");
		try {
			info = MapperProvider.getXmlMapper().fromXml(infoFile, ModelInfo.class);
		}catch (Exception e) {
			info = new ModelInfo();
			info.setToDefault();
		}
	}
	
	public ObjectModel clone() {
		return new ObjectModel(this.modelDir);
	}

	public Model getModel() {
		if(model == null && !loaded)
			load();
		return model;
	}
	public void setModel(Model model) {
		if(model != null) {
			this.model = model;
			loaded = true;
		}
	}

	public ModelInfo getInfo() {
		if(info == null)
			loadInfo();
		return info;
	}

	public void setInfo(ModelInfo info) {
		this.info = info;
	}

	@Override
	public void dispose() {
		if(model != null) {
			try {
				model.dispose();
			}catch (Exception e) {
				System.out.println("failed to dispose " + model);
			}
		}
	}
	
	
}
