package gdxapp.Commun;

import java.util.Comparator;

import com.badlogic.gdx.scenes.scene2d.Actor;

import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.screens.wall.Wall2D;
import gdxapp.zoneselector.ZoneSelector;
import geometry.Polygon;

public class AltitudeSorter implements Comparator<Actor> {

	
	private static AltitudeSorter sorter = new AltitudeSorter();
	
	private AltitudeSorter() {}
	@Override
	public int compare(Actor a1, Actor a2) {

		
		if(a1 instanceof Object2D && a2 instanceof Object2D) {
			Object2D o1 = (Object2D) a1;
			Object2D o2 = (Object2D) a2;
			if (o1.getWorldObject() == null || o1.getWorldObject().getRealWorldPosition() == null || o2 == null || o2.getWorldObject().getRealWorldPosition() == null) {
				return 0;
			}
			if(o1.getWorldObject() instanceof KitchenElement  && !(o2.getWorldObject() instanceof KitchenElement)) {
				return 1;
			}
			
			if(o2.getWorldObject() instanceof KitchenElement  && !(o1.getWorldObject() instanceof KitchenElement)) {
				return -1;
			}
			
			float y1 = o1.getWorldObject().getRealWorldPosition().y + .5f * o1.getWorldObject().getRealWorldDimension().y;
			float y2 = o2.getWorldObject().getRealWorldPosition().y + .5f * o2.getWorldObject().getRealWorldDimension().y;
			if(o1.getWorldObject() instanceof Wall && !(o2.getWorldObject() instanceof Wall) ) {
				return -1;
			}
			if(o2.getWorldObject() instanceof Wall && !(o1.getWorldObject() instanceof Wall) ) {
				return 1;
			}
			if (y1 < y2) {
				return -1;
			} else if(y1 > y2){
				return 1;
			}else {
				return 0;
			}
		}
		if(a1 instanceof Object2D && a2 instanceof Wall2D) {
			return 1;
		}
		if(a2 instanceof Object2D && a1 instanceof Wall2D) {
			return -1;
		}
		if( a1 instanceof MeasuresTaker|| a1 instanceof ZoneSelector || a1 instanceof Polygon) {
			return 1;
		}
		if( a2 instanceof MeasuresTaker|| a2 instanceof ZoneSelector || a2 instanceof Polygon) {
			return -1;
		}
		return 1;	
	}

	public static AltitudeSorter getSorter() {
		// TODO Auto-generated method stub
		return sorter;
	}

}
