package dressing.ui.util;

import java.io.File;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.prefs.Preferences;

import dressing.config.WorkspaceConfiguration;

import org.eclipse.wb.swt.SWTResourceManager;

public class ImageChooserDialog extends Dialog {
	public static final String[] extensions= { "*.png;*.jpg;*.jpeg;*jpeg;"};
	private Text imagePath;
	private String imageUri;
	private Label lblImage;
	private String localPath; 
	private Image img;
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public ImageChooserDialog(Shell parentShell,String imageUri) {
		super(parentShell);
		this.imageUri=imageUri;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gridLayout = (GridLayout) container.getLayout();
		gridLayout.numColumns = 2;
		
		imagePath = new Text(container, SWT.BORDER);
		imagePath.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Button btnLocal = new Button(container, SWT.NONE);
		btnLocal.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		btnLocal.setText("Local");
		
		lblImage = new Label(container, SWT.NONE);
		GridData gd_lblImage = new GridData(SWT.CENTER, SWT.FILL, false, false, 1, 1);
		gd_lblImage.widthHint = 200;
		gd_lblImage.heightHint = 150;
		lblImage.setLayoutData(gd_lblImage);
		
		Button btnPC = new Button(container, SWT.NONE);
		
		btnPC.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		btnPC.setText("Ordinateur");
		btnPC.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(parent.getShell(), SWT.OPEN);
				dialog.setFilterExtensions(extensions);
				Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
				Preferences projectpref = preferences.node("SuperDressingProject");
				String defaultpath = projectpref.get("importFromDirectory", System.getProperty("user.home") + File.separator + "Desktop");
				String dirpath = System.getProperty("user.home");
//				if(imageUri!=null && !imageUri.isEmpty()) {
//					File imagefile=new File(imageUri);
//					if(imagefile.exists() && imagefile.isFile()){
//						dirpath=imagefile.getParentFile().getAbsolutePath();
//
//					}
//				}
				dialog.setFilterPath(dirpath);
				String filepath = dialog.open();
				if (filepath != null && !filepath.isEmpty()) {
					///validate image chosen 
					if(!ImageLoaderCache.isValidImagePath(filepath)) {
						MessageDialog.openError(parent.getShell(), "invalid image", "il faut vérifier l'image selectionner");
					}else
					{
						imagePath.setText(filepath);
						imageUri=filepath;
						img=ImageLoaderCache.getInstance().loadImage(getImageUri(), 200, 150);
						lblImage.setImage(img);
					}
				}
			}
		});
		btnLocal.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String dirpath =getLocalPath();
				FileDialog dialog = new FileDialog(parent.getShell(), SWT.OPEN);
				dialog.setFilterExtensions(extensions);
//				if(imageUri!=null && !imageUri.isEmpty()) {
//					File imagefile=new File(imageUri);
//					if(imagefile.exists() && imagefile.isFile()){
//						dirpath=imagefile.getParentFile().getAbsolutePath();
//
//					}
//				}
				dialog.setFilterPath(dirpath);
				String filepath = dialog.open();
				if (filepath != null && !filepath.isEmpty()) {
					///validate image chosen 
					if(!ImageLoaderCache.isValidImagePath(filepath)) {
						MessageDialog.openError(parent.getShell(), "invalid image", "il faut vérifier l'image selectionner");
					}else
					{
						imagePath.setText(filepath);
						imageUri=filepath;
						img=ImageLoaderCache.getInstance().loadImage(getImageUri(), 200, 150);
						lblImage.setImage(img);	
					}
				}
			}
		});
		if(imageUri!=null && !imageUri.isEmpty()) {
			imagePath.setText(imageUri);
			img=ImageLoaderCache.getInstance().resizeImage(ImageLoaderCache.createImageFromPathOrUrl(getImageUri()), 200, 150);
			lblImage.setImage(img);	
		}
		imagePath.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				if(imagePath.getText().contentEquals(imageUri)) {
					return;
				}
				imageUri = imagePath.getText();
				if (ImageLoaderCache.isValidImagePath(imageUri) || ImageLoaderCache.isValidImageUrl(imageUri))
				{
					img=ImageLoaderCache.getInstance()
							.resizeImage(ImageLoaderCache.createImageFromPathOrUrl(getImageUri()), 200, 150);
					lblImage.setImage(img);
				}

			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		parent.getShell().setText("Choisir un image");
		parent.getShell().addShellListener(new ShellListener() {

			@Override
			public void shellActivated(ShellEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void shellClosed(ShellEvent e) {
				// TODO Auto-generated method stub
				if(img!=null && !img.isDisposed()) {
					img.dispose();
				}
			}

			@Override
			public void shellDeactivated(ShellEvent e) {
				// TODO Auto-generated method stub
				if(img!=null && !img.isDisposed()) {
					img.dispose();
				}
			}

			@Override
			public void shellDeiconified(ShellEvent e) {
				// TODO Auto-generated method stub
				if(img!=null && !img.isDisposed()) {
					img.dispose();
				}
			}

			@Override
			public void shellIconified(ShellEvent e) {
				// TODO Auto-generated method stub
				
			}
			
		});
		return container;
	}

	public String getLocalPath() {
		if(localPath==null || localPath.isEmpty()) {
			localPath=WorkspaceConfiguration.getAccessoireImagesPath();
		}
		return localPath;
	}

	public void setLocalPath(String localPath) {
		this.localPath = localPath;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		Button btnOk = createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		btnOk.setText("Appliquer");
		Button btnCancel = createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
		btnCancel.setText("Annuler");
	}
	
	@Override
	protected void okPressed() {
		if(!ImageLoaderCache.isValidImagePath(imageUri)&&!ImageLoaderCache.isValidImageUrl(imageUri)) {
			MessageDialog.openError(imagePath.getShell(), "Erreur", "Le fichier choisi est une image invalide." );
			return;
		}
		if(img!=null && !img.isDisposed()) {
			img.dispose();
		}
		if(lblImage.getImage()!=null)
		{
			lblImage.getImage().dispose();
		}
		super.okPressed();
	}
	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(450, 300);
	}

	public String getImageUri() {
		return imageUri;
	}

	public void setImageUri(String imageUri) {
		this.imageUri = imageUri;
	}
	@Override
	public boolean close() {
		if(img!=null && !img.isDisposed()) {
			img.dispose();
		}
		if(lblImage.getImage()!=null)
		{
			lblImage.getImage().dispose();
		}
		return super.close();
	}
}
