package dressing.ui.project;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;

import org.eclipse.nebula.widgets.tablecombo.TableCombo;

import java.beans.PropertyChangeSupport;

import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.widgets.Button;

import dressing.config.UserPreference;
import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.ColorComposite;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.assets.AssetsTextures;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;
import param.MaterialType;
import param.impl.MaterialTypeImpl;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class ElementConfigComposite extends Composite{
	
	
	private ScenePreferences preferences;
	private SceneTexture boxTexture, facadeTexture, backTexture;
	private PbrMaterial boxMtl, facadeMtl, backMtl;
	private PropertyChangeSupport pcs;
	private Button btnPreview;
	
	private ColorComposite grpColorBox;
	private ColorComposite grpColorFacade;
	private ColorComposite grpColorBack;
	
	public ElementConfigComposite(Composite parent, int style, ScenePreferences preferences) {
		super(parent, style);
		this.preferences = preferences;
		
		
		setLayout(new GridLayout(1, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setBounds(0, 0, 64, 64);
		
		SingleImageItemLabelProvider labelProvider = SingleImageItemLabelProvider.getInstance();
		
		CBanner banner = new CBanner(composite, SWT.NONE);
		banner.setRightWidth(300);
		banner.setRightMinimumSize(new Point(300, 0));
		
		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_1);
		composite_1.setLayout(new GridLayout(1, false));
		
		Group grpBox = new Group(composite_1, SWT.NONE);
		grpBox.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpBox.setText("Caisson");
		grpBox.setBounds(0, 0, 544, 125);
		grpBox.setLayout(new GridLayout(2, false));
		
		Label lblTexture = new Label(grpBox, SWT.NONE);
		lblTexture.setText("Texture");
		lblTexture.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		TableComboViewer tcvBoxTexture = new TableComboViewer(grpBox, SWT.NONE);
		tcvBoxTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				boxTexture = (SceneTexture) tcvBoxTexture.getStructuredSelection().getFirstElement();
				updatePreview(boxTexture);
				boxConfigChanged();
			}
		});
		TableCombo tableCombo = tcvBoxTexture.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo.setEditable(false);
		tcvBoxTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvBoxTexture.setLabelProvider(labelProvider);
		tcvBoxTexture.setInput(ModelProvider.getTextures(CATEGORY.ELEMENT));
		
		Button btnCouleur = new Button(grpBox, SWT.CHECK);
		btnCouleur.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				colorOptionChanged(btnCouleur, grpColorBox, tableCombo);
			}
			
			
		});
		btnCouleur.setText("Couleur");
		 
		grpColorBox = new ColorComposite(grpBox, SWT.NONE);
		grpColorBox.getBtncolorChooser().setEnabled(false);

		grpColorBox.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		
		Label lblMat = new Label(grpBox, SWT.NONE);
		lblMat.setText("Finition");
		lblMat.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		TableComboViewer tcvBoxMaterial = new TableComboViewer(grpBox, SWT.NONE);
		tcvBoxMaterial.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				boxMtl = new PbrMaterial((MaterialTypeImpl) tcvBoxMaterial.getStructuredSelection().getFirstElement());
				boxConfigChanged();
			}
		});
		TableCombo tableCombo_1 = tcvBoxMaterial.getTableCombo();
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_1.setEditable(false);
		tcvBoxMaterial.setContentProvider(ArrayContentProvider.getInstance());
		tcvBoxMaterial.setLabelProvider(labelProvider);
		tcvBoxMaterial.setInput(ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes());
		
		Group grpFacade = new Group(composite_1, SWT.NONE);
		grpFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpFacade.setText("Façade");
		grpFacade.setBounds(0, 0, 176, 125);
		grpFacade.setLayout(new GridLayout(2, false));
		
		Label lblTexture_1 = new Label(grpFacade, SWT.NONE);
		lblTexture_1.setText("Texture");
		lblTexture_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		TableComboViewer tcvFacadeTexture = new TableComboViewer(grpFacade, SWT.NONE);
		tcvFacadeTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				facadeTexture = (SceneTexture) tcvFacadeTexture.getStructuredSelection().getFirstElement();
				updatePreview(facadeTexture);
				facadeConfigChanged();
			}
		});
		TableCombo tableCombo_2 = tcvFacadeTexture.getTableCombo();
		tableCombo_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_2.setEditable(false);
		tcvFacadeTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvFacadeTexture.setLabelProvider(labelProvider);
		tcvFacadeTexture.setInput(ModelProvider.getTextures(CATEGORY.ELEMENT));
		
		Button btnCouleur_1 = new Button(grpFacade, SWT.CHECK);
		btnCouleur_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				colorOptionChanged(btnCouleur_1, grpColorFacade, tableCombo_2);
			}
		});
		btnCouleur_1.setText("Couleur");
		
		grpColorFacade = new ColorComposite(grpFacade, SWT.NONE);
		grpColorFacade.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		grpColorFacade.getBtncolorChooser().setEnabled(false);
		
		Label lblMat_1 = new Label(grpFacade, SWT.NONE);
		lblMat_1.setText("Finition");
		lblMat.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		TableComboViewer tcvFacadeMat = new TableComboViewer(grpFacade, SWT.NONE);
		tcvFacadeMat.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				facadeMtl = new PbrMaterial((MaterialTypeImpl) tcvFacadeMat.getStructuredSelection().getFirstElement());
				facadeConfigChanged();
			}
		});
		TableCombo tableCombo_1_1 = tcvFacadeMat.getTableCombo();
		tableCombo_1_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_1_1.setEditable(false);
		tcvFacadeMat.setContentProvider(ArrayContentProvider.getInstance());
		tcvFacadeMat.setLabelProvider(labelProvider);
		tcvFacadeMat.setInput(ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes());
		
		Group grpDos = new Group(composite_1, SWT.NONE);
		grpDos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpDos.setText("Dos");
		grpDos.setBounds(0, 0, 176, 125);
		grpDos.setLayout(new GridLayout(2, false));
		
		Label lblTexture_1_1 = new Label(grpDos, SWT.NONE);
		lblTexture_1_1.setText("Texture");
		lblTexture_1_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		TableComboViewer tcvDosTexture = new TableComboViewer(grpDos, SWT.NONE);
		tcvDosTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				backTexture = (SceneTexture) tcvDosTexture.getStructuredSelection().getFirstElement();
				updatePreview(backTexture);
				backConfigChanged();
			}
		});
		TableCombo tableCombo_2_1 = tcvDosTexture.getTableCombo();
		tableCombo_2_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_2_1.setEditable(false);
		tcvDosTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvDosTexture.setLabelProvider(labelProvider);
		tcvDosTexture.setInput(ModelProvider.getTextures(CATEGORY.ELEMENT));
		
		Button btnCouleur_2 = new Button(grpDos, SWT.CHECK);
		btnCouleur_2.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				colorOptionChanged(btnCouleur_2, grpColorBack, tableCombo_2_1);
			}
		});
		btnCouleur_2.setText("Couleur");
		
		grpColorBack = new ColorComposite(grpDos, SWT.NONE);
		grpColorBack.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		grpColorBack.getBtncolorChooser().setEnabled(false);

		Label lblMat_1_1 = new Label(grpDos, SWT.NONE);
		lblMat_1_1.setText("Finition");
		lblMat_1_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		TableComboViewer tcvDosMat = new TableComboViewer(grpDos, SWT.NONE);
		tcvDosMat.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				backMtl = new PbrMaterial((MaterialTypeImpl) tcvDosMat.getStructuredSelection().getFirstElement());
				backConfigChanged();
			}
		});
		TableCombo tableCombo_1_1_1 = tcvDosMat.getTableCombo();
		tableCombo_1_1_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_1_1_1.setEditable(false);
		tcvDosMat.setContentProvider(ArrayContentProvider.getInstance());
		tcvDosMat.setLabelProvider(labelProvider);
		tcvDosMat.setInput(ResourceManagers.getIntance().getMaterialTypesGroup().getMaterialTypes());
		
		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_2);
		composite_2.setLayout(new GridLayout(1, false));
		
		btnPreview = new Button(composite_2, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		updateElementSelection(tcvBoxTexture, tcvBoxMaterial, preferences.getBoxMtl());
		updateElementSelection(tcvFacadeTexture, tcvFacadeMat, preferences.getFacadeMtl());
		updateElementSelection(tcvDosTexture, tcvDosMat, preferences.getBackMtl());
		
	}

	private void updateElementSelection(TableComboViewer albedoMapTCV, TableComboViewer materialTypeTCV, PbrMaterial mtl) {
		if(mtl == null)
			return;
		
		if(mtl.getAlbedoMapPath() != null) {
			SceneTexture albedoMap = ModelProvider.getTexture(mtl.getAlbedoMapPath());
			if(albedoMap!=null) {
				StructuredSelection structuredSelection = new StructuredSelection(albedoMap);
				albedoMapTCV.setSelection(structuredSelection);
			}
		}
		if(mtl.getName() != null) {
			MaterialType materialType =  ModelProvider.getMaterialTypeByName(mtl.getName());
			if(materialType!=null) {
				StructuredSelection structuredSelection = new StructuredSelection(materialType);
				materialTypeTCV.setSelection(structuredSelection);
			}

		}
		
	}

	protected void colorOptionChanged(Button checkBtn, ColorComposite grpColor, TableCombo tableCombo) {
		tableCombo.setEnabled(!checkBtn.getSelection());
		grpColor.getBtncolorChooser().setEnabled(checkBtn.getSelection());		
	}

	protected void updatePreview(SceneTexture texture) {
		btnPreview.setImage(texture.getPreview());
	}
	
	private void boxConfigChanged() {
		if(boxMtl != null) {
			if(!grpColorBox.getBtncolorChooser().isEnabled() && boxTexture != null) {
				preferences.setBoxTexture(boxTexture);
				boxMtl.setAlbedoMapPath(boxTexture.getPath());
				preferences.setBoxMtl(boxMtl);
			}else if(grpColorBox.getBtncolorChooser().isEnabled()) {
				boxMtl.setAlbedo(grpColorBox.getRGBVector());
				preferences.setBoxMtl(boxMtl);
			}
		}
	}
	
	private void facadeConfigChanged() {
		if(facadeMtl != null) {
			if(!grpColorFacade.getBtncolorChooser().isEnabled() && facadeTexture != null) {
				preferences.setFacadeTexture(facadeTexture);
				facadeMtl.setAlbedoMapPath(facadeTexture.getPath());
				preferences.setFacadeMtl(facadeMtl);
			}else if(grpColorFacade.getBtncolorChooser().isEnabled()) {
				facadeMtl.setAlbedo(grpColorFacade.getRGBVector());
				preferences.setFacadeMtl(facadeMtl);
			}
		}
	}
	


	private void backConfigChanged() {
		if(backMtl != null) {
			if(!grpColorBack.getBtncolorChooser().isEnabled() && backTexture != null) {
				preferences.setBackTexture(backTexture);
				backMtl.setAlbedoMapPath(backTexture.getPath());
				preferences.setBackMtl(backMtl);
			}else if(grpColorBox.getBtncolorChooser().isEnabled()) {
				backMtl.setAlbedo(grpColorBack.getRGBVector());
				preferences.setBackMtl(backMtl);
			}
		}
	}
	
}
