package dressing.ui;

import java.util.ArrayList;
import java.util.Comparator;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.MDFThickness;
import param.ParamFactory;

public class EppaisseurPanneauxComboSelect extends ElementComboSelect {

	public EppaisseurPanneauxComboSelect(Composite parent, int style) {
		super(parent, style);
		// TODO Auto-generated constructor stub
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		ArrayList<MDFThickness> input2=new ArrayList<MDFThickness>();
		input2.addAll(ResourceManagers.getIntance().getGestion().getMdfThicknesses());
		input2.sort( Comparator.comparingDouble(e -> ((MDFThickness) e).getThickness()));
		input.addAll(input2);
		return input;
	}

	@Override
	public void addElement() {
		MDFThickness nature=ParamFactory.eINSTANCE.createMDFThickness();
		nature.setName("");
		EppaisseurEditorWindow nature_panneauxEditorWindow = new EppaisseurEditorWindow(getShell(),nature,EditorWindow.create);
		nature_panneauxEditorWindow.create();
		int ret=nature_panneauxEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			
			getComboViewer().setSelection(new StructuredSelection(nature), true);
		}
	}

//	@Override
//	public void listElements() {
//		EppaisseurPanneauxListWindow frsListWindow = new EppaisseurPanneauxListWindow(getShell(),null);
//		frsListWindow.create();
//		int ret=frsListWindow.open();
//		getComboViewer().setInput(getinput());
//		getComboViewer().refresh();
//		
//	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof MDFThickness) {
			MDFThickness nature=(MDFThickness) selection;
			EppaisseurEditorWindow nature_panneauxEditorWindow = new EppaisseurEditorWindow(getShell(),nature,EditorWindow.update);
			nature_panneauxEditorWindow.create();
			int ret=nature_panneauxEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		// TODO Auto-generated method stub
		return new EppaisseurPanneauxListWindow(getShell(),null);
	}
}
class ThicknessComparator implements Comparator<MDFThickness>{

	@Override
	public int compare(MDFThickness o1, MDFThickness o2) {
		if(o1!=null && o2!=null) {
			if(((MDFThickness)o1).getThickness()<=((MDFThickness)o2).getThickness()) {
				return -1;
			}else {
				return 1;
			}
		}
		return 0;
	}
	
}
