package dressing.handlers;

import java.io.IOException;

import javax.inject.Named;

import org.eclipse.e4.core.di.annotations.Execute;

import dressing.model.ModelProvider;
import gdxapp.object3d.ModelsLoader;
import gdxapp.object3d.ObjectModel;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;

public class AssetModelAddedHandler {

	@Execute
	public void execute(@Named("dressing.commandparameter.asset_path") String path) {

		ObjectModel model = new ObjectModel(path);
		ModelProvider.addModelObject(model);
		try {
			WorldObject wObject = WorldObjectFactory.getFactory().createObjectFromModel(model);
			ModelProvider.getDesignObjects().add(wObject);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
