package dressing.cam.model;

import java.util.HashMap;
import java.util.Map;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import param.cam.MachineEngine;

public class MachineCodeHandler {

	public Map<String, GcodeGenerator>generators = new HashMap<String,GcodeGenerator>();
	public static MachineCodeHandler instance;
	public static final String GCODE_EXTENSION=".gcode";
	public static final String TCN=".TCN";
	public static final String SCM=".xxl";
	public GcodeGenerator generator;
	public String extension;
	public static MachineCodeHandler getInstance() {
 		synchronized(MachineCodeHandler.class) {
 			if (instance == null) {
 				instance = new MachineCodeHandler();
 			}
 			return instance;
 		}
	}
	public MachineCodeHandler() {
		super();
		init();
	}
	private void init() {
		generators.put(MachineCodeHandler.GCODE_EXTENSION, HoleMasterGcodeGenerator.getInstance());
		generators.put(MachineCodeHandler.TCN, GriggioCodeGenerator.getInstance());
		MachineEngine engine=ResourceManagers.getIntance().getPreference().getConfig().getEngine();
		if(engine!=null) {
			String code=engine.getCode();
			generator =getMachineCodeGenerator(code);	
			extension=engine.getExtension();
		}
		if(generator==null) {
			generator =getMachineCodeGenerator(MachineCodeHandler.GCODE_EXTENSION);
		}
	}
	
	public Map<String, GcodeGenerator> getGenerators() {
		return generators;
	}
	public void setGenerators(Map<String, GcodeGenerator> generators) {
		this.generators = generators;
	}
	public GcodeGenerator getGenerator() {
		MachineEngine engine=ResourceManagers.getIntance().getPreference().getConfig().getEngine();
		if(engine!=null) {
			String code=engine.getCode();
			generator =getMachineCodeGenerator(code);	
			extension=engine.getExtension();
		}
		if(generator==null) {
			generator =getMachineCodeGenerator(MachineCodeHandler.GCODE_EXTENSION);
		}
		return generator;
	}
	public void refresh() {
		MachineEngine engine=ResourceManagers.getIntance().getPreference().getConfig().getEngine();
		if(engine!=null) {
			String code=engine.getCode();
			generator = getMachineCodeGenerator(code);	
			extension = engine.getExtension();
		}else
		{
			generator = getMachineCodeGenerator(MachineCodeHandler.GCODE_EXTENSION);
		}
		
		
	}
	public void setGenerator(GcodeGenerator generator) {
		this.generator = generator;
	}
	public String getExtension() {
		return extension;
	}
	public void setExtension(String extension) {
		this.extension = extension;
	}
	public GcodeGenerator getMachineCodeGenerator(String code) {
		return generators.get(code);
	}
}
