package supercad.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.loader.ObjLoader;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

import dressing.config.WorkspaceConfiguration;
import gdxapp.object3d.DoorHandle;
import gdxapp.object3d.GolaProfile;

public class FacadeHandleProvider {

	private List<DoorHandle> handles = new ArrayList<DoorHandle>();
	private List<GolaProfile> profiles = new ArrayList<GolaProfile>();

	private ObjLoader objLoader;
	private static FacadeHandleProvider instance;
	
	private FacadeHandleProvider() {
		loadHandles();
	}
	
	
	
	public void loadHandles() {
		loadKnobsFromDisk();
		generateProceduralModels();
	}
	
	private void generateProceduralModels() {
		GolaProfile golaProfile = new GolaProfile();
		profiles.add(golaProfile);
		Gdx.app.postRunnable( () ->  golaProfile.getModel());
	}

	private void loadKnobsFromDisk() {
		File file = new File(WorkspaceConfiguration.handlers);
		if (objLoader == null)
			objLoader = new ObjLoader();
		HashMap<String, Model> doorHandleModels = new HashMap<String, Model>();
		File jsonFile = null;
		for (File filex : file.listFiles()) {
			if (filex.getAbsolutePath().contains(".obj")) {
				doorHandleModels.put(filex.getName(), objLoader.loadModel(Gdx.files.absolute(filex.getAbsolutePath())));
			}
			if (filex.getAbsolutePath().contains(".json")) {
				jsonFile = filex;
			}
		}
		FileInputStream fis;
		try {
			fis = new FileInputStream(jsonFile);
			long size = jsonFile.length();
			byte[] buffer = new byte[(int) size];
			fis.read(buffer);
			String string = new String(buffer);
			JSONParser jsonParser = new JSONParser();
			JSONArray jsonArray = (JSONArray) jsonParser.parse(string);
			for (int i = 0; i < jsonArray.size(); i++) {
				JSONObject jsonObject = (JSONObject) jsonArray.get(i);
				String fileName = (String) jsonObject.get("fileName");
				Model model = doorHandleModels.get(fileName);
				String name = (String) jsonObject.get("name");
				UUID uuid = UUID.fromString((String) jsonObject.get("modelId"));
				String pathToPreview = jsonFile.getParentFile().getAbsolutePath() + File.separator
						+ fileName.split("\\.")[0];
				pathToPreview += ".png";
				String previewPath = (String) jsonObject.getOrDefault("preview_path", pathToPreview);
				DoorHandle handle = new DoorHandle();
				BoundingBox bounds = new BoundingBox();
				model.calculateBoundingBox(bounds);
				Vector3 dimensions = new Vector3();
				bounds.getDimensions(dimensions);
				handle.setModel(model);
				handle.setDimension(dimensions);
				handle.setModelId(uuid);
				handle.setName(name);
				handle.setPreviewPath(previewPath);
				handles.add(handle);
			}
		} catch (IOException | ParseException e1) {
			e1.printStackTrace();
		}
	}
	
	public List<DoorHandle> getHandlers() {
		return handles;
	}
	
	
	public DoorHandle getHandleById(UUID id) {
		DoorHandle lookedFor = null;
		for(DoorHandle handle: handles) {
			if(handle.getModelId().equals(id)) {
				lookedFor = handle;
				break;
			}
		}
		if(lookedFor == null) {
			for(DoorHandle handle: profiles) {
				if(handle.getModelId().equals(id)) {
					lookedFor = handle;
					break;
				}
			}
		}
		return lookedFor;
	}
	
	



	public static FacadeHandleProvider getInstance() {
		if(instance == null)
			instance = new FacadeHandleProvider();
		return instance;
	}



	public List<GolaProfile> getProfiles() {
		return profiles;
	}



	public static void setInstance(FacadeHandleProvider instance) {
		FacadeHandleProvider.instance = instance;
	}
	
	
}
