package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.config.UserPreference;
import dressing.model.ProjectManager;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.object3d.Wall;
import geometry.CompoundObject;
import geometry.CompoundShape;
import geometry.ShapeDrawer;

public class WallConfigWizardFormPage extends WizardPage implements PropertyChangeListener, FinalPage {
	

	public WallConfigformComposite getComposite() {
		return composite;
	}

	public void setComposite(WallConfigformComposite composite) {
		this.composite = composite;
	}
	CompoundObject temporaryObject;
	CompoundShape border;
	private Wall wallBuilding;
	private WallConfigformComposite composite;
	private int hauteur ;
	private int epaisseur ;
	
	protected WallConfigWizardFormPage() {
		super("");
		setTitle("Apparence des murs");
		this.wallBuilding =new Wall(UserPreference.getPreference().getScenePreferences().getWallHeight(), UserPreference.getPreference().getScenePreferences().getWallwidth());
		CompoundShape perimeter = ShapeDrawer.getInstance().getTemporaryObject().getBorder().cpy();
		for(var shape: perimeter.getNodes()) {
			shape.setWinding(1);
		}
		this.wallBuilding.setPerimeter(perimeter);
		
		this.wallBuilding.addPropertyChangeListener(this);
		
	}
	
	@Override
	public void createControl(Composite parent) {
		composite = new WallConfigformComposite(parent, SWT.EMBEDDED);
		composite.setWall(wallBuilding);
		setControl(composite);
		getContainer().updateButtons();
		
	}
	
	@Override
	public boolean isPageComplete() {
		return(composite!=null && composite.getAlbedoMap() != null && composite.getWallStyle() !=null);
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent arg0) {
		if(isCurrentPage())
		{
			if (WallConfigWizardFormPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}

	public void clearlistners() {
		wallBuilding.removePropertyChangeListener(this);
	}

	@Override
	public void onHide() {
		clearlistners();
		composite.updateWall();
		ProjectManager.getManager().getCurrentScene().addActor(wallBuilding, true);
		
		ShapeDrawer.getInstance().finish();
		
		
	}

			
			
}
