package dressing.ui.parts;


import java.io.File;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.ui.TexturesComposite;

public class Textures {
	
	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;
	TexturesComposite  list=null;


	@Inject
	private MDirtyable dirty;
	/**
	 * Create contents of the view part.
	 */

	@PostConstruct
	public void postConstruct(Composite parent) {

		list =new  TexturesComposite(parent,commandService,handlerService, SWT.NONE); 
		
		list.pack();
		parent.requestLayout();

	}
	@PreDestroy
	public void dispose() {
		if(list!= null)
		{
			list.dispose();
			list = null;
		}
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
	public void refresh() {
		if(list!=null) {
			list.refresh();
		}
	}
	public void addTexture(File file) {
		if(list!=null) {
			list.addElement(file);
		}
	}
}
