package dressing.ui.engine3d.sceneconfig;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.assets.AssetsTextures;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;
import groovyjarjarantlr.debug.NewLineEvent;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class FloorSettingComposite extends Composite implements PropertyChangeListener{

	private ScenePreferences preferences;
	private TableComboViewer tcvTexture;
	private Button btnPreview;
	private PbrMaterial floorMtl;
	
	SingleImageItemLabelProvider labelProvider;
	
	public FloorSettingComposite(Composite parent, int style, ScenePreferences preferences) {
		super(parent, style);
		this.preferences = preferences;
		this.floorMtl = preferences.getFloorMtl();
		setLayout(new GridLayout(1, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setLayout(new GridLayout(1, false));
		
		CBanner banner = new CBanner(composite, SWT.NONE);
		banner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		banner.setRightWidth(300);
		banner.setRightMinimumSize(new Point(300, 300));
		banner.setLocation(0, 0);
		
		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_1);
		GridLayout gl_composite_1 = new GridLayout(1, true);
		gl_composite_1.marginBottom = 50;
		gl_composite_1.marginTop = 50;
		composite_1.setLayout(gl_composite_1);
		
		Composite composite_3 = new Composite(composite_1, SWT.NONE);
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_3.setLayout(new GridLayout(2, false));
		
		labelProvider = new SingleImageItemLabelProvider(composite_3);
		
		
		Label lblTexture = new Label(composite_3, SWT.NONE);
		lblTexture.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
		lblTexture.setText("Motif");
		
		tcvTexture = new TableComboViewer(composite_3, SWT.NONE);
		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				textureChanged();
			}
		});
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setLabelProvider(labelProvider);
		tcvTexture.setInput(ModelProvider.getMaterialsByCategory(CATEGORY.FLOOR));
		
		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_2);
		composite_2.setLayout(new GridLayout(1, false));
		
		btnPreview = new Button(composite_2, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		if(preferences!=null && preferences.getFloorMtl()!=null) {
			tcvTexture.setSelection(new StructuredSelection(ModelProvider.findMaterial(CATEGORY.FLOOR, preferences.getFloorMtl().getName())));
		} 
	}
	
	
	protected void textureChanged() {
		floorMtl = (PbrMaterial) tcvTexture.getStructuredSelection().getFirstElement();
		if(floorMtl != null) {
			btnPreview.setImage(ModelProvider.getTexture(floorMtl.getAlbedoMapPath()).getPreview());
			apply();
		}
	}
	
	
	public void apply() {
		preferences.setFloorMtl(floorMtl);
	}


	@Override
	public void propertyChange(PropertyChangeEvent arg0) {
		
	}
}
