package dressing.ui.porte;

import java.awt.print.Pageable;
import java.util.HashMap;

import javax.inject.Inject;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.controller.PorteCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;



public class PorteWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;

	Space3D space3d;
	PorteCreator portefactory=new PorteCreator();
	PorteWelcomePage welcompage;

	public PorteWizard () {
		setWindowTitle("Nouvelle porte");		
		//init

	}

	@Override
	public void addPages() {
		welcompage = new PorteWelcomePage("WelcomePage",portefactory);
		addPage(welcompage);		

	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {			
				portefactory.create();
				welcompage.clearlistners();
				
				
				for(Piece2D porte:portefactory.getPorteList()) {
					this.space3d.addElement(porte);	
				}
				if(space3d!=null&& space3d.getParentdesign()!=null &&space3d.getParentdesign() instanceof Separator) {
					space3d.getParentdesign().propagateUpdateToChildrens(null);
				}
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

				
			return true;
	}
	
public void setSpace3D(Space3D space3d) {
	this.space3d = space3d;	
	portefactory.setParent(space3d);
}
	@Override
public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
}
