package dressing.model.debitage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;

public class Debitage {
ArrayList<Equation> equations = new ArrayList<Equation>();
DesignObject3D parent;
DesignObject3D child;
PropertyChangeListener pcl = null;

HashMap<String, String> exportlist = new HashMap<String, String>();
public ArrayList<Equation> getEquations() {
	return equations;
}
public void setEquations(ArrayList<Equation> equations) {
	this.equations = equations;
}
public DesignObject3D getParent() {
	return parent;
}
public void setParent(DesignObject3D parent) {
	this.parent = parent;
}
public DesignObject3D getChild() {
	return child;
}
public void setChild(DesignObject3D child) {
	this.child = child;
}
public void createupdateDebitage() throws DesignException
{
	if(parent==null || child==null)
		throw new DesignException("Debitage parent ou child null");
	DebitageFormulas formulas=null;
	if(child instanceof DesignObject3D) {
		formulas =child.getDebitageFormulas();
	}else {
		formulas = new DebitageFormulas();
	}
	formulas.FILL_DEBITAGE_FORMULAS(parent, child, equations);
}
public void evaluate() throws GeometricEngineException
{
	DebitageFormulas.EVALUATE(equations);
}
public HashMap<String, String> getExportlist() {
	return exportlist;
}
public void dispose() {
	if(equations!=null)equations.clear();
	if(exportlist!=null)exportlist.clear();
	exportlist=null;
	equations=null;
	parent=null;
	child=null;
}
 
}
