package dressing.handlers.gdx;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

import dressing.model.ProjectManager;
import dressing.cam.model.PlanUsinage;
import dressing.ui.cam.parts.GcodeEditorPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.ActionController;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.room3d.Room3DController;
import gdxapp.screens.room3d.Room3DScreen;

public class Camera3DMoveTo {
	
	@Execute
	public void execute(ParameterizedCommand command) {
		if(Scene.game.getScreen() instanceof Room3DScreen) {
			Room3DController controller=((Room3DScreen)Scene.game.getScreen()).getController();
			if(controller!=null && controller instanceof Room3DController && controller.getCameraController().getCamera()!=null) {
				if(command.getParameterMap().get("dressing.commandparameter.camera.move.to.direction")!=null)
				{
				
					String persp = (String) command.getParameterMap().get("dressing.commandparameter.camera.move.to.direction");
					switch (persp) {
					case "up":
						controller.getCameraController().moveVertically(0.1f);

						break;
					case "down":
						controller.getCameraController().moveVertically(-0.1f);

						break;
					case "left":
						controller.getCameraController().moveLaterally(-0.1f);
						break;
					case "right":
						controller.getCameraController().moveLaterally(0.1f);
			        	 break;
					case "back":
						controller.getCameraController().moveForward(-0.1f);
						break;
					case "forward":
						controller.getCameraController().moveForward(0.1f);
			        	 break;
					case "adjust":
						controller.getCameraController().reset();
			        	 break;
					default:
						break ;
					}

				}
			}
		}
		
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}

}
