 
package dressing.handlers.cam;

import java.io.File;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import com.badlogic.gdx.Gdx;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.handlers.AddDressingWizardHandler;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import param.Material;
import param.MaterialType;
import param.MechanicDesign;
import param.MechanicDesignGroup;

public class ImportprojectDressings {
	@Execute
	public void execute(Shell shell) {
		FileDialog dialog = new FileDialog(shell, SWT.OPEN);
		dialog.setFilterExtensions(new String[] { "*.sdress" });
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath = projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryread", defaultpath);

		dialog.setFilterPath(dirpath);
		String filepath = dialog.open();
		if (filepath != null && !filepath.isEmpty()) {
			File f = new File(filepath);
			URI uri=URI.createFileURI(f.getAbsolutePath());
			Resource ress =ResourceManagers.getIntance().loadResource(uri);
			if(ress!=null&& ress.getContents()!=null) {
				for(EObject obj:ress.getContents()) {
					 if(obj instanceof MechanicDesign)
					 {
						 AddDressing((MechanicDesign) obj);	
					 }else if(obj instanceof MechanicDesignGroup){
						 MechanicDesignGroup group=(MechanicDesignGroup) obj;
						 for(MechanicDesign dressing:group.getMechanicdesign()) {
							 AddDressing(dressing);
						 }
					 }
				}
			}
			dirpath = f.getParent();
			projectpref.put("directoryread", dirpath);
			try {
				projectpref.flush();
			} catch (BackingStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		
	}
	
	public void AddDressing(MechanicDesign obj) {
		try {
			fixMechnicDeisign(obj);
			DesignObject3D  designObject = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(),
						null, null, (MechanicDesign) obj, MechanicDesignCreator.create,false);
			ProjectManager.getManager().getCurrentKitchen().addElement(designObject);
			WorldObject object = WorldObjectFactory.getFactory().createObjectFromDefinition(designObject);
			((AbstractScreen) Scene.game.getScreen()).getController().dropActor(object,
					Gdx.graphics.getWidth()/2, Gdx.graphics.getHeight()/2 );
		} catch (DesignException | GeometricEngineException e) {
			
			e.printStackTrace();
		}	
	}
	private void fixMechnicDeisign(MechanicDesign obj) {
		
		try {
			//replace original materialTypes with local MaterialTypes for easy manip
			MaterialType facadematerialType = ModelProvider.getMaterialTypeByName(obj.getFacadeMaterialType().getMaterial().getName());
			if(facadematerialType!=null)
			{
				obj.getFacadeMaterialType().setMaterial(facadematerialType);	
			}
			if(obj.getFacadeMaterialType().getTexture()!=null && !obj.getFacadeMaterialType().getTexture().isEmpty()) {
				obj.getFacadeMaterialType().setTexture(getlocalTexturePath(obj.getFacadeMaterialType().getTexture()));
			}
			MaterialType principalmaterialType = ModelProvider.getMaterialTypeByName(obj.getPrincipalMaterialType().getMaterial().getName());
			if(principalmaterialType!=null)
			{
				obj.getPrincipalMaterialType().setMaterial(principalmaterialType);	
			}
			if(obj.getPrincipalMaterialType().getTexture()!=null && !obj.getPrincipalMaterialType().getTexture().isEmpty()) {
				obj.getPrincipalMaterialType().setTexture(getlocalTexturePath(obj.getPrincipalMaterialType().getTexture()));
			}
			MaterialType secondmaterialType = ModelProvider.getMaterialTypeByName(obj.getSecondMaterialType().getMaterial().getName());
			if(secondmaterialType!=null)
			{
				obj.getSecondMaterialType().setMaterial(secondmaterialType);	
			}
			if(obj.getSecondMaterialType().getTexture()!=null && !obj.getSecondMaterialType().getTexture().isEmpty()) {
				obj.getSecondMaterialType().setTexture(getlocalTexturePath(obj.getSecondMaterialType().getTexture()));
			}
			//replace original materials with local Materials
			obj.setFacadeMaterial(getLocalMaterial(obj.getFacadeMaterial()));
			obj.setPrincipalmaterial(getLocalMaterial(obj.getPrincipalmaterial()));
			obj.setSecondmaterial(getLocalMaterial(obj.getSecondmaterial()));
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		
	}
	private String getlocalTexturePath(String path) {
//		String path1 =WorkspaceConfiguration.TEXTURES_FOLDER+File.separator+path;
		for(SceneTexture texture:ModelProvider.getTextures()) {
			if(texture.getPath().contentEquals(path)||texture.getPath().contains(path)) {
				return texture.getPath();
			}
		}
		
		return path;
	}
	private Material getLocalMaterial(Material mat){
		for(Material material: ModelProvider.getModelroot().getMaterialgroup().getMaterial()) {
			if(mat.getName().contentEquals(material.getName())&& mat.getEpaisseur()==material.getEpaisseur()) {
				return material;
			}
		}
		return mat;
	}
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()!=null) {
			return true;
		}
		return false;
	}	
}