package dressing.ui.util;

import javax.print.attribute.standard.SheetCollate;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Material;

import dressing.handlers.gdx.ToolControlHandler;
import dressing.model.ProjectManager;
import dressing.ui.project.SocleSettingComposite;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.PlinthObject;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.screens.room.RoomController;
import geometry.CompoundObject;
import geometry.CompoundShape;
import geometry.ShapeDrawer;

import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class PlinthCreationWindow extends Window {
	
	
	private Shell shell;
	private Composite composite ;
	
	private PlinthObject plinthObject;

	public PlinthCreationWindow(Shell parentShell, PlinthObject object) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
		this.plinthObject = object;
	}
	
	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Création du scole");
		parent.setLayout(new FillLayout());
		shell.addShellListener(getShellListener());

		composite= new SocleSettingComposite(parent, SWT.FILL, plinthObject);
		
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= PlinthCreationWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);
		getShell().setBounds((getShell().getParent().getSize().x-300)/2, (getShell().getParent().getSize().y-280)/2, 300, 280);
		return composite;

	}

	@Override
	public boolean close() {
		plinthObject.setRequireRefrech(true);
		return super.close();
	}
	
	



	
	
	
}
