package dressing.ui.modelprovders;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.config.WorkspaceConfiguration;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Tirroir;
import dressing.model.TreeElement;
import dressing.model.types.PieceType;
import dressing.model.types.Zone3DType;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;

public class TreeElementLabelProvider extends LabelProvider implements IStyledLabelProvider {

	public TreeElementLabelProvider() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public StyledString getStyledText(Object element) {
		String label = "unnamed";
		if(element!=null && element instanceof TreeElement) {
			label = ((TreeElement)element).getNodeName();

		}else if (element!=null && element instanceof DesignObject3D) {
			label = ((DesignObject3D)element).getName();
    	}
		StyledString text=new StyledString(label);
		
        return text;
    }

	@Override
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		String s =null;
		if(element instanceof TreeElement) {
			s = ((TreeElement)element).getLabelIconPath();		
		} else if(element instanceof CaissonCuisine||element instanceof Space3DFree){
			s="caissoncuisine.png";
		}else if (element instanceof Caisson) {
			s= "caissonIcon16.png";
		}else if(element instanceof Dressing)
		{
			s="dressing.png";
		}else if(element instanceof Etagere) {
			s="etagereIcon16.png";
		}else if(element instanceof Tirroir) {
			s="tiroirIcon16.png";
		}
		else if(element instanceof Separator) {
			s="seperateur16.png";
		}
		
		else if(element instanceof Piece2D)
		{
			Piece2D piece=(Piece2D)element;
			if(piece.getPiecetype().equals(PieceType.PORTE)||piece.getPiecetype().equals(PieceType.FACADE)
					||piece.getPiecetype().equals(PieceType.FAUSSE_FACADE)
					||piece.getPiecetype().equals(PieceType.FACADE_INTERIEUR_TIROIR)||piece.getPiecetype().equals(PieceType.FACADE_EXTERIEUR_TIROIR)) {
				s="singleporteIcon.png";
			}else if(piece.getPiecetype().equals(PieceType.PORTE_DROITE)||piece.getPiecetype().equals(PieceType.PORTE_GAUCHE)
					||piece.getPiecetype().equals(PieceType.PORTE_HAUT)||piece.getPiecetype().equals(PieceType.PORTE_BAS)) {
				s="porte16.png";
			}
			else if(piece.getPiecetype().equals(PieceType.HAUT_CUISSON)) {
				s="hautIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.BAS_CUISSON)||piece.getPiecetype().equals(PieceType.BAS_TIROIR)) {
				s="basIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.DROITE_CUISSON)||piece.getPiecetype().equals(PieceType.COTE_DROITE_TIROIR)) {
				s="droiteIcon16.png";
			}else if(piece.getPiecetype().equals(PieceType.GAUCHE_CUISSON)||piece.getPiecetype().equals(PieceType.COTE_GAUCHE_TIROIR)) {
				s="gaucheIcon16.png";
			}else  {
				s="piece16.jpg";
			}
			
		
		}else if(element instanceof Space3D )
		{
			Space3D space=(Space3D)element;
			if(space.getZonetype().equals(Zone3DType.ZONEHAUT)) {
				s="zonehautIcon16.png";
			}else if(space.getZonetype().equals(Zone3DType.ZONEBAS)) {
				s="zonebasIcon16.png";
			}
			
		}
		else if(element instanceof Project3D)
		{
			s="project3d.png";
		}
		if(s !=null)
		{
			URL url = null;
			Image im = null;
			try {
				url = new File(WorkspaceConfiguration.ICONS + File.separator + s).toURL();
				ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
				ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
				 im = rsmanager.createImage(descriptor);
			} catch (MalformedURLException e) {
				e.printStackTrace();
			}
			
			return im;
		}
		return super.getImage(element);
	}

}
