package dressing.model.usinage;

import java.util.ArrayList;

import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Rotationangle;
import dressing.config.ReportingPreferences;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Intervale;
import dressing.model.Piece2D;
import dressing.model.Plan3D;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.DesignType;
import dressing.cam.model.DXF_STATIC_VALUE;
import tech.frsdev.graphunit.PLineDXFEntity;
import tech.frsdev.graphunit.PointDXF;
import tech.frsdev.graphunit.PolyLineDXFEntity;

public class Rainure extends Usinage {

	boolean exist=true;
	public float epaisseur ;
	ArrayList<PLineDXFEntity> listRainure =new ArrayList<PLineDXFEntity>();
	public static Rainure rainureinstance=new Rainure();

	public static Rainure getRainureinstance() {
		return rainureinstance;
	}

	public static void setRainureinstance(Rainure rainureinstance) {
		Rainure.rainureinstance = rainureinstance;
	}
	
	@Override
	public void updateproperties() throws GeometricEngineException {
		if(getDesignType() !=null && getDesignType().equals(DesignType.GENERIC)) {
			super.updateproperties();
			return;
		}
		DesignObject3D parent=getParentdesign();
		if(parent==null ) {
			throw new GeometricEngineException("le Piece parent de cette rainure "+getName()+" est inexistent il faut l'insérer");
		}
		
		if(getMother()==null) {
			throw new GeometricEngineException("le dos de cette rainure "+getName()+" est inexistent il faut l'insérer");
		}
		double xpos=getXpos();
		double ypos=getYpos();
		double zpos=getZpos();
		
		double longeur=getLongeurext();
		double hauteur=getHauteurext();
		double profondeur=getProfondeurext();
		Plan3D inter = parent.getIntersect(getMother());
		
		Intervale xinter=inter.getXinter();
		Intervale yinter=inter.getYinter();
		Intervale zinter=inter.getZinter();
		
		if(xinter==null||yinter==null||zinter==null) {
			this.exist=false;
		}else {
			this.exist=true;
			try {
				xpos=xinter.getMininter();
				ypos=yinter.getMininter();
				zpos=zinter.getMininter();
				
				longeur=xinter.getlong();
				hauteur=yinter.getlong();
				profondeur=zinter.getlong();

			} catch (NullPointerException e) {
				e.printStackTrace();
			}
			setXpos(xpos-parent.getXPosABS());
			setYpos(ypos-parent.getYPosABS());
			setZpos(zpos-parent.getZPosABS());
			
			setLongeurext(longeur);
			setLongeurint(longeur);
			
			setHauteurext(hauteur);
			setHauteurint(hauteur);

			setProfondeurext(profondeur);
			setProfondeurint(profondeur);
		}

		

	}

	public double getRainureLength() {
		return Math.max(Math.max(getLongeurext(), getHauteurext()), getProfondeurext());
	}
	
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la longur de piece sur le plan spécifier
	 */	
	public double getWidth(PlanUsinage pl) {
		// TODO Auto-generated method stub
		float width = 0;
		float height = 0;
		switch (pl) {
		case FRONT:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;
		case BACK:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;

		case RIGHT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case LEFT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case DOWN:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		case TOP:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		default:
			break;
		}
		return width;
	}
	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la hauteur de piece sur le plan spécifier
	 */	
	public double getHight(PlanUsinage pl) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		float width = 0;
		float height = 0;
		switch (pl) {
		case FRONT:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;
		case BACK:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;

		case RIGHT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case LEFT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case DOWN:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		case TOP:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		default:
			break;
		}

		return height;
	}

	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la dxf represente le rainure actuelle sur le plan spécifier
	 */	
	public String getDXFLineEntetity(PlanUsinage persp,Rotationangle anglerotation) {
		float width = (float) this.getWidth(persp);
    	float height=(float) this.getHight(persp);
    	
 
    	String s="";
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF origin = getOrigin(persp,(Piece2D)getParentdesign());

        //ligne 1 
        PointDXF p1 = origin.getLocation();
        PointDXF p2 = p1.getLocation();
        p2.x += width;

        //ligne2
        PointDXF p3 = p2.getLocation();
        p3.y += height;

        //ligne 3 
        PointDXF p4 = p1.getLocation();
        p4.y += height;


        if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
            line1 = new PLineDXFEntity(p1, p2);
            line2 = new PLineDXFEntity(p2, p3);
            line3 = new PLineDXFEntity(p1, p4);
            line4 = new PLineDXFEntity(p4, p3);

            //Create String seintity
            s += line1.getDXFLineEntetity();
            s += line2.getDXFLineEntetity();
            s += line3.getDXFLineEntetity();
            s += line4.getDXFLineEntetity();
        }
        else
        {
            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
            poly.addVertices(p1);
            poly.addVertices(p2);
            poly.addVertices(p3);
            poly.addVertices(p4);
            poly.addVertices(p1);
            s +=  poly.getDXFEntity( anglerotation);
        }
        return s;
	}
	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la point d'origine de ce rainure sur le plan spécifier
	 */	
	public PointDXF getOrigin(PlanUsinage persp, Piece2D piece2d) {
				PointDXF centre = new PointDXF(0, 0); 
				float width = (float) piece2d.getWidth(persp);
				float height = (float) piece2d.getHight(persp);
				
				
				switch (persp) {
				case FRONT:
					centre.x = (float) getXpos();
					centre.y = (float) getYpos();
					break;
				case BACK:
					centre.x = (float) (width - getXpos() - getLongeurext());
					centre.y = (float) getYpos();
					break;

				case RIGHT:
					centre.x = (float) (width - getZpos() - getProfondeurext());
					centre.y = (float) getYpos();
					break;
				case LEFT:
					centre.x = (float) (getZpos());
					centre.y = (float) getYpos();
					break;
				case DOWN:
					centre.x = (float) getXpos();
					centre.y = (float) getZpos();
					break;
				case TOP:
					centre.x = (float) getXpos();
					centre.y = (float) (height - getZpos() - getProfondeurext());
					break;
				default:
					break;
				}
				return centre;
				
	}
	
	public Vector3 getRainureAxe() {
		double rainurelength = Math.max(Math.max(getLongeurext(), getHauteurext()), getProfondeurext());
		if(rainurelength == getLongeurext()) {
			return Vector3.X;
		}else if(rainurelength == getHauteurext()) {
			return Vector3.Y;
		}else {
			return Vector3.Z;
		}	
	}
	public String getDXFLineEntetityassemble(PlanUsinage persp, ArrayList<Rainure> listrainure1, Piece2D parentpiece,Rotationangle anglerotation) {
		listRainure.clear();
		PointDXF p1 = new PointDXF();
		PointDXF p2 = new PointDXF();
		PointDXF p3 = new PointDXF();
		PointDXF p4 = new PointDXF();
	

		ArrayList<PLineDXFEntity> listdxflineaGenerer = new ArrayList<PLineDXFEntity>();
		ArrayList<PLineDXFEntity> listdxfsameaxeX = new ArrayList<PLineDXFEntity>();
		ArrayList<PLineDXFEntity> listdxfsameaxeY = new ArrayList<PLineDXFEntity>();
		for (Rainure rn : listrainure1) {
			float width = (float) rn.getWidth(persp);
			float height = (float) rn.getHight(persp);
			
			this.epaisseur=Math.min(height , width );

			PointDXF origin =rn.getOrigin(persp, parentpiece);
			
			// ligne 1
			if (height < width) {
				p1 = origin.getLocation();
				p2 = p1.getLocation();
				p2.x += width;

				// ligne2
				p3 = p2.getLocation();
				p3.y += height;

				// ligne 3
				p4 = p1.getLocation();
				p4.y += height;

			}
			if (width < height) {
				p1 = origin.getLocation();
				p2 = p1.getLocation();
				p2.y += height;

				// ligne2
				p3 = p2.getLocation();
				p3.x += width;

				// ligne 3
				p4 = p1.getLocation();
				p4.x += width;

			}
// on represent les rainure par des demi ligne passant par l'axe de rainure 
			PointDXF pstart = new PointDXF();
			PointDXF pend = new PointDXF();
			PLineDXFEntity axerainure = new PLineDXFEntity(pstart, pend);
			if (epsilonEquals(p1.x, p4.x, 0.1f)) {
				pstart = p1.getLocation();
				float y = Math.min(height / 2, width / 2);
				pstart.y += y;

				pend = p3.getLocation();
				pend.y = pstart.y;
				axerainure = new PLineDXFEntity(pstart, pend);
				listRainure.add(axerainure);
			}
			if (epsilonEquals(p1.y, p4.y, 0.1f)) {
				pstart = p1.getLocation();
				float x = Math.min(width / 2, height / 2);
				pstart.x += x;

				pend = p3.getLocation();
				pend.x = pstart.x;
				axerainure = new PLineDXFEntity(pstart, pend);
				listRainure.add(axerainure);
			}
		}
		String s = "";
		listdxflineaGenerer = testingAdjacentRainurefixed(listRainure, listdxfsameaxeX, listdxfsameaxeY);
		if (listdxflineaGenerer != null) {
			for (PLineDXFEntity line : listdxflineaGenerer) {
				PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
				if (ReportingPreferences.getInstance().getProperty("DXF.VueRainureLine", true)) {

					poly.addVertices(line.Satrtpoint);
					poly.addVertices(line.EndPoint);
					poly.addVertices(line.Satrtpoint);
					s += poly.getDXFEntity(anglerotation);
				} else {
					// pour créer un rainure rectangle on discute le sens de propagation de rainure et en crée les 4 point composante de rectangle en ajoutant l'epaisseure
					if (epsilonEquals(line.Satrtpoint.x, line.EndPoint.x, 0.1f)) {
						PointDXF X1 = new PointDXF();
						PointDXF X2 = new PointDXF();
						PointDXF X3 = new PointDXF();
						PointDXF X4 = new PointDXF();

						float ys = line.Satrtpoint.y;
						float x = line.Satrtpoint.x;
						float ye = line.EndPoint.y;

						X1.x = x - this.epaisseur/2;
						X1.y = ys;

						X2.x = x - this.epaisseur/2;
						X2.y = ye;

						X3.x = x + this.epaisseur/2;
						X3.y = ye;

						X4.x = x + this.epaisseur/2;
						X4.y = ys;

						poly.addVertices(X1);
						poly.addVertices(X2);
						poly.addVertices(X3);
						poly.addVertices(X4);
						poly.addVertices(X1);
						  
				        	  s +=  poly.getDXFEntity(anglerotation);
				        
				       
					}
					if (epsilonEquals(line.Satrtpoint.y, line.EndPoint.y, 0.1f)) {
						PointDXF X1 = new PointDXF();
						PointDXF X2 = new PointDXF();
						PointDXF X3 = new PointDXF();
						PointDXF X4 = new PointDXF();
						float xs = line.Satrtpoint.x;
						float y = line.Satrtpoint.y;
						float xe = line.EndPoint.x;

						X1.x = xs;
						X1.y = y - this.epaisseur/2;

						X2.x = xe;
						X2.y = y - this.epaisseur/2;

						X3.x = xe;
						X3.y = y + this.epaisseur/2;

						X4.x = xs;
						X4.y = y + this.epaisseur/2;

						poly.addVertices(X1);
						poly.addVertices(X2);
						poly.addVertices(X3);
						poly.addVertices(X4);
						poly.addVertices(X1);
						 
								  s +=  poly.getDXFEntity(anglerotation);  
							
				        	 
				        	  
				          }

					}

				}
			
		}

		return s;
	}
	
	
	
	private ArrayList<PLineDXFEntity> testingAdjacentRainurefixed(ArrayList<PLineDXFEntity> listRainure2,ArrayList<PLineDXFEntity> listdxfsameaxeX,ArrayList<PLineDXFEntity> listdxfsameaxeY) {
		ArrayList<PLineDXFEntity> listdxflineaGenerer = new ArrayList<PLineDXFEntity>();
			int j = listRainure2.size();
			if (j>0) {
			for (PLineDXFEntity axerainuredxf : listRainure2) {
			if(	epsilonEquals( axerainuredxf.Satrtpoint.x,axerainuredxf.EndPoint.x, 0.1f)) {
				
				listdxfsameaxeX.add(axerainuredxf);
				
			}
			if(	epsilonEquals(axerainuredxf.Satrtpoint.y,axerainuredxf.EndPoint.y,0.1f)) {
				
				listdxfsameaxeY.add(axerainuredxf);
				
				}
				else continue;
				
			}
				
				
		}
			
		if (listdxfsameaxeY != null && listdxfsameaxeY.size() > 0) {
			ArrayList<PLineDXFEntity> nonAssembledY = new ArrayList<PLineDXFEntity>();
			assembleRainureY(listdxfsameaxeY, nonAssembledY);
			listdxflineaGenerer.addAll(nonAssembledY);
			listdxflineaGenerer.addAll(listdxfsameaxeY);
		}
		if (listdxfsameaxeX != null && listdxfsameaxeX.size() > 0) {
			ArrayList<PLineDXFEntity> nonAssembledX = new ArrayList<PLineDXFEntity>();
			assembleRainureX(listdxfsameaxeX, nonAssembledX);
			listdxflineaGenerer.addAll(nonAssembledX);
			listdxflineaGenerer.addAll(listdxfsameaxeX);
		}
		      
		        return listdxflineaGenerer;
			
	}
	private void assembleRainureY(ArrayList<PLineDXFEntity> listdxfsameaxeY, ArrayList<PLineDXFEntity> nonAssembledY) {
		PLineDXFEntity matchedrainure=null;
		if (listdxfsameaxeY.size() > 1) {
			int i = 0;
			float x1 = listdxfsameaxeY.get(0).Satrtpoint.x;
			float x = listdxfsameaxeY.get(0).EndPoint.x;
			float y = listdxfsameaxeY.get(0).EndPoint.y;
			PLineDXFEntity lineatester =listdxfsameaxeY.get(0);
			listdxfsameaxeY.remove(0);
			
			for (PLineDXFEntity axerainuredxfy : listdxfsameaxeY) {
				
				if ((epsilonEquals(axerainuredxfy.Satrtpoint.y, y,0.1f)) && ((Math.abs(axerainuredxfy.Satrtpoint.x - x) < 20)
						&& (Math.abs(axerainuredxfy.Satrtpoint.x - x) > 0))
						||((Math.abs(axerainuredxfy.EndPoint.x - x1) < 20)
								&& (Math.abs(axerainuredxfy.EndPoint.x - x1)>0))) {
					matchedrainure=axerainuredxfy;
					break;
					
				}
				i++;
			}
			if (matchedrainure != null) {
				PointDXF p1 = new PointDXF();
				PointDXF p2 = new PointDXF();
				p1.x = x1;
				p1.y = y;
				p2.y = y;
				p2.x = matchedrainure.EndPoint.x;
				PLineDXFEntity axerainureassemble = new PLineDXFEntity(p1, p2);
				listdxfsameaxeY.remove(matchedrainure);
				listdxfsameaxeY.add(0, axerainureassemble);
				assembleRainureY(listdxfsameaxeY, nonAssembledY);
			} else {
				nonAssembledY.add(lineatester);
			}
		}			
	
	}
	private void assembleRainureX(ArrayList<PLineDXFEntity> listdxfsameaxeX, ArrayList<PLineDXFEntity> nonAssembledX) {
		PLineDXFEntity matchedrainure = null;
		if (listdxfsameaxeX.size() > 1) {
			float y1 = listdxfsameaxeX.get(0).Satrtpoint.y;
			float x = listdxfsameaxeX.get(0).EndPoint.x;
			float y = listdxfsameaxeX.get(0).EndPoint.y;
			PLineDXFEntity lineatester = listdxfsameaxeX.get(0);
			listdxfsameaxeX.remove(0);
			for (PLineDXFEntity axerainuredxfx : listdxfsameaxeX) {
				if  ((epsilonEquals(axerainuredxfx.Satrtpoint.x, x, 0.1f))
						&& ((Math.abs(axerainuredxfx.Satrtpoint.y - y) < 20)
								&& (Math.abs(axerainuredxfx.Satrtpoint.y - y) > 0))
						|| ((Math.abs(axerainuredxfx.EndPoint.y - y1) < 20)
						&& (Math.abs(axerainuredxfx.EndPoint.y - y1)>0))) {
					matchedrainure = axerainuredxfx;
					break;
				}
			}
			if (matchedrainure != null) {
				PointDXF p1 = new PointDXF();
				PointDXF p2 = new PointDXF();
				p1.x = x;
				p1.y = y1;
				p2.y = matchedrainure.EndPoint.y;
				p2.x = x;
				PLineDXFEntity axerainureassemble = new PLineDXFEntity(p1, p2);
				listdxfsameaxeX.remove(matchedrainure);
				listdxfsameaxeX.add(0, axerainureassemble);

				assembleRainureX(listdxfsameaxeX,nonAssembledX);

			}else {
				nonAssembledX.add(lineatester);	
			}

		}
	
	}

	@Override
	public DesignObject3D clone() {
		Rainure space=new Rainure();
		try {
			space=(Rainure) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Rainure rainure=(Rainure) object;
		rainure=(Rainure) super.copy(rainure);
		return rainure;
	}
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof DebitageFormulas)) {
			formulas = new DebitageFormulas();
		}
		return formulas; 
	}
	public static boolean epsilonEquals(float f1, float f2, float epsilon) {
        return (f1 + epsilon >= f2 && f1 - epsilon <= f2);
    }
	
}
