package model.caisson;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.Caisson;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.ProjectParent;
import dressing.model.Space3D;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PortType;
import utils.ParametersProvider;
import utils.TestModelProvider;

public class CommonCaissonDressing {
	ProjectParent parent=null;
	Project3D project3d = null;
	public Dressing dressing = null;
	public Caisson caisson =null;
	public Piece2DCreator piece2dCreator=null;
	dressing.controller.CaissonCreator ccreator=null;
	Materiaux mdf18;
	Materiaux mdf5;
	public final static  double LONGEUR = 3000;
	public final static  double HAUTEUR = 2500;
	public final static  double PROFONDEUR = 650;	
	@Before
	public void setUp() throws Exception {
		TestModelProvider modelprovider=new TestModelProvider();
		mdf18=(Materiaux) modelprovider.getMateriallist().get(0);
		mdf5=(Materiaux) modelprovider.getMateriallist().get(1);
		ParametersProvider paramsprovider=new ParametersProvider();
		paramsprovider.fillparamList();
		 parent  = ModelProvider.RootInstance();
		 parent.getProjects().clear();
		 project3d= new Project3D();
		 parent.addProject(project3d, false);
		 assertNotNull(project3d);
		 assertNotNull(parent);
		 assertNull(project3d.getParentdesign());
		 assertEquals(1, parent.getProjects().size());
		 assertEquals(project3d, parent.getProjects().get(0));
			//
		 	dressing = new Dressing();

			dressing.setAppartement("appartement");
			dressing.setEtage("etage");
			dressing.setName("dressing");
			dressing.setChantier(project3d.getName());
			//
			dressing.setHauteurext(HAUTEUR);
			dressing.setLongeurext(LONGEUR);
			dressing.setProfondeurext(PROFONDEUR);
			dressing.setBasematerial(mdf18);
			dressing.setBackmaterial(mdf5);
			dressing.setPorttype(PortType.FRANCAISE);
			dressing.setCaissonmontageType(CaissonMontageType.CAISSON_MONTAGE_I);
			dressing.setDostype(DosType.DOSINTERIEUR);
			dressing.setParentdesign(project3d);
			dressing.constructDebitage();
			dressing.evaluate();
			project3d.addElement(dressing);
			ccreator=new dressing.controller.CaissonCreator();
			ccreator.setParent(dressing);
			ccreator.setHauteur(HAUTEUR);
			ccreator.setLongeur(LONGEUR);
			ccreator.setProfondeur(PROFONDEUR);
	}


}
