package gdxapp.object3d;

import java.util.ArrayList;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;

public class ContainerBox {

	WorldObject contained;
	private Vector3 center;
	private Vector3 v000;
	private Vector3 v001;
	private Vector3 v010;
	private Vector3 v011;
	private Vector3 v100;
	private Vector3 v101;
	private Vector3 v110;
	private Vector3 v111;
	private Surface top, bottom, right, left, face, back;
	private Matrix3 transform;
	
	
	
	public ContainerBox() {}

	public ContainerBox(WorldObject contained) {
		this.contained = contained;	
	}
	
	public void update() {
		center = contained.getRealWorldPosition();
		float hWidth, hHeight, hDepth;
		hWidth = contained.getRealWorldDimension().x * 0.5f;
		hHeight = contained.getRealWorldDimension().y * 0.5f;
		float z = Math.max(contained.getRealWorldDimension().z, contained.getRealWorldDimension().w);
		hDepth = z * 0.5f;
		if(v000 == null)
			v000 = new Vector3();
		v000.set(center.x - hWidth, center.y - hHeight, center.z - hDepth);
		if(v001 == null)
			v001 = new Vector3();
		v001.set(center.x - hWidth, center.y - hHeight, center.z + hDepth);
		if(v010 == null)
			v010 = new Vector3();
		v010.set(center.x - hWidth, center.y + hHeight, center.z - hDepth);
		if(v011 == null)
			v011 = new Vector3();
		v011.set(center.x - hWidth, center.y + hHeight, center.z + hDepth);

		if(v100 == null)
			v100 = new Vector3();
		v100.set(center.x + hWidth, center.y - hHeight, center.z - hDepth);
		if(v101 == null)
			v101 = new Vector3();
		v101.set(center.x + hWidth, center.y - hHeight, center.z + hDepth);
		if(v110 == null)
			v110 = new Vector3();
		v110.set(center.x + hWidth, center.y + hHeight, center.z - hDepth);
		if(v111 == null)
			v111 = new Vector3();
		v111.set(center.x + hWidth, center.y + hHeight, center.z + hDepth);

		calculateTransform(contained);
		v000.sub(center).mul(transform).add(center);
		v001.sub(center).mul(transform).add(center);
		v010.sub(center).mul(transform).add(center);
		v011.sub(center).mul(transform).add(center);
		
		v100.sub(center).mul(transform).add(center);
		v101.sub(center).mul(transform).add(center);
		v110.sub(center).mul(transform).add(center);
		v111.sub(center).mul(transform).add(center);
		
		defineSurfaces(contained.getRotation());
	}
	
	public void calculateTransform(WorldObject object) {
		double rotation = Math.toRadians(object.getRotation());
		Vector3 u = new Vector3((float)Math.cos(rotation),0,(float)Math.sin(-rotation));
		Vector3 w = new Vector3((float)Math.sin(rotation),0,(float)Math.cos(rotation));
		Vector3 v = new Vector3(0,1,0);
		
		float[] values = new float[] {
				u.x, u.y, u.z,
				v.x, v.y, v.z,
				w.x, w.y, w.z,
		};
		
		if(this.transform == null)
			this.transform = new Matrix3();
		this.transform.set(values);
	}
	
	
	public void defineSurfaces(float rotation) {
		if(top == null)
			top = new Surface();
		top.set(v010, v011, v111, v110);
		if(bottom == null)
			bottom = new Surface();
		bottom.set(v000, v100, v101, v001);
		if(face == null)
			face = new Surface();
		
		face.set(v011, v001, v101, v111);
		if(back == null)
			back = new Surface();
		back.set( v100, v000,v010, v110);
		if(left == null)
			left = new Surface();
		left.set(v000, v001, v011, v010);
		if(right == null)
			right = new Surface();
		right.set(v111, v101, v100, v110);
	}
	
	public ArrayList<Surface> getSurfaces(){
		ArrayList<Surface> surfaces = new ArrayList<Surface>();
		surfaces.add(top);
		surfaces.add(bottom);
		surfaces.add(left);
		surfaces.add(right);
		surfaces.add(back);
		surfaces.add(face);
		return surfaces;
	}

	//getters
	public Vector3 getCenter() {
		return center;
	}

	public Vector3 getV000() {
		return v000;
	}

	public Vector3 getV001() {
		return v001;
	}

	public Vector3 getV010() {
		return v010;
	}

	public Vector3 getV011() {
		return v011;
	}

	public Vector3 getV100() {
		return v100;
	}

	public Vector3 getV101() {
		return v101;
	}

	public Vector3 getV110() {
		return v110;
	}

	public Vector3 getV111() {
		return v111;
	}

	public Surface getTop() {
		return top;
	}

	public Surface getBottom() {
		return bottom;
	}

	public Surface getRight() {
		return right;
	}

	public Surface getLeft() {
		return left;
	}

	public Surface getFace() {
		return face;
	}

	public Surface getBack() {
		return back;
	}

	public Matrix3 getTransform() {
		return transform;
	}
	
}
