package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.ui.engine3d.sceneconfig.WallConfigComposite;
import gdxapp.scenes.ScenePreferences;

public class WallConfigWizardPage extends WizardPage implements PropertyChangeListener{
	
	private ScenePreferences preferences;
	private WallConfigComposite composite;
	
	protected WallConfigWizardPage(ScenePreferences preferences) {
		super("");
		setTitle("Apparence des murs");
		this.preferences = preferences;
		this.preferences.addPropertyChangeListener(this);
	}
	
	@Override
	public void createControl(Composite parent) {
		composite = new WallConfigComposite(parent, SWT.EMBEDDED, preferences);
		setControl(composite);
	}
	
	@Override
	public boolean isPageComplete() {
		return(composite!=null && composite.getTexture() != null && composite.getWallStyle() !=null);
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent arg0) {
		if(isCurrentPage())
		{
			if (WallConfigWizardPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}

	public void clearlistners() {
		preferences.removePropertyChangeListener(this);
	}
}
