package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.SupportMeubleBas;
import dressing.model.SupportMeubleHaut;
import dressing.model.accessoire.SupportBlocTiroir;
import dressing.model.evalutor.Equation;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.PieceType;
import dressing.model.types.SupportMeubleBasType;
import dressing.model.types.SupportMeubleHautType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;
import dressing.model.usinage.Rainure;
/**
 * ce class represente le coeur de calcul pour les piece de type Bande ,
 * pour simplifier le code de calcul des composant 3D en créer un class 
 * pour les piece ou les composant compliquées dans son calcul pour rendre le code readable et maintainable 
 * @author Imed
 *
 */
public class SuportBlocTiroirDebitageFormulas extends DebitageFormulas {

	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		if(parent instanceof Piece2D && child instanceof SupportBlocTiroir)
		{	
			Piece2D piece2d  = (Piece2D)parent;
			SupportBlocTiroir support = (SupportBlocTiroir)child;
			PieceType piecetype = piece2d.getPiecetype();
			TirroirType supportType =support.getSupportType();
			FILL_SUPPORT_BLOC_TIROIR_FROM_PARENTS(piece2d,support.getMother(), equations);
			switch (supportType) {
			
				case METABOX:
					ADDOrUpdateEquation("@this.l@", "0", Equation.CALCULATION_MANUAL,equations) ;				
					ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@usin.SupportblocTiroirMetaBoxprof@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					if(piecetype.equals(PieceType.GAUCHE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", " @Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
					}else if(piecetype.equals(PieceType.DROITE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
					}else {
						throw new DesignException(" trou d'unisnage de l'etagere ne pas supproter sur de piece autre que cote doite et gauche de la caisson");
					}
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@ + @usin.SupportblocTiroirMetaBoxhRetrait@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.SupportblocTiroirMetaBoxprof@ - @usin.SupportblocTiroirMetaBoxpRetrait@", Equation.CALCULATION_AUTO,equations) ;				
					break;
				case TENDENBOX:
					ADDOrUpdateEquation("@this.l@", "0", Equation.CALCULATION_MANUAL,equations) ;				
					ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@usin.SupportblocTiroirTendenBoxprof@ - @usin.SupportblocTiroirTendenBoxpRetrait@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					
					if(piecetype.equals(PieceType.GAUCHE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", " @Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
					}else if(piecetype.equals(PieceType.DROITE_CUISSON)) {
						ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
					}else {
						throw new DesignException(" trou d'unisnage de l'etagere ne pas supproter sur de piece autre que cote doite et gauche de la caisson");
					}
					ADDOrUpdateEquation("@this.posy@", "@Mother.posy@ + @usin.SupportblocTiroirTendenBoxhRetrait@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.SupportblocTiroirTendenBoxprof@ ", Equation.CALCULATION_AUTO,equations) ;				
						
					break;
				default:
					throw new DesignException(piecetype+" not found in debitage formula");
						
			}
			FILL_SUPPORT_BLOC_TIROIR(support, equations);		
		}else
		{
			throw new DesignException("Unkown Debitage Formula");
		}
	}
	
	
	protected  void FILL_SUPPORT_BLOC_TIROIR_FROM_PARENTS(DesignObject3D father,DesignObject3D mother,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@Parent.l@", ""+father.getLongeurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.h@", ""+father.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+father.getProfondeurext(), Equation.CALCULATION_MANUAL,equations);
		
		ADDOrUpdateEquation("@Parent.li@", ""+father.getLongeurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.hi@", ""+father.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.pi@", ""+father.getProfondeurint(), Equation.CALCULATION_MANUAL,equations);
		
		ADDOrUpdateEquation("@Parent.posx@", ""+father.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+father.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+father.getZpos(), Equation.CALCULATION_MANUAL,equations) ;	
		
		
		ADDOrUpdateEquation("@Mother.l@", ""+mother.getLongeurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.h@", ""+mother.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.p@", ""+mother.getProfondeurext(), Equation.CALCULATION_MANUAL,equations);
		
		ADDOrUpdateEquation("@Mother.li@", ""+mother.getLongeurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.hi@", ""+mother.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Mother.pi@", ""+mother.getProfondeurint(), Equation.CALCULATION_MANUAL,equations);
		
		ADDOrUpdateEquation("@Mother.posx@", ""+mother.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posy@", ""+mother.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posz@", ""+mother.getZpos(), Equation.CALCULATION_MANUAL,equations) ;			
	}
	private void FILL_SUPPORT_BLOC_TIROIR(SupportBlocTiroir support, ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@this.hi@", "@this.h@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.li@", "@this.l@", Equation.CALCULATION_AUTO,equations) ;
		
	}
}
