package dressing.model;

import java.util.ArrayList;
import java.util.List;

import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CharniereType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;
import tech.frsdev.solids.Solide3D;

/**
 * ce class represente le model des charniere qui sont le supporte des ouvrant(portes|facades)
 * @author Imed
 *
 */
public class Charniere extends Accessoire {

	CharniereType charniereType=CharniereType.BAS;	
	Direction direction =Direction.XMINUS;
	boolean calculAuto=true;
	double retraitH=120;
	double retraitP=37;
	DesignObject3D mother;
	
	@Override
	public boolean canHold(DesignObject3D child) {
		if(child instanceof Usinage) {
			return true;
		}
		return false;
	}
	@Override
	protected void updateproperties() throws GeometricEngineException {
		// TODO Auto-generated method stub
		setNotificationon(false);
		Equation eq = null;
		try {
			if (debitage != null) {
				
				eq  = Equation.FIND_EQUATION("@this.posx@", debitage.getEquations());
				if(eq!=null)
				{
					setXpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posx@ not found to update");
				}
				
				eq  = Equation.FIND_EQUATION("@this.posy@", debitage.getEquations());
				if(eq!=null)
				{
					setYpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posy@ not found to update");
				}
				
				eq  = Equation.FIND_EQUATION("@this.posz@", debitage.getEquations());
				if(eq!=null)
				{
					setZpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posz@ not found to update");
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		} finally {
			setNotificationon(true);
		}
	}
	@Override
	public boolean isdrawable() {
		return false;
	}
	
	@Override
	public List getChildren() {
		if(childs==null ) {
			childs =new ArrayList<DesignObject3D>();
		}
		return childs;
	}
	public CharniereType getCharniereType() {
		return charniereType;
	}

	public void setCharniereType(CharniereType charniereType) {		
		CharniereType oldValue = this.charniereType;
		this.charniereType = charniereType;
		firePropertyChange("charniereType", oldValue, charniereType);
	}

	
	public Direction getDirection() {
		return direction;
	}

	public void setDirection(Direction direction) {
		Direction oldValue = this.direction;
		this.direction = direction;
		firePropertyChange("direction", oldValue, direction);
	}

	


	public boolean isCalculAuto() {
		return calculAuto;
	}
	public void setCalculAuto(boolean calculAuto) {
		boolean oldValue = this.calculAuto;
		this.calculAuto = calculAuto;
		firePropertyChange("calculAuto", oldValue, calculAuto);
	}
	
	public double getRetraitH() {
		return retraitH;
	}
	
	public void setRetraitH(double retraitH) {
		double oldValue = this.retraitH;
		this.retraitH = retraitH;
		firePropertyChange("retraitH", oldValue, retraitH);
	}
	
	public double getRetraitP() {
		return retraitP;
	}
	
	public void setRetraitP(double retraitP) {
		double oldValue = this.retraitP;
		this.retraitP = retraitP;
		firePropertyChange("retraitP", oldValue, retraitP);
	}
	
	
	public DesignObject3D getMother() {
		return mother;
	}
	public void setMother(DesignObject3D mother) {
		DesignObject3D oldValue = this.mother;
		this.mother = mother;
		firePropertyChange("mother", oldValue, mother);
	}
	
	@Override
	public Charniere clone() {

		Charniere ch=new Charniere();
		ch=(Charniere) this.copy(ch);

		
		return ch;
	}
	
	
	@Override
	public DesignObject3D copy(DesignObject3D object) {
		Charniere ch=(Charniere)object;
		ch=(Charniere) super.copy(ch);
		ch.setDirection(getDirection());
		ch.setCharniereType(getCharniereType());
		ch.setRetraitH(getRetraitH());
		ch.setRetraitP(getRetraitP());
		ch.setCalculAuto(isCalculAuto());
		ch.setMother(getMother());
		return ch;
	}
	/**
	 * @author imed 
	 * @Bug 0001217
	 * créer les trous d'usinage 
	 */
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		Piece2D piece=(Piece2D) getParentdesign();

		Trou tr1=new Trou(getDirection());
		Trou tr2=new Trou(getDirection());
		
		tr1.setTrouType(TrouType.CHARNIERE_BAS);
		tr2.setTrouType(TrouType.CHARNIERE_HAUT);

		tr1.setMother(this); 
		tr2.setMother(this);

		tr1.setName("Trou 1 "+this.getName());
		tr2.setName("Trou 2 "+this.getName());
		tr1.setParentdesign(piece);
		tr2.setParentdesign(piece);
		tr1.constructDebitage();
		tr1.evaluate();
		tr2.constructDebitage();
		tr2.evaluate();
		piece.addElement(tr1);
		piece.addElement(tr2);
	}
}
