/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tech.frsdev.graphunit;

// For Graphics, etc.
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
// For Ellipse2D, etc.
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.LinkedHashMap;

import dressing.cam.model.DXF_STATIC_VALUE;
import dressing.cam.model.Rotationangle;

/**
 *
 * @author Administrateur
 */
public class PShape extends PGraph implements Serializable {

    private static final long serialVersionUID = 352L;
    public Rectangle2D.Double graph;
    public Color color;
    public Stroke stroke;
    public float Width, Height;
    public PointDXF Startpoint;
//text string
    String texte = " ";
    PointDXF temppoint;
    public int textsize = 70;
    public Font f = new Font("SansSerif", Font.BOLD, textsize);
    AttributedString textattribute;
    Hashtable<TextAttribute, Object> map;
    ;
    // The LineBreakMeasurer used to line-break the paragraph.
    private LineBreakMeasurer lineMeasurer;
    // index of the first character in the paragraph.
    private int paragraphStart;
    // index of the first character after the end of the paragraph.
    private int paragraphEnd;
    boolean drawtext = false;        
    String pieceindexname = "p1";
    String piecenomenc = " PC11 PVC: COTE TIROIR";
    //352-0
    private String widthstr;
    private String hightstr;
    private boolean drawstrdim=false;
    private String sensdefil="NONE";//NONE,UP,LEFT 
    private  double width_user;
    private  double high_user;
    private  String width_user_str;
    private  String high_user_str;
    private  String muint; 
    private boolean draw_with_dim_user_uof=false;   
    public PShape() {
        //Apres verif
        this.Startpoint = new PointDXF(0, 0);
        this.graph = new Rectangle2D.Double(0, 0, 1, 1);
        this.stroke = new BasicStroke(1);
        this.color = Color.BLACK;
        this.Width = 1;
        this.Height = 1;
        map = new Hashtable<TextAttribute, Object>();
    }

    public PShape(PointDXF ipoint, float iWidth, float iHeight, Color c, int thik) {
        //Apres verif
        this.Startpoint = new PointDXF();
        this.Startpoint = ipoint;
        this.graph = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
        this.stroke = new BasicStroke(thik);

        this.color = c;
        this.Width = iWidth;
        this.Height = iHeight;
        map = new Hashtable<TextAttribute, Object>();
    }

    public PShape(PointDXF ipoint, float iWidth, float iHeight) {
        this.graph = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
        this.color = Color.BLACK;
        this.Startpoint = new PointDXF();
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.stroke = new BasicStroke(2);
        this.color = Color.black;
        map = new Hashtable<TextAttribute, Object>();

    }

    public void SetColor(Color a) {
        this.color = a;

    }

    public void SetStartPoint(PointDXF istart) {
        this.graph.x = istart.x;
        this.graph.y = istart.y;
        this.Startpoint = istart;
    }

    public void SetShapeDim(int iWidth, int iHeight) {
        this.graph.height = iHeight;
        this.graph.width = iWidth;
        this.Height = (int) graph.height;
        this.Width = (int) graph.width;
    }

    public void Settroke(int istroke) {
        this.stroke = new BasicStroke(istroke);
    }

    public Font getF() {
        return f;
    }

    public void setF(Font f) {
        this.f = f;
    }

    public PointDXF getTemppoint() {
        return temppoint;
    }

    public void setTemppoint(PointDXF temppoint) {
        this.temppoint = temppoint;
    }

    public String getTexte() {
        return texte;
    }

    public void setTexte(String texte) {
        this.texte = texte;
    }

    public int getTextsize() {
        return textsize;
    }

    public void setTextsize(int textsize) {
        this.textsize = textsize;
    }

    public String getSensdefil() {
        return sensdefil;
    }

    public void setSensdefil(String sensdefil) {
        this.sensdefil = sensdefil;
    }

    public void draw(Graphics g) {
        String PIECEDIM = "Horizontale/Verticale";
        type=getAffichagePieceDim(PIECEDIM);
        Graphics2D g2d = (Graphics2D) g;
        g2d.setColor(this.color);
        g2d.setStroke(this.stroke);
        g2d.draw(this.graph);        

        if (drawtext) {
            if (type == DimensionPrintType.DOUBLE_COTE_NOMENC
                    || type == DimensionPrintType.DOUBLE_COTE_ONLY
                    || type == DimensionPrintType.DOUBLE_COTE_PIECE_INDEX) {
                drawDimensionString(pieceindexname, Width, Height, g);
            } else {
                drawtopleft(g);
            }


        }
//        drawCenteredString(texte, Width, Height, g);
    }

    public float drawparagraphdimpieces(Graphics g, AttributedString itextattribute, float offsety, boolean simulate) {
        Graphics2D g2d = (Graphics2D) g;
        float availablehigh = Height;
        // Create a new LineBreakMeasurer from the paragraph.
        // It will be cached and re-used.
        if (lineMeasurer == null) {
            AttributedCharacterIterator paragraph = itextattribute.getIterator();
            paragraphStart = paragraph.getBeginIndex();
            paragraphEnd = paragraph.getEndIndex();
            FontRenderContext frc = g2d.getFontRenderContext();

            lineMeasurer = new LineBreakMeasurer(paragraph, frc);

        }

        // Set break width to width of Component.
        float breakWidth = (float) Width - (2 * (float) Width) / 9;
//        float drawPosY = Height / 9 + this.Startpoint.y;
//        float drawPosY = this.Startpoint.y+offsety+((float)Height/9);
//        availablehigh-=(offsety+((float)Height/9));
        float drawPosY = this.Startpoint.y + offsety;
        availablehigh -= (offsety);
        // Set position to the index of the first character in the paragraph.
        lineMeasurer.setPosition(paragraphStart);

        // Get lines until the entire paragraph has been displayed.
        while (lineMeasurer.getPosition() < paragraphEnd) {

            // Retrieve next layout. A cleverer program would also cache
            // these layouts until the component is re-sized.
            TextLayout layout = lineMeasurer.nextLayout(breakWidth);

            // Compute pen x position. If the paragraph is right-to-left we
            // will align the TextLayouts to the right edge of the panel.
            // Note: this won't occur for the English text in this sample.
            // Note: drawPosX is always where the LEFT of the text is placed.
//            float drawPosX = layout.isLeftToRight()
//                ? 0 : breakWidth - layout.getAdvance();
            float drawPosX = ((float) Width) / 10 + this.Startpoint.x;
            // Move y-coordinate by the ascent of the layout.
            drawPosY += layout.getAscent();
            availablehigh -= layout.getAscent();
            // Draw the TextLayout at (drawPosX, drawPosY).
            if (!simulate) {
                layout.draw(g2d, drawPosX, drawPosY);
            }


            // Move y-coordinate in preparation for next layout.
            drawPosY += layout.getDescent() + layout.getLeading();
            availablehigh -= layout.getDescent() + layout.getLeading();
        }
        return availablehigh;
    }

    public boolean isDrawtext() {
        return drawtext;
    }

    public void setDrawtext(boolean drawtext) {
        this.drawtext = drawtext;
    }

    public void drawDimensionString(String s, float w, float h, Graphics g) {
        String hstr;
        String wstr;
        if(drawstrdim)
        {
            hstr=hightstr;
            wstr=widthstr;
        }
        else
        {
            if (draw_with_dim_user_uof && high_user_str!=null && width_user_str!=null) {

                hstr = high_user_str;
                wstr = width_user_str;
            } else {
                hstr = "" + h;
                wstr = "" + w;
            }

        }
        boolean inversed = false;
        Graphics2D g2d = (Graphics2D) g;
        temppoint = new PointDXF();
        temppoint.x = this.Startpoint.x;
        temppoint.y = this.Startpoint.y;

        g2d.setColor(Color.black);
        //repere dimension 1             
        f = new Font("Courier New", Font.PLAIN, this.piecefontsize); //mise � jour du fond
//        f = new Font("Courier New", Font.PLAIN, 30); //mise � jour du fond
        g2d.setFont(f); //adapter nouveau fond au graphic

        FontMetrics fm = g2d.getFontMetrics();
        int w_high = fm.getHeight();
        int h_width = fm.stringWidth(hstr);
        int w_width = fm.stringWidth(wstr);
        int h_high = fm.getHeight();
   
        while (overlapcondtion(w_high, h_width, w_width, h_high, h, w)) {
            this.piecefontsize--;
            f = new Font("Courier New", Font.PLAIN, this.piecefontsize); //mise � jour du fond
            g2d.setFont(f); //adapter nouveau fond au graphic
            fm = g2d.getFontMetrics();
            w_high = fm.getHeight();
            h_width = fm.stringWidth(hstr);
            w_width = fm.stringWidth(wstr);
            h_high = fm.getHeight();

        }

        //Dimesion 1
        String dim = wstr;
        g2d.drawString(dim, temppoint.x + w / 10, temppoint.y + fm.getAscent());
        //dimension 2
        dim = hstr;
        g2d.rotate(-Math.PI / 2, 0, 0);
        g2d.translate(-temppoint.y, temppoint.x);
//        g2d.drawString(dim, temppoint.x - fm.getAscent(), temppoint.y);
//        g2d.drawString(dim, -temppoint.y, temppoint.x);

        // -y x
        g2d.drawString(dim, -1 * (h), w - fm.getAscent() / 4);
        g2d.translate(temppoint.y, -temppoint.x);
        g2d.rotate(Math.PI / 2, 0, 0);
        //draw sens de fibre
        if (sensdefil.equalsIgnoreCase("UP")) {
            g2d.rotate(-Math.PI / 2, 0, 0);
            g2d.translate(-temppoint.y, temppoint.x);
//        g2d.drawString(dim, temppoint.x - fm.getAscent(), temppoint.y);
//        g2d.drawString(dim, -temppoint.y, temppoint.x);

            // -y x
            g2d.drawString(">>>", -1 * (h)/2, w/2);
            g2d.translate(temppoint.y, -temppoint.x);
            g2d.rotate(Math.PI / 2, 0, 0);
            
        } else if (sensdefil.equalsIgnoreCase("LEFT")) {
            g2d.drawString("<<<",temppoint.x + w / 2, temppoint.y + h / 2);
        }

//        g2d.rotate(-Math.PI / 2, temppoint.x - 1*fm.getAscent() , temppoint.y + h);
//        g2d.drawString(dim, temppoint.x - fm.getAscent(), temppoint.y + h);
//        g2d.rotate(Math.PI / 2, temppoint.x  - 1*fm.getAscent(), temppoint.y + h);
//        
//        g2d.rotate(-Math.PI / 2, temppoint.x - 1*fm.getAscent() , temppoint.y + h+ 1*fm.getAscent());
//        g2d.drawString(dim, temppoint.x - fm.getAscent(), temppoint.y + h);
//        g2d.rotate(Math.PI / 2, temppoint.x  - 1*fm.getAscent(), temppoint.y + h+ 1*fm.getAscent());
//        
//        g2d.rotate(-Math.PI / 2, temppoint.x - 3*fm.getAscent() , temppoint.y + h);
//        g2d.drawString(dim, temppoint.x - fm.getAscent(), temppoint.y + h);
//        g2d.rotate(Math.PI / 2, temppoint.x  - 3*fm.getAscent(), temppoint.y + h);


//        //nom de la piece
//        f = new Font("SansSerif", Font.TRUETYPE_FONT, this.piecenamefontsize); //mise � jour du fond
//        g2d.setFont(f); //adapter nouveau fond au graphic
//        g2d.drawString("" + s, temppoint.x + 50, temppoint.y + h - 50);

    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        Graphics2D g2d = (Graphics2D) g;
        temppoint = new PointDXF();
        temppoint.x = this.Startpoint.x;
        temppoint.y = this.Startpoint.y;
        // System.out.println(temppoint.x);

        FontMetrics fm = g2d.getFontMetrics();

        while ((w - fm.stringWidth(s)) < 0) //difference entre w et largeur du texte
        {
            this.textsize--;
            f = new Font("SansSerif", Font.BOLD, textsize); //mise � jour du fond
            g2d.setFont(f); //adapter nouveau fond au graphic
            fm = g2d.getFontMetrics();  //mise � jour de la taille du texte
        }

        this.textsize--;
        this.textsize--;
        this.textsize--;
        f = new Font("SansSerif", Font.BOLD, textsize);
        g2d.setFont(f);
        fm = g2d.getFontMetrics();

        float x = ((w - fm.stringWidth(s)) / 2) + temppoint.x;
        float y = ((fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2)) + temppoint.y;
        g2d.drawString(s, x, y);
    }

    private int calculerbestsizedimpieces(Graphics g, int textsize1, float Height1, float width, String s) {
        Graphics2D g2d = (Graphics2D) g;
        int lingecount = 0;
        int ascent;
        Font font = new Font("Serif", Font.PLAIN, textsize1); //mise � jour du fond
        g2d.setFont(font); //adapter nouveau fond au graphic
        FontMetrics fm = g2d.getFontMetrics();
        lingecount = (int) Math.floor(fm.stringWidth(s) / (width + 1)) + 1;
        int usedhigh;
        int lignesize = fm.getHeight();
        ascent = fm.getAscent();
        usedhigh = lingecount * lignesize;
        int timeoutcounter = 0;
        if (usedhigh > (Height1 - ascent)) {
            while (usedhigh > (Height1 - ascent) && timeoutcounter < 100) {
                //decrease hight
                textsize1--;
                font = new Font("Serif", Font.PLAIN, textsize1); //mise � jour du fond
                g2d.setFont(font); //adapter nouveau fond au graphic
                fm = g2d.getFontMetrics();
                lignesize = fm.getHeight();
                ascent = fm.getAscent();
                lingecount = (int) Math.floor(fm.stringWidth(s) / (width + 1)) + 1;
                usedhigh = lingecount * lignesize;

                timeoutcounter++;
            }
        }


        return textsize1;
    }

    private void drawtopleft(Graphics g) {
        temppoint = new PointDXF();
        temppoint.x = this.Startpoint.x;
        temppoint.y = this.Startpoint.y;
        String hstr;
        String wstr;
        if (drawstrdim) {
            hstr = hightstr;
            wstr = widthstr;
        } else {
            if (draw_with_dim_user_uof && high_user_str!=null && width_user_str!=null) {

                hstr = high_user_str;
                wstr = width_user_str;
            } else {
                hstr = "" + Height;
                wstr = "" + Width;
            }

        }
        String s;
        if (type == DimensionPrintType.TOP_LEFT_DIMESION_ONLY
                || type == DimensionPrintType.TOP_LEFT_DIMESION_NOMENC) {
            //without index 
            s = wstr + " x " + hstr;
        } else {
            //without index
            s = wstr + " x " + hstr + " " + pieceindexname;
        }

        int itextsize = (int)calculerbestsizedimpieces(g, textsize, (10 * Height) / 10, (8 * Width) / 10, s);
//        System.out.println("dim size :" + itextsize);
        map.put(TextAttribute.FAMILY, "Serif");
        map.put(TextAttribute.SIZE, new Float(itextsize));
        textattribute = new AttributedString(s, map);
        //tester et simuler
        int availablehigh = (int)drawparagraphdimpieces(g, textattribute, 0, true);
        while (availablehigh <= 0 && itextsize>0 ) {
            itextsize--;
//            System.out.println("New Simulated size :" + itextsize);
            map.put(TextAttribute.FAMILY, "Serif");
            map.put(TextAttribute.SIZE, new Float(itextsize));
            textattribute = new AttributedString(s, map);
            lineMeasurer = null;
            availablehigh = (int)drawparagraphdimpieces(g, textattribute, 0, true);
        }
        availablehigh = (int)drawparagraphdimpieces(g, textattribute, 0, false);
        //testing nomenclature
        if (type == DimensionPrintType.TOP_LEFT_DIMESION_NOMENC
                || type == DimensionPrintType.TOP_LEFT_DIMESION_PIECE_INDEX_NOMNEC) {


            if (availablehigh > 20) {


                s = piecenomenc;
                //etstimate size
                itextsize = calculerbestsizedimpieces(g, itextsize, availablehigh, (8 * Width) / 10, s);
                map.put(TextAttribute.FAMILY, "Serif");
                map.put(TextAttribute.SIZE, new Float(itextsize));
                textattribute = new AttributedString(s, map);
                lineMeasurer = null;
                int reamin = (int)drawparagraphdimpieces(g, textattribute, (Height - availablehigh), true);
                while (reamin <= 0 && itextsize>0) {
                    itextsize--;
//                    System.out.println("New Simulated size :" + itextsize);
                    map.put(TextAttribute.FAMILY, "Serif");
                    map.put(TextAttribute.SIZE, new Float(itextsize));
                    textattribute = new AttributedString(s, map);
                    lineMeasurer = null;
                    reamin = (int)drawparagraphdimpieces(g, textattribute, (Height - availablehigh), true);
                }
                map.put(TextAttribute.FAMILY, "Serif");
                map.put(TextAttribute.SIZE, new Float(itextsize));
                textattribute = new AttributedString(s, map);
                lineMeasurer = null;
                drawparagraphdimpieces(g, textattribute, (Height - availablehigh), false);
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        //draw 
        if (sensdefil.equalsIgnoreCase("UP")) {
            g2d.rotate(-Math.PI / 2, 0, 0);
            g2d.translate(-temppoint.y, temppoint.x);
//        g2d.drawString(dim, temppoint.x - fm.getAscent(), temppoint.y);
//        g2d.drawString(dim, -temppoint.y, temppoint.x);

            // -y x
            g2d.drawString(">>>", -1 * (Height) / 2, Width / 2);
            g2d.translate(temppoint.y, -temppoint.x);
            g2d.rotate(Math.PI / 2, 0, 0);

        } else if (sensdefil.equalsIgnoreCase("LEFT")) {
            g2d.drawString("<<<", temppoint.x + Width / 2, temppoint.y + Height / 2);
        }

    }

    private boolean overlapcondtion(float w_high, float h_width, float w_width, float h_high, float h, float w) {
        
        float widthreste_w = w-w_width;
        float withreste_h  = h-h_width;    
        if(w_high >=h || w_width>=w || h_width>=h || h_high>=w)
        {
            return true;
        }
        else if(widthreste_w<h_high && withreste_h<h_high)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public String getPiecenomenc() {
        return piecenomenc;
    }

    public void setPiecenomenc(String piecenomenc) {
        this.piecenomenc = piecenomenc;
    }
    
     public DimensionPrintType getAffichagePieceDim(String typeaffichage) {
        LinkedHashMap<String,  DimensionPrintType> dimprint = new LinkedHashMap();
        dimprint.put("Gauche Haut", DimensionPrintType.TOP_LEFT_DIMESION_ONLY);
        dimprint.put("Gauche Haut avec nomenclature", DimensionPrintType.TOP_LEFT_DIMESION_NOMENC);        
        dimprint.put("Gauche haut avec indice de piece", DimensionPrintType.TOP_LEFT_DIMESION_PIECE_INDEX);
        dimprint.put("Gauche haut avec indice de piece et nomenclature", DimensionPrintType.TOP_LEFT_DIMESION_PIECE_INDEX_NOMNEC);
        dimprint.put("Horizontale/Verticale", DimensionPrintType.DOUBLE_COTE_ONLY);
        dimprint.put("Horizontale/Verticale avec indice de piece", DimensionPrintType.DOUBLE_COTE_PIECE_INDEX);
      
        return dimprint.get(typeaffichage);
    }

    public void setPieceindexname(String pieceindexname) {
        this.pieceindexname = pieceindexname;
    }

    public String getWidthstr() {
        return widthstr;
    }

    public void setWidthstr(String widthstr) {
        this.widthstr = widthstr;
    }

    public String getHightstr() {
        return hightstr;
    }

    public void setHightstr(String hightstr) {
        this.hightstr = hightstr;
    }

    public boolean isDrawstrdim() {
        return drawstrdim;
    }

    public void setDrawstrdim(boolean drawstrdim) {
        this.drawstrdim = drawstrdim;
    }

    public boolean isDraw_with_dim_user_uof() {
        return draw_with_dim_user_uof;
    }

    public void setDraw_with_dim_user_uof(boolean draw_with_dim_user_uof) {
        this.draw_with_dim_user_uof = draw_with_dim_user_uof;
    }

    public double getWidth_user() {
        return width_user;
    }

    public void setWidth_user(double width_user) {
        this.width_user = width_user;
    }

    public double getHigh_user() {
        return high_user;
    }

    public void setHigh_user(double high_user) {
        this.high_user = high_user;
    }

    public String getMuint() {
        return muint;
    }

    public void setMuint(String muint) {
        this.muint = muint;
    }

    public String getWidth_user_str() {
        return width_user_str;
    }

    public void setWidth_user_str(String width_user_str) {
        this.width_user_str = width_user_str;
    }

    public String getHigh_user_str() {
        return high_user_str;
    }

    public void setHigh_user_str(String high_user_str) {
        this.high_user_str = high_user_str;
    }
    @Override
    public String getDXFLineEntetity()
    {
        String s="";
        if(!isDrawDXFLine())
        {
            return s;
        }
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF origin = new PointDXF(this.Startpoint.getLocation());

        //ligne 1 
        PointDXF p1 = origin.getLocation();
        PointDXF p2 = p1.getLocation();
        p2.x += this.Width+DXF_STATIC_VALUE.CHUTE_DISK;

        //ligne2
        PointDXF p3 = p2.getLocation();
        p3.y += this.Height+DXF_STATIC_VALUE.CHUTE_DISK;

        //ligne 3 
        PointDXF p4 = p1.getLocation();
        p4.y += this.Height+DXF_STATIC_VALUE.CHUTE_DISK;

          //ligne 4
        if(DXF_STATIC_VALUE.INVERT_CORDENATE)
        {
            InvertCodanate(p1);
            InvertCodanate(p2);
            InvertCodanate(p3);
            InvertCodanate(p4);
        }
        else if(DXF_STATIC_VALUE.INVERT_ANDSCLAE_Y_CORDENATE)
        {
            InvertYCodanate(p1);
            InvertYCodanate(p2);
            InvertYCodanate(p3);
            InvertYCodanate(p4);
            SCALEYCodanate(p1,DXF_STATIC_VALUE.Y_SCALE_VALUE);
            SCALEYCodanate(p2,DXF_STATIC_VALUE.Y_SCALE_VALUE);
            SCALEYCodanate(p3,DXF_STATIC_VALUE.Y_SCALE_VALUE);
            SCALEYCodanate(p4,DXF_STATIC_VALUE.Y_SCALE_VALUE);
        }
        if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
            line1 = new PLineDXFEntity(p1, p2);
            line2 = new PLineDXFEntity(p2, p3);
            line3 = new PLineDXFEntity(p1, p4);
            line4 = new PLineDXFEntity(p4, p3);

            //Create String seintity
            s += line1.getDXFLineEntetity();
            s += line2.getDXFLineEntetity();
            s += line3.getDXFLineEntetity();
            s += line4.getDXFLineEntetity();
        }
        else
        {
            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
            poly.addVertices(p1);
            poly.addVertices(p2);
            poly.addVertices(p3);
            poly.addVertices(p4);
            poly.addVertices(p1);
            s +=  poly.getDXFEntity(Rotationangle.angleRotation0);
        }
        return s;
    }

      
    
}
