package geometry;

import java.util.ArrayList;
import java.util.Random;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;

import dressing.mathutils.MathUtilities;
import dressing.mathutils.Triangle;

public class CurveDrawer implements InputProcessor, IDrawer {
	
	public static ShapeRenderer shapeRenderer;
    float xoffset, yoffset;
    private Vector2 v0,v1, center;
    private Vector2 selection;
    private boolean updateArc = false;
    private Arc arc;
    private Ray ray;
    public CurveDrawer() {

    }
    
    @Override
	public void draw(Matrix4 projection) {
    	if(shapeRenderer == null)
    		shapeRenderer = new ShapeRenderer();
    	shapeRenderer.setProjectionMatrix(projection);
        if(updateArc){
            this.arc = ShapeBuilder.buildCircle(this.center,this.v0,this.v1);
            updateArc = false;
        }
        if(selection != null){
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(Color.RED);
            shapeRenderer.circle(selection.x,selection.y,5);
            shapeRenderer.end();
        }
        if(v0 != null){
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(Color.BLACK);
            shapeRenderer.circle(v0.x,v0.y,3);
            shapeRenderer.end();
        }
        if(v1 != null){
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(Color.BLACK);
            shapeRenderer.circle(v1.x,v1.y,3);
            shapeRenderer.end();
        }
        if(center != null){
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(Color.BLACK);
            shapeRenderer.circle(center.x,center.y,3);
            shapeRenderer.end();
        }
        if(ray != null)
            ray.draw(shapeRenderer,1000);
        if(arc != null)
            arc.draw(shapeRenderer, Color.BLACK);
	}
    public void draw(){
    	
    }

    @Override
    public void begin(Vector2 vertex) {
        this.v0 = vertex;
        this.arc = null;
		this.v1 = null;
		this.center=null;
    }

    public Arc end(){
        Arc arc = null;
		if (this.center != null && this.v0 != null && this.v1 != null) {
			arc = new Arc(this.center.cpy(), this.v0.cpy(), this.v1.cpy());
		}
		this.arc = null;
		this.v0 = null;
		this.v1 = null;
		this.center = null;
		return arc;
    }


    @Override
    public boolean keyDown(int keycode) {

        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        xoffset = screenX;
        yoffset = Gdx.graphics.getHeight() - screenY;
        Vector2 point = new Vector2(screenX, Gdx.graphics.getHeight() - screenY);
        if(v0 == null){
            setV0(point);
        }else if(v1 == null){
            setV1(point);
        }else{
            getSelection(point.x, point.y);
        }
        return true;
    }

    private void getSelection(float x, float y) {
        float dstToV0 = v0.dst(x, y);
        float dstToV1 = v1.dst(x, y);
        float dstToCenter = center.dst(x,y);
        float closest = Math.min(Math.min(dstToV0,dstToV1),dstToCenter);
        if(closest < 3){
            if(closest == dstToV0)
                selection = v0;
            if(closest == dstToV1)
                selection = v1;
            if(closest == dstToCenter)
                selection = center;
        }
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
    	if(button == Input.Buttons.RIGHT && selection == center) {
    		this.center = null;
    		end();
    	}
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        float xmov = screenX - xoffset;
        float ymov = Gdx.graphics.getHeight() - screenY - yoffset;
        if(selection != null && selection == center){
            Vector2 mvt = new Vector2(xmov,ymov);
            float dot = ray.getDirector().dot(mvt);
            dot/=Math.abs(dot);
            Gdx.app.debug("dot",dot +"");
            this.center.add(ray.getDirector().nor().scl(5 * dot));
            if(Float.isNaN(this.center.x)) {
            	System.err.println("we re fcked");
            }
            updateArc = true;
        }
        if(selection != null && selection == v1){
            v1.add(xmov,ymov);
            calculateRay();
            updateArc = true;
        }
        if(selection != null && selection == v0){
            v0.add(xmov,ymov);
            calculateRay();
            updateArc = true;
        }
        xoffset = screenX;
        yoffset = Gdx.graphics.getHeight() - screenY;
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public Vector2 getV0() {
        return v0;
    }

    public void setV0(Vector2 v0) {
        this.v0 = v0;
    }

    public Vector2 getV1() {
        return v1;
    }

    public void setV1(Vector2 v1) {
        this.v1 = v1;
        calculateRay();
        updateArc = true;
    }

    private void calculateRay() {
        if(v0 != null && v1 !=null){
            this.ray = new Ray(v1.cpy().add(v0).scl(0.5f), v1.cpy().sub(v0).rotate90(1).nor());
            this.center = ray.getOrigin().cpy();//.add(ray.getDirector().cpy().scl(100));
        }
    }

    public Vector2 getCenter() {
        return center;
    }

    public void setCenter(Vector2 center) {
        this.center = center;
    }


	@Override
	public boolean scrolled(int amount) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public ArrayList<Vector2> getVertices() {
		if(arc != null)
			return arc.getVertices();
		return null;
	}

	@Override
	public void finish() {
		this.arc = null;
		this.v0 = null;
		this.v1 = null;
		this.center = null;
		this.ray=null;
	}

	public void edit(Arc arc) {
		setV0(arc.getV0());
		setV1(arc.getV1());
		this.center = arc.getCenter();

	}

}
