package gdxapp.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.Texture.TextureFilter;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

import dressing.config.WorkspaceConfiguration;
import gdxapp.Commun.Preferences;

public class AssetFont {

		private SDFFont font;
		private SDFFont largeFont;
		private BitmapFont smallFont;
		
        private static AssetFont instance = new AssetFont(); 
        private AssetFont () {
            load();
        }
        
        public void load() {
        	Texture texture = new Texture(Gdx.files.absolute(WorkspaceConfiguration.FONT_IMAGE), true);
        	texture.setFilter(TextureFilter.MipMapLinearNearest, TextureFilter.Linear);
        	font = new SDFFont(Gdx.files.absolute(WorkspaceConfiguration.FONT), new TextureRegion(texture), false);
        	smallFont = new BitmapFont();
        	
        	Texture textureLarge = new Texture(Gdx.files.absolute(WorkspaceConfiguration.Large_FONT_IMAGE), true);
        	textureLarge.setFilter(TextureFilter.MipMapLinearNearest, TextureFilter.Linear);
        	largeFont = new SDFFont(Gdx.files.absolute(WorkspaceConfiguration.FONT), new TextureRegion(texture), false);
        }
        
		public static AssetFont getInstance() {
			return instance;
		}
		public static void setInstance(AssetFont instance) {
			AssetFont.instance = instance;
		}

		public SDFFont getFont() {
			return font;
		}
		
		

		public SDFFont getLargeFont() {
			return largeFont;
		}

		public BitmapFont getSmallFont() {
			return smallFont;
		}

		
		
		

        
        
        
        
        
        
}
