package dressing.ui.usinage;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import param.Cavity;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.Operation;
import param.Rainure;
import param.Tool;
import param.TriCavity;
import param.UsinageFaimlyGroup;
import param.UsinageFamily;
import param.UsinageNode;
import param.UsinageTrou;
import param.impl.MechanicDesignImpl;

import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.LabelProvider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;

public class UsinageFamilyEditor extends Composite {
	private Table table;
	UsinageFaimlyGroup families= ModelProvider.getModelroot().getUsinageFamilies();
	TableViewer tableViewer;
	private MDirtyable dirty;
	Map< UsinageFamily, List<Tool>> familiesTools=new HashMap<UsinageFamily, List<Tool>>();

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public UsinageFamilyEditor(Composite parent, int style) {
		super(parent, style);
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		 tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		
		
		TableViewerColumn tableViewerColumnName = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnName.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element!=null && element instanceof UsinageFamily ) {
					UsinageFamily family=((UsinageFamily)element);
					
						return family.getName()== null ?"":family.getName();
					
				}
				return element == null ? "" : element.toString();
			}
		});
		TableColumn tblclmnFamilyName = tableViewerColumnName.getColumn();
		tblclmnFamilyName.setWidth(144);
		tblclmnFamilyName.setText("Famille");
		
		TableViewerColumn tableViewerTool = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerTool.setEditingSupport(new EditingSupport(tableViewer) {
			ComboBoxViewerCellEditor cellEditor =new ComboBoxViewerCellEditor(tableViewer.getTable(),SWT.READ_ONLY);
			{
				cellEditor.setContentProvider(ArrayContentProvider.getInstance());
				cellEditor.setInput(ModelProvider.getModelroot().getTools().getTools());
				cellEditor.setLabelProvider(new LabelProvider() {
					@Override
					public String getText(Object element) {
						if(element instanceof Tool) {
							return ((Tool)element).getName();
						}
						return super.getText(element);
					}
				});
			}
			protected boolean canEdit(Object element) {
				// TODO Auto-generated method stub
				return true;
			}
			protected CellEditor getCellEditor(Object element) {
			
				
				if(element!=null && element instanceof UsinageFamily ) {
					UsinageFamily family=((UsinageFamily)element);
					if( family.getTool()!=null ) {
						cellEditor.setValue(family.getTool());
					
					}
				}
				return cellEditor;
			}
			protected Object getValue(Object element) {
				if(element!=null && element instanceof UsinageFamily ) {
					UsinageFamily family=((UsinageFamily)element);
					if( family.getTool()!=null ) {
						return family.getTool();
					
					}
				}
				return null;
			}
			protected void setValue(Object element, Object value) {
				if(element!=null && element instanceof UsinageFamily ) {
					UsinageFamily family=((UsinageFamily)element);
					if( family.getTool()!=null ) {
						Tool oldTool=family.getTool();
						Tool newTool=(Tool) value;
						family.setTool(newTool);
						cellEditor.setValue(family.getTool());
						table.update();
						tableViewer.refresh();
						//
						List<Tool> tools=new ArrayList<Tool>();
						tools.add(oldTool);
						tools.add(newTool);
						familiesTools.put(family,tools );
						dirty.setDirty(true);
						//
					}
				}
			}
		});
		tableViewerTool.setLabelProvider(new ColumnLabelProvider() {
			
			public String getText(Object element) {
				// TODO Auto-generated method stub
				if(element!=null && element instanceof UsinageFamily ) {
					UsinageFamily family=((UsinageFamily)element);
					if( family.getTool()!=null ) {
						return family.getTool().getName();
					}
				}
				return element == null ? "" : element.toString();
			}
		});
		TableColumn tblclmnTools = tableViewerTool.getColumn();
		tblclmnTools.setWidth(300);
		tblclmnTools.setText("Outils");
		tableViewer.setInput(families.getFamilies());
		ControlAdapter cal= new ControlAdapter() {
			
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = UsinageFamilyEditor.this.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.width + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		       
		      }
		      Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		    	tblclmnFamilyName.setWidth(width/2);
		        tblclmnTools.setWidth(width/2);
		        
		        table.setSize(area.width, area.height-30);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height-30);
		        tblclmnFamilyName.setWidth(width/2);
		        tblclmnTools.setWidth(width/2);
		      
		      }
		    }};
		    this.addControlListener(cal);
			table.setLinesVisible(true);
			tableViewer.refresh();
		table.pack();
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public Table getTable() {
		return table;
	}
	public void refresh() {
		if(!table.isDisposed() && tableViewer!=null) {
			table.update();
			tableViewer.refresh();
		}
	}
	public void setTable(Table table) {
		this.table = table;
	}

	public UsinageFaimlyGroup getFamilies() {
		return families;
	}

	public void setFamilies(UsinageFaimlyGroup families) {
		this.families = families;
	}

	public TableViewer getTableViewer() {
		return tableViewer;
	}

	public void setTableViewer(TableViewer tableViewer) {
		this.tableViewer = tableViewer;
	}

	public MDirtyable getDirty() {
		return dirty;
	}

	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	
	public void run() throws DesignException {
		
		if(ProjectManager.getManager().getCurrentKitchen()!=null ) {
			Kitchen kitchen=ProjectManager.getManager().getCurrentKitchen();
			if(kitchen!=null && kitchen.getElements()!=null && kitchen.getElements().size()>0) {
				List<DesignObject3D> elements=kitchen.getElements();
				boolean changed=false;
				for(DesignObject3D elt:elements) {
					changed=false;
					MechanicDesignImpl design=(MechanicDesignImpl) elt.getMechanicDesignDefinition();
					if(design.getMechanicelementgroup()!=null )
					{	
						EList<MechanicDesignElment> pieces=design.getMechanicelementgroup().getMechanicdesignelment();
						if( pieces!=null && pieces.size()>0) {
							for(MechanicDesignElment piece:pieces) {
								UsinageNode node=piece.getUsinagenode();
								if(node!=null) {
									//
									if(node.getUsinagetrou()!=null && node.getUsinagetrou().size()>0) {
										for(UsinageTrou trou:node.getUsinagetrou()) {
											if(trou!=null && trou.getOperations()!=null && trou.getOperations().size()>0)
											{
												UsinageFamily family=trou.getUsinageFamily();
												if(family!=null && familiesTools.containsKey(family)) {
													List<Tool> tools=familiesTools.get(family);
													for(Operation op:trou.getOperations()) {
														op.setTool(tools.get(1));
													}
													changed=true;
												}
											}
											
										}
									}
									//
									if(node.getUsinageRainure()!=null && node.getUsinageRainure().size()>0) {
										for(Rainure rn:node.getUsinageRainure()) {
											if(rn!=null && rn.getOperations()!=null && rn.getOperations().size()>0)
											{
												UsinageFamily family=rn.getUsinageFamily();
												if(family!=null && familiesTools.containsKey(family)) {
													List<Tool> tools=familiesTools.get(family);
													for(Operation op:rn.getOperations()) {
														op.setTool(tools.get(1));
													}
													changed=true;
												}
											}
											
										}
									}
									//
									if(node.getCavities()!=null && node.getCavities().size()>0) {
										for(Cavity cv:node.getCavities()) {
											if(cv!=null && cv.getOperations()!=null && cv.getOperations().size()>0)
											{
												UsinageFamily family=cv.getUsinageFamily();
												if(family!=null && familiesTools.containsKey(family)) {
													List<Tool> tools=familiesTools.get(family);
													for(Operation op:cv.getOperations()) {
														op.setTool(tools.get(1));
													}
													changed=true;
												}
											}
											
										}
									}
									//
									if(node.getUsinageTriCavity()!=null && node.getUsinageTriCavity().size()>0) {
										for(TriCavity triCv:node.getUsinageTriCavity()) {
											if(triCv!=null && triCv.getOperations()!=null && triCv.getOperations().size()>0)
											{
												UsinageFamily family=triCv.getUsinageFamily();
												if(family!=null && familiesTools.containsKey(family)) {
													List<Tool> tools=familiesTools.get(family);
													for(Operation op:triCv.getOperations()) {
														op.setTool(tools.get(1));
													}
													changed=true;
												}
											}
											
										}
									}
									//
								}
							}
						}
						
					}
					if(changed) {
						try {
							((Space3DFree)elt).update();
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}
			}
		}
		ResourceManagers.getIntance().saveLibraryResource();
		dirty.setDirty(false);
	}
	
	
	public void cancel() {
		if(familiesTools!=null && familiesTools.size()>0) {
			for(UsinageFamily family:familiesTools.keySet()) {
				family.setTool(familiesTools.get(family).get(0));
			}
		}
		tableViewer.refresh();
		familiesTools.clear();
		ResourceManagers.getIntance().saveLibraryResource();
		dirty.setDirty(false);
	}
}
