package dressing.config.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.frs.dressing.parameters.ui.UiInjectorProvider;
import com.google.inject.Injector;
import dressing.config.WorkspaceConfiguration;
import dressing.model.Chant;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import param.ChantGroup;
import param.Material;
import param.MaterialGroup;
import param.ModelRoot;
import param.Parameters;
import param.ParametersGroups;
import param.Tool;
import param.ToolGroup;
import param.ToolProps;
import param.util.ParamResourceFactoryImpl;

public class ResourceManagers {
	
	ResourceSet resSet =null;
	Resource libraryresource=null;
	private static ResourceManagers instance;
	private URI libraryUri = URI.createFileURI(WorkspaceConfiguration.getConfDirpath() + "/ModelPrams.library");
	private Injector injector = UiInjectorProvider.getInjector();
	ModelProvider modelProvider = new ModelProvider();
	// The EditingDomain is needed for context menu and drag and drop
	EditingDomain editingDomain = injector.getInstance(EditingDomain.class);

	ResourceLoader resourceLoader = injector.getInstance(ResourceLoader.class);
	private boolean inited=false;
	public ResourceManagers() {
		super();
		initLibrary();
	}

	public static ResourceManagers getIntance() {
		if (instance == null) {
			instance = new ResourceManagers();
		}
		return instance;
	}

	public void initLibrary() {
		if (this.libraryresource == null && !this.inited) {
//			long debut =new Date().getTime();

			ParamResourceFactoryImpl resourcefactory=new ParamResourceFactoryImpl();
			editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi",resourcefactory);
			editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("library",resourcefactory);
			editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml",resourcefactory);
			editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("sdress",resourcefactory);//dressings file		
			editingDomain.getResourceSet().getLoadOptions().put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION,Boolean.TRUE);
			editingDomain.getResourceSet().getLoadOptions().put(XMLResource.OPTION_RECORD_UNKNOWN_FEATURE,Boolean.TRUE);

			this.libraryresource = resourceLoader.getResource(editingDomain, libraryUri).getResource();
//			long end =new Date().getTime();
//			System.err.println(end-debut);
			this.resSet = this.libraryresource.getResourceSet();
			gereParameters();
			this.inited = true;

		}
		
	}
	public Resource loadResource(URI uri){
		Resource ress =	resSet.createResource(uri);
		try {
			ress.unload();
			ress.load(Collections.EMPTY_MAP);
		} catch (IOException e) {
			//e.printStackTrace();
		}
		return ress;
	}
	
	public Resource getLibraryresource() {
		return libraryresource;
	}

	public void setLibraryresource(Resource libraryresource) {
		this.libraryresource = libraryresource;
	}

	public Injector getInjector() {
		return injector;
	}

	public void setInjector(Injector injector) {
		this.injector = injector;
	}

	public EditingDomain getEditingDomain() {
		return editingDomain;
	}

	public void setEditingDomain(EditingDomain editingDomain) {
		this.editingDomain = editingDomain;
	}

	public ResourceLoader getResourceLoader() {
		return resourceLoader;
	}

	public void setResourceLoader(ResourceLoader resourceLoader) {
		this.resourceLoader = resourceLoader;
	}
	public void saveLibraryResource() {
		final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
		saveOptions.put(Resource.OPTION_SAVE_ONLY_IF_CHANGED, Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);
		// Save the resources to the file system.
		try {
			ResourceManagers.this.libraryresource.save(saveOptions);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		gereParameters();	
	}
	public void gereParameters() {
		TreeIterator<EObject> tree = libraryresource.getAllContents();
		EObject em = tree.next();

		if (em instanceof ModelRoot) {
			ModelRoot mr = (ModelRoot) em;
			ModelProvider.setModelroot(mr);

			ParametersGroups paraGroups = (ParametersGroups) mr.getParametersgroups();
			MaterialGroup matGroup = (MaterialGroup) mr.getMaterialgroup();
			ChantGroup chntGroup = (ChantGroup) mr.getChantgroup();
			ToolGroup toolGroup = mr.getTools();
			ModelProvider.getTools().clear();
			if (toolGroup != null) {
				for (Tool tool : toolGroup.getTools()) {
					dressing.cam.model.Tool tt = new dressing.cam.model.Tool();
					tt.setCode(tool.getCode());
					tt.setCutter_diameter(tool.getCutterDiameter());
					tt.setCutter_length(tool.getCutterLength());
					tt.setFeed(tool.getFeed());
					tt.setFlute_diameter(tool.getFluteDiameter());
					tt.setFlute_length(tool.getFluteLength());
					tt.setSpindleSpeed(tool.getSpindleSpeed());
					tt.setName(tool.getName());
					if(tool.getProperties()!=null && tool.getProperties().getProps()!=null && tool.getProperties().getProps().size()>0) {
						for(ToolProps prop:tool.getProperties().getProps()) {
							tt.put(prop.getCode(), prop.getValue());
						}
					}
					ModelProvider.getTools().add(tt);
				}
			}
			ModelProvider.getListParam().clear();
			for (Parameters para : paraGroups.getParameters()) {
				dressing.model.Parameters param = new dressing.model.Parameters();
				param.setCode(para.getCode());
				param.setName(para.getName());
				param.setValue(para.getValue());
				ModelProvider.getListParam().add(param);
			}
			ModelProvider.getListChant().clear();
			for (param.Chant chnt : chntGroup.getChant()) {
				Chant chant = new Chant();
				chant.setEpaisseur(chnt.getEpaisseur());
				chant.setName(chnt.getName());
				ModelProvider.getListChant().add(chant);// this is an issue must be corrected
			}
			ModelProvider.getMateriallist().clear();
			ModelProvider.getCadMaterialMap().clear();
			ModelProvider.getDefintionmaterialMap().clear();
			for (Material mat : matGroup.getMaterial()) {
				Materiaux material = new Materiaux();
				material.setName(mat.getName());
				material.setEpaisseur(mat.getEpaisseur());
				material.setMotif(mat.getImage());
				ModelProvider.getMateriallist().add(material);
				ModelProvider.getCadMaterialMap().put(material, mat);
				ModelProvider.getDefintionmaterialMap().put(mat, material);
				
			}

		}
	}
}
