package modeljtree;

import java.util.List;

import Guillotine.OperationCoin;
import Guillotine.OperationRainure;
import Guillotine.OperationTree;
import Guillotine.OperationTrou;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.cam.model.Cercle2D;
import dressing.cam.model.Cuboid;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.model.usinage.Rainure;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;

public class TransformCadToCoup {
	public static ModelTree transformcuisineToModelTree(Kitchen kitchen) {
		ModelTree model=new ModelTree(-1);
		model.setId(-1);
		model.setRef(kitchen.getProject().getName());
		model.setClient(kitchen.getProject().getClient());
		model.setProject(kitchen.getProject().getName());
		for(DesignObject3D elt:kitchen.getElements()) {
			model.getV_art().add(transformElementToArticleTree((Space3D) elt));
		}
		return model;
	}
	public static ArticleTree transformElementToArticleTree(Space3D elt) {
		ArticleTree art=new ArticleTree();
		art.setDES_ART(elt.getName()+"_"+ ((int)elt.getLongeurext()));
		art.setREF_ART(elt.getName()+"_"+ ((int)elt.getLongeurext()));
		art.setQT_ART(1);
		for(Piece2D piece:elt.getListPieces()) {
			if(piece.getMaterialType()!=null && piece.getMaterialType().getMaterial()!=null && piece.getMaterialType().getMaterial().isProduction())
			{
				art.getV_piece().add(transformPiece2DToPieceTree(piece));
			}
		}
		return art;
	}
	public static PieceTree transformPiece2DToPieceTree(Piece2D piece) {
		PieceTree tree=new PieceTree();
		tree.setName(piece.getName());
		tree.setHauteur(piece.getPieceH());
		tree.setLargeur(piece.getPieceL());
		tree.setQuantite(1);
		tree.setMateriauname(piece.getMaterial().getName());
		tree.setArticle_name(piece.getParentdesign().getName());
		PlanUsinage plan1=piece.getPrimaryPrespective();
		PlanUsinage plan2=piece.getSecondaryPrespective();
		
		List<Cuboid> cuboidsPlan1=Util.getcuboidsforPlan(plan1, piece);
		List<Cercle2D> cereclesPlan1=Util.gettrousforPlan(plan1, piece);
		List<Cuboid> cuboidsPlan2=Util.getcuboidsforPlan(plan2, piece);
		List<Cercle2D> cereclesPlan2=Util.gettrousforPlan(plan2, piece);
		PlanUsinage plan=plan1;
		List<Cuboid> cuboids;
		List<Cercle2D> cercles;
		int nb1=0;
		if(cuboidsPlan1!=null) {
			nb1+=cuboidsPlan1.size();
		}
		if(cereclesPlan1!=null) {
			nb1+=cereclesPlan1.size();
		}
		int nb2=0;
		if(cuboidsPlan2!=null) {
			nb2+=cuboidsPlan2.size();
		}
		if(cereclesPlan2!=null) {
			nb2+=cereclesPlan2.size();
		}
		if(nb1>nb2) {
			plan=plan1;
			cuboids=cuboidsPlan1;
			cercles=cereclesPlan1;
					
		}else {
			plan=plan2;
			cuboids=cuboidsPlan2;
			cercles=cereclesPlan2;
		}
		double h=Util.getPieceH(piece, plan);
		double l=Util.getPieceL(piece, plan);
		tree.setHauteur(Util.getPieceH(piece, plan));
		tree.setLargeur(Util.getPieceL(piece, plan));
		for(Cuboid cub:cuboids) {
			tree.getOperationslist().add(transformUsinageToOperationTree(cub,l,h));
		}
		for(Cercle2D cercle:cercles) {
			tree.getOperationslist().add(transformUsinageToOperationTree(cercle, l, h));
		}
//		for(Usinage usin:piece.getusinage()) {
//			tree.getOperationslist().add(transformUsinageToOperationTree(usin));
//		}
		return tree;
	}
	public static OperationTree transformUsinageToOperationTree(Usinage usin) {
		OperationTree tree;
		if(usin instanceof Trou) {
			Trou tr=(Trou) usin;
			tree=new OperationTrou(tr.getDiameter(),tr.getDepth(),tr.getXcenter(),tr.getYcenter());
		}else if(usin instanceof Rainure) {
			tree=new OperationRainure();
		}else {
			tree=new OperationCoin();
		}
		return tree;
	}
	public static OperationTree transformUsinageToOperationTree(Cuboid usin, double l, double h) {
		OperationTree tree;
		boolean iscoins=false;
		int coin=0;
		if(usin.getCube() instanceof Cavity) {
			if(usin.getxPos()==0&& usin.getyPos()==0) {
				iscoins=true;
				coin=1;
			}
			if(usin.getxPos()+usin.getLongeur()==l && usin.getyPos()==0) {
				iscoins=true;
				coin=2;
			}
			if(usin.getxPos()+usin.getLongeur()==l && usin.getyPos()+usin.getHauteur()==h) {
				iscoins=true;
				coin=3;
			}
			if(usin.getxPos()==0 && usin.getyPos()+usin.getHauteur()==h) {
				iscoins=true;
				coin=4;
			}
			
			
		}
		if(iscoins) {
			tree=new OperationCoin();
			((OperationCoin) tree).setCoin(coin);
			((OperationCoin) tree).setXdim(usin.getLongeur());
			((OperationCoin) tree).setYdim(usin.getHauteur());
		
		}
		else {
			tree=new OperationRainure();
			((OperationRainure) tree).setEpaisseur(usin.getLongeur());
			((OperationRainure) tree).setLongeur(usin.getHauteur());
			((OperationRainure) tree).setProfondeur(usin.getDepth());
			((OperationRainure) tree).setXpos(usin.getxPos());
			((OperationRainure) tree).setYpos(usin.getyPos());
		}
		
		return tree;
	}
	public static OperationTree transformUsinageToOperationTree(Cercle2D usin, double l, double h) {
		OperationTree tree;
		
		
			tree=new OperationTrou(usin.getDiameter(), usin.getxPos(), usin.getyPos());
			((OperationTrou) tree).setDepth(usin.getDepth());
		
		return tree;
	}
}
