package geometry;

import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import dressing.controller.tools.ToolController;
import dressing.handlers.gdx.ToolControlHandler;
import dressing.mathutils.Triangle;
import dressing.ui.project.CreateFormWizard;
import dressing.ui.util.OpenWizardDialog;
import gdxapp.Commun.ActorInputListener;
import gdxapp.object3d.Wall;
import gdxapp.screens.room.RoomController;

public class ShapeDrawer extends Actor {

	public enum ShapeType {
		POLYGON, POLYLINE, ARC
	}
    public static ShapeRenderer shapeRenderer;
	public ActorInputListener inputListener;
	private CurveDrawer curveDrawer;
	private PolygonDrawer polygonDrawer;
	IDrawer currentDrawer;
	private Matrix4 transform;
	public ArrayList<Vector2> mesh;
	public ArrayList<Vector2> outerMesh;
	public boolean closed;

	ArrayList<Triangle> triangles;
	ArrayList<Vector2> normals;
	private CompoundShape temporaryShape;
	private CompoundObject temporaryObject;
	private Object subject;
	Shell shell = new Shell();
	private static ShapeDrawer instance;

	public static ShapeDrawer getInstance() {
		synchronized (ShapeDrawer.class) {
			if (instance == null) {
				instance = new ShapeDrawer();
			}
			return instance;
		}
	}

	public ShapeDrawer() {
		super();
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		inputListener = new ShapeDrawerEventProcessor();
		addListener(inputListener);
		init();
	}

	public void init() {
		curveDrawer = new CurveDrawer();
		polygonDrawer = new PolygonDrawer();

	}

	public static void drawPoint(float x, float y) {
		shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
		shapeRenderer.circle(x, y, 2);
		shapeRenderer.end();
	}

	public static ShapeRenderer getShapeRenderer() {
		return shapeRenderer;
	}

	public static void setShapeRenderer(ShapeRenderer shapeRenderer) {
		ShapeDrawer.shapeRenderer = shapeRenderer;
	}

	public void setCurrentDrawer(IDrawer drawer) {
		ArrayList<Shape> nodes = getTemporaryShape().getNodes();
		if (currentDrawer != null) {
			Shape shape = currentDrawer.end();
			if (shape != null) {
				nodes.add(shape);
			}
		}
		this.currentDrawer = drawer;
		Gdx.input.setInputProcessor((InputProcessor) currentDrawer);
		Vector2 start = null;
		if (nodes.size() > 0)
			start = nodes.get(nodes.size() - 1).getlastVertex();
		drawer.begin(start);
	}

	public void setCurrentDrawer(ShapeType type) {
		ArrayList<Shape> nodes = getTemporaryShape().getNodes();
		if (currentDrawer != null) {
			Shape shape = currentDrawer.end();
			if (shape != null) {
				nodes.add(shape);
			}
		}
		if (type == ShapeType.POLYGON) {
			polygonDrawer.setClosed(true);
			closed = true;
			this.currentDrawer = polygonDrawer;
		}else if(type == ShapeType.POLYLINE) {
			polygonDrawer.setClosed(false);
			closed = false;
			this.currentDrawer = polygonDrawer;
		}else {
			this.currentDrawer = curveDrawer;
		}
		Gdx.input.setInputProcessor((InputProcessor) currentDrawer);
		Vector2 start = null;
		if (nodes.size() > 0)
			start = nodes.get(nodes.size() - 1).getlastVertex().cpy();
		currentDrawer.begin(start);
	}

	@Override
	public void draw(Batch batch, float parentAlpha) {
		inputListener.handleKeyBoardinput();
		boolean batchInterrupted = false;
		if (batch.isDrawing()) {
			batch.end();
			batchInterrupted = true;
		}
		Vector2 start = null, end = null;
		if (shapeRenderer == null)
			shapeRenderer = new ShapeRenderer();
		shapeRenderer.setProjectionMatrix(batch.getProjectionMatrix());
		ArrayList<Shape> nodes = getTemporaryShape().getNodes();
		if (nodes != null && !nodes.isEmpty()) {
			for(int i = 0; i < nodes.size(); i++) {
				nodes.get(i).draw(shapeRenderer, Color.BLACK);
			}
			start = nodes.get(0).getVertices().get(0);
			end = nodes.get(nodes.size() - 1).getlastVertex();
		}

		
		if (currentDrawer != null) {
			currentDrawer.draw(batch.getProjectionMatrix());
			if (currentDrawer.getVertices() != null && !currentDrawer.getVertices().isEmpty()) {
				end = currentDrawer.getVertices().get(currentDrawer.getVertices().size() - 1);
				if (start == null)
					start = currentDrawer.getVertices().get(0);
			}
		}

		if (closed) {
			if (start != null && end != null) {
				shapeRenderer.begin(com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType.Filled);
				shapeRenderer.setColor(Color.BLACK);
				shapeRenderer.rectLine(start, end, 2);
				shapeRenderer.end();
			}
		}

		if (temporaryObject != null) {
			if (temporaryObject.getBorder() != null)
				temporaryObject.getBorder().draw(batch, parentAlpha);
			if (temporaryObject.getExtrusion() != null)
				temporaryObject.getExtrusion().draw(batch, 0.5f * parentAlpha);
			if(Gdx.input.isKeyPressed(Keys.P)) {
				for(Triangle tr: temporaryObject.getTrianglesMesh()) {
					tr.draw(shapeRenderer);
				}
			}
		}

		if (batchInterrupted)
			batch.begin();
	}
	
	//return true if a shape is draw else return false
	public boolean end() {
		ArrayList<Shape> nodes = getTemporaryShape().getNodes();
		if (currentDrawer != null) {
			Shape shape = currentDrawer.end();
			if (shape != null) {
				nodes.add(shape);
			}
		}		
		currentDrawer = null;
		boolean result = false;
		if(nodes.size() > 0) {
			result = true;
			CompoundShape compoundShape = getTemporaryShape().cpy();
			compoundShape.setWorldTransform(transform.cpy());
			if(subject != null) {
				if(subject instanceof CompoundShape) {
					remove();
				}
			}else {
				if (ToolController.getInstance().isDRAW_EXTRUSION()) {
					compoundShape.setWinding(-1);
					getTemporaryObject().setExtrusion(compoundShape);
				} else {
					compoundShape.setWinding(1);
					getTemporaryObject().setBorder(compoundShape);
				}
			}
		}
		setTemporaryShape(null);
		subject = null;
		Gdx.input.setInputProcessor(RoomController.getInstance().inputMultiplexer);
		return result;
	}

	public void setTemporaryObjectBorder() {
		CompoundShape compoundShape = getTemporaryShape().cpy();
		compoundShape.setClosed(this.closed);
		compoundShape.setWorldTransform(transform.cpy());
		getTemporaryObject().setBorder(compoundShape);
		temporaryShape = null;
	}

	public IDrawer getCurrentDrawer() {
		return currentDrawer;
	}

	public ArrayList<Vector2> calculateSurfaceNormals(ArrayList<Vector2> vertices) {
		ArrayList<Vector2> normals = new ArrayList<Vector2>();
		Vector2 nextVertex, previousVertex;
		for (Vector2 vertex : vertices) {
			int i = vertices.indexOf(vertex);
			int next = (i + 1) % (vertices.size());
			int previous = i - 1;
			if (previous < 0)
				previous += vertices.size();
			nextVertex = vertices.get(next);
			previousVertex = vertices.get(previous);
			Vector2 normal = nextVertex.cpy().sub(previousVertex).rotate(90).nor();
			normals.add(normal);
		}
		return normals;
	}

	public Matrix4 getTransform() {
		return transform;
	}

	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}

	public CompoundShape getTemporaryShape() {
		if (temporaryShape == null) {
			temporaryShape = new CompoundShape();
			temporaryShape.setWorldTransform(this.transform);
		}
		return temporaryShape;
	}

	public void setTemporaryShape(CompoundShape temporaryShape) {
		this.temporaryShape = temporaryShape;
		if (temporaryShape != null) {
			getStage().addActor(temporaryShape);
		}
	}

	public CompoundObject getTemporaryObject() {
		if (temporaryObject == null) {
			temporaryObject = new CompoundObject();
			temporaryObject.setWorldTransform(RoomController.getInstance().getSceneToWorldTransform().cpy());
		}
		return temporaryObject;
	}

	public void setTemporaryObject(CompoundObject temporaryObject) {
		this.temporaryObject = temporaryObject;
	}
	
	public void finish() {
		if(remove())
			reset();
	}

	private void reset() {
		if (this.currentDrawer != null) {
			this.currentDrawer.finish();
		}
		this.currentDrawer = null;
		this.temporaryObject = null;
		this.temporaryShape = null;		
		ToolController.getInstance().setDrawExtrusion(false);
		Display.getDefault().asyncExec(() -> ToolControlHandler.getInstance().triggerSelectObject());
	}

	public Object getSubject() {
		return subject;
	}

	public void setSubject(Object subject) {
		this.subject = subject;
	}
	
	public void prepareToEdit(CompoundShape shape) {
		reset();
		setSubject(shape);
		setTemporaryShape(shape);
	}




	class ShapeDrawerEventProcessor extends ActorInputListener {

		float startX, startY;
		long lastClickDate;
		

		
		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
			
			return true;
		}

		@Override
		public void touchDragged(InputEvent event, float x, float y, int pointer) {
			startX = x;
			startY = y;
		}

		@Override
		public boolean keyUp(InputEvent event, int keycode) {
			if (keycode == Input.Keys.ESCAPE) {
				if(end()) {
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							CreateFormWizard formWizard = new CreateFormWizard();
							WizardDialog formWizarddialogue= new OpenWizardDialog(new Shell(Display.getCurrent()) ,formWizard);
							formWizard.setContainer(formWizarddialogue);
							formWizarddialogue.setModal(true);
							formWizarddialogue.setShellStyle(SWT.APPLICATION_MODAL);
							formWizarddialogue.open();
						}
					});
				}else {
					finish();
				}
			}
			return true;
		}
		
	}

}
