package gdxapp.Commun;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.ArrowShapeBuilder;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

import dressing.mathutils.CoordinateSystem;


public class Tools3D {

	public static ModelInstance getBoundingBox(ModelInstance instance) {
		BoundingBox box = new BoundingBox();
		instance.calculateBoundingBox(box);
		ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        modelBuilder.node();
        MeshPartBuilder meshBuilder;
        meshBuilder = modelBuilder.part("part1", GL20.GL_TRIANGLES, VertexAttributes.Usage.Position |
                VertexAttributes.Usage.Normal, new Material(ColorAttribute.createDiffuse(Color.GOLD)));
        VertexInfo v1 = new MeshPartBuilder.VertexInfo().setPos(0, 0, 0).setNor(0, 0, 1).setCol(null).setUV(0.5f, 0.0f);
        VertexInfo v2 = new VertexInfo().setPos(3, 0, 0).setNor(0, 0, 1).setCol(null).setUV(0.0f, 0.0f);
        VertexInfo v3 = new VertexInfo().setPos(3, 3, 0).setNor(0, 0, 1).setCol(null).setUV(0.0f, 0.5f);
        VertexInfo v4 = new VertexInfo().setPos(0, 3, 0).setNor(0, 0, 1).setCol(null).setUV(0.5f, 0.5f);
        VertexInfo v5 = new VertexInfo().setPos(0, 0, 0).setNor(0, 0, 1).setCol(null).setUV(0.5f, 0.0f);
        VertexInfo v6 = new VertexInfo().setPos(3, 0, 0).setNor(0, 0, 1).setCol(null).setUV(0.0f, 0.0f);
        VertexInfo v7 = new VertexInfo().setPos(3, 3, 0).setNor(0, 0, 1).setCol(null).setUV(0.0f, 0.5f);
        VertexInfo v8 = new VertexInfo().setPos(0, 3, 0).setNor(0, 0, 1).setCol(null).setUV(0.5f, 0.5f);
        box.getCorner000(v1.position);
        box.getCorner001(v2.position);
        box.getCorner010(v3.position);
        box.getCorner011(v4.position);
        box.getCorner100(v5.position);
        box.getCorner101(v6.position);
        box.getCorner110(v7.position);
        box.getCorner111(v8.position);
        Vector3 center = new Vector3();
        box.getCenter(center);
        meshBuilder.box(v1, v2, v3, v4, v5, v6, v7, v8);
        Model bounds = modelBuilder.end();
		ModelInstance boxInstance = new ModelInstance(bounds);
		return boxInstance;
	}
	
	public static Model createCoordinateSystem() {
		ModelBuilder modelBuilder = new ModelBuilder();
		int attr = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal;
		modelBuilder.begin();
		MeshPartBuilder meshPartBuilder = modelBuilder.part("AxisX", GL20.GL_TRIANGLES, attr,
				new Material(ColorAttribute.createDiffuse(Color.RED)));
		ArrowShapeBuilder.build(meshPartBuilder, 0, 0, 0, 1, 0, 0, 0.1f, 0.1f, 10);
		modelBuilder.part("AxisY", GL20.GL_TRIANGLES, attr,
					new Material(ColorAttribute.createDiffuse(Color.GREEN)));
		ArrowShapeBuilder.build(meshPartBuilder, 0, 0, 0, 0, 1, 0, 0.1f, 0.1f, 10);
		modelBuilder.part("AxisZ", GL20.GL_TRIANGLES, attr,
				new Material(ColorAttribute.createDiffuse(Color.BLUE)));
		ArrowShapeBuilder.build(meshPartBuilder, 0, 0, 0, 0,0, 1, .1f, .1f, 10);
		return modelBuilder.end();	
	}
	
	public static ModelInstance createCoordinateSystem(CoordinateSystem coordsSystem) {
		ModelBuilder modelBuilder = new ModelBuilder();
		int attr = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal;
		modelBuilder.begin();
		MeshPartBuilder meshPartBuilder = modelBuilder.part("AxisX", GL20.GL_TRIANGLES, attr,
				new Material(ColorAttribute.createDiffuse(Color.RED)));
		ArrowShapeBuilder.build(meshPartBuilder, 0, 0, 0, 1, 0, 0, 0.1f, 0.1f, 10);
		modelBuilder.part("AxisY", GL20.GL_TRIANGLES, attr,
					new Material(ColorAttribute.createDiffuse(Color.GREEN)));
		ArrowShapeBuilder.build(meshPartBuilder, 0, 0, 0, 0, 1, 0, 0.1f, 0.1f, 10);
		modelBuilder.part("AxisZ", GL20.GL_TRIANGLES, attr,
				new Material(ColorAttribute.createDiffuse(Color.BLUE)));
		ArrowShapeBuilder.build(meshPartBuilder, 0, 0, 0, 0,0, 1, .1f, .1f, 10);
		ModelInstance instance = new ModelInstance(modelBuilder.end());
		instance.transform.mul(coordsSystem.transform);
		return instance;	
	}
	
	
	
}
