package dressing.ui.util;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.model.types.CaissonMontageType;

public class SingleImageItemTypeMontageLabelProvider extends LabelProvider implements ITableLabelProvider {
	/**
	 * We return null, because we don't support images yet.
	 * 
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
	 *      int)
	 */
	Composite parent;

	public SingleImageItemTypeMontageLabelProvider(Composite parent) {
		super();
		this.parent = parent;
	}

	public Image getColumnImage(Object element, int columnIndex) {

		CaissonMontageType item = (CaissonMontageType) element;

		if (columnIndex == 0) {

			// Image testImage =
			// ImageDescriptor.createFromFile(EtagereCompositeWelcomePage.class,
			// "icons/ajout.png").createImage();
			// return testImage;

			Bundle bundle = FrameworkUtil.getBundle(SingleImageItemTypeMontageLabelProvider.class);
			if (item != null ) {
				String s="";
				if(item.equals(CaissonMontageType.CAISSON_MONTAGE_L))
					s="icons/MontageL.png";
				else 
					s="icons/MontageI.png";
			Path path = new Path(s);
				if (path != null && !path.isEmpty() && parent != null) {

					URL url = FileLocator.find(bundle, path, null);
					if (url.getPath().contains(".gif") || url.getPath().contains(".png")
							|| url.getPath().contains(".jpg") || url.getPath().contains(".jpeg") ||url.getPath().contains(".JPG")) {
						ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
						ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
						Image im = rsmanager.createImage(descriptor);
						Image scaled216 = new Image(parent.getDisplay(), im.getImageData().scaledTo(16, 16));
						return scaled216;
					}
				}

			}
		}
		return null;
	}

	public SingleImageItemTypeMontageLabelProvider() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
	 *      int)
	 */
	public String getColumnText(Object element, int columnIndex) {

		CaissonMontageType item = (CaissonMontageType) element;

		switch (columnIndex) {
		case 0:
			return item.toString();
		}
		return "";
	}
}
