package dressing.ui.util;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.layout.GridData;
import org.eclipse.wb.swt.SWTResourceManager;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

import param.Vertice3;
import param.impl.ParamFactoryImpl;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;

public class ColorComposite extends Composite {

	Color color;
	private Button btncolorChooser;
	private Label colorLabel;
	private Shell shell;
	boolean dirty=false;
	private PropertyChangeSupport propertyChangeSupport;

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public ColorComposite(Composite parent, int style) {
		super(parent, style);
		this.propertyChangeSupport = new PropertyChangeSupport(this);

		setLayout(new GridLayout(2, false));
		shell = parent.getShell();
		colorLabel = new Label(this, SWT.NONE);
		colorLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
		colorLabel.setText("           ");
		colorLabel.setForeground(SWTResourceManager.getColor(0, 0, 0));
		colorLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		color = new Color(shell.getDisplay(), new RGB(0, 255, 0));

		btncolorChooser = new Button(this, SWT.FLAT);
		btncolorChooser.setBackground(SWTResourceManager.getColor(255, 255, 255));
		btncolorChooser.setText("...");
		btncolorChooser.addSelectionListener(new SelectionAdapter() {
		    public void widgetSelected(SelectionEvent event) {
		      // Create the color-change dialog
		      ColorDialog dlg = new ColorDialog(shell);

		      // Set the selected color in the dialog from
		      // user's selected color
		      dlg.setRGB(colorLabel.getBackground().getRGB());

		      // Change the title bar text
		      dlg.setText("Choose a Color");

		      // Open the dialog and retrieve the selected color
		      RGB rgb = dlg.open();
		      if (rgb != null) {
		        // Dispose the old color, create the
		        // new one, and set into the label
		        color.dispose();
		        color = new Color(shell.getDisplay(), rgb);
		        colorLabel.setBackground(color);
		        propertyChangeSupport.firePropertyChange("Color", null, rgb);
		        dirty=true;
		      }
		    }
		  });
		

	}
	
	public void addColorListener(PropertyChangeListener listener) {
		this.propertyChangeSupport.addPropertyChangeListener(listener);
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public Color getColor() {
		return color;
	}
	
	public Vector3 getRGBVector() {
		return new Vector3(color.getRed()/255.0f, color.getGreen()/255.0f, color.getBlue()/255.0f);
	}

	public boolean isDirty() {
		return dirty;
	}

	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}

	public void setColor(Color color) {
		this.color = color;
	    this.propertyChangeSupport.firePropertyChange("color", this.color, this.color);
	    colorLabel.setBackground(color);
	}
	
	public void setColor(Vector3 color) {
		this.color = new Color(shell.getDisplay(), new RGBA((int)(color.x * 255), (int)(color.y * 255), (int)(color.z * 255), 255));
	    this.propertyChangeSupport.firePropertyChange("color", this.color, this.color);
	    colorLabel.setBackground(this.color);
	}
	
	public void setColor(Vertice3 color) {
		Color color2=new Color(shell.getDisplay(), new RGBA((int)(color.getR()*255), (int)(color.getG()*255), (int)(color.getB()*255),  (int)(color.getA()*255)));
		setColor(color2);
	}
	public Vertice3 getEmfColor() {
		Vertice3 vertice3= ParamFactoryImpl.eINSTANCE.createVertice3();
		vertice3.setR(color.getRed()/255.0f);
		vertice3.setG(color.getGreen()/255.0f);
		vertice3.setB(color.getBlue()/255.0f);
		vertice3.setA(color.getAlpha()/255.0f);
		return vertice3;
	}
	public com.badlogic.gdx.graphics.Color getGDXColor(){
		return new com.badlogic.gdx.graphics.Color(color.getRed()/255.0f, color.getGreen()/255.0f, color.getBlue()/255.0f, color.getAlpha()/255.0f);
	}
	
	public void setColor(com.badlogic.gdx.graphics.Color color) {
		Color color2=new Color(shell.getDisplay(), new RGBA((int)(color.r*255), (int)(color.g*255), (int)(color.b*255), (int)(color.a*255)));
		setColor(color2);
	}

	public Button getBtncolorChooser() {
		return btncolorChooser;
	}

	public void setBtncolorChooser(Button btncolorChooser) {
		this.btncolorChooser = btncolorChooser;
	}

	public Label getColorLabel() {
		return colorLabel;
	}

	public void setColorLabel(Label colorLabel) {
		this.colorLabel = colorLabel;
	}

}
