package dressing.ui.usinage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;

import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import param.Tool;
import param.UsinageFamily;
import param.impl.UsinageFamilyImpl;

public class UsinageFamille  implements IUpdateStructure{

	@Inject 
	ESelectionService selectionService;
	
	@Inject
	IEventBroker eventBroker;
	
	@Inject
	private MDirtyable dirty;
	private UsinageFamilyEditor usinageFamille;
	public UsinageFamille() {
	}

	/**
	 * Create contents of the view part.
	 * @param parent
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		usinageFamille=new UsinageFamilyEditor(parent,  SWT.NONE);
		usinageFamille.setDirty(dirty);
	}

	public UsinageFamilyEditor getUsinageFamille() {
		return usinageFamille;
	}

	public void setUsinageFamille(UsinageFamilyEditor usinageFamille) {
		this.usinageFamille = usinageFamille;
	}

	@Focus
	public void setFocus() {
		// Set the focus
		usinageFamille.setFocus();
	}
	
	@PreDestroy
	public void dispose() {
		usinageFamille.dispose();
	}
	public boolean isDirty() {
		return dirty.isDirty();
	}
	
	@Persist
	@Override
	public void run() throws DesignException {
		usinageFamille.run();
	}
	
	@Override
	public void cancel() {
		usinageFamille.cancel();
	}
	@Persist
	public void save() throws DesignException {
		run();
	}

}
