package dressing.ui.tiroire;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;

public class TirroirlistCellModifier implements ICellModifier {
	private TableViewer viewer;

	public TirroirlistCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * Returns whether the property can be modified
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean canModify(Object element, String property) {
		// Allow editing of all values
		return true;
	}

	/**
	 * Returns the value for the property
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return Object
	 */
	public Object getValue(Object element, String property) {
		if (element instanceof Item)
			element = ((Item) element).getData();
		TirroirListDistances e = (TirroirListDistances) element;
		if (TiroireCompositeWelcomePage.NAME.equals(property))
			return e.getTirroirNom();
		else if (TiroireCompositeWelcomePage.Distance.equals(property))
			return (e.getTirroirDistance().toString());

		else
			return null;
	}

	/**
	 * Modifies the element
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @param value
	 *            the value
	 */
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		TirroirListDistances e = (TirroirListDistances) element;
		if (TiroireCompositeWelcomePage.NAME.equals(property))
			e.setTirroirNom((String) value);
		else if (TiroireCompositeWelcomePage.Distance.equals(property))
		{
			try {
				e.setTirroirDistance((Double.parseDouble((String) value)));
//				
			}catch(NumberFormatException ex)
			{
				System.out.println("Le nombre entrer est incorrect");
			}
		}
		// Force the viewer to refresh
		viewer.refresh();
		
	}
}
