package dressing.ui.separator;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;

import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
public class SeparatorCompositeWizard extends Composite {

	private DataBindingContext m_bindingContext;
	private dressing.controller.Piece2DCreator piece2DCreator = new dressing.controller.Piece2DCreator();
	private ComboViewer comboViewer_1;
	private Spinner spinnersepposition ;
	private ComboViewer comboViewer;
	private Button buttonsepfixe ;
	private Button button_septraversant;
	private Button btnIsimetrique;
	private ComboViewer VcomboReference;
	private Spinner spnRetrait;
	private Spinner spnRetraitDeriere;
	public SeparatorCompositeWizard(Composite parent, int style, dressing.controller.Piece2DCreator newPiece2DCreator) {
		this(parent, style);
		setPiece2DCreator(newPiece2DCreator);
	}

	public SeparatorCompositeWizard(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(1, false));
		
		Group grpSparateur = new Group(this, SWT.NONE);
		grpSparateur.setText("Séparateur");
		grpSparateur.setLayout(new GridLayout(2, false));
		GridData gd_grpSparateur = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_grpSparateur.heightHint = 224;
		gd_grpSparateur.widthHint = 440;
		grpSparateur.setLayoutData(gd_grpSparateur);
		
		buttonsepfixe = new Button(grpSparateur, SWT.CHECK);
		buttonsepfixe.setSelection(true);
		buttonsepfixe.setEnabled(false);
		buttonsepfixe.setText("Avec séparateur fixe");
		
	    button_septraversant = new Button(grpSparateur, SWT.CHECK);
		button_septraversant.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});
		button_septraversant.setText("Séparateur traversant le dos");
		
		Label label = new Label(grpSparateur, SWT.NONE);
		label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label.setText("Axe de séparation");
		
	     comboViewer = new ComboViewer(grpSparateur, SWT.READ_ONLY);
		Combo comboseparationtype = comboViewer.getCombo();
		comboseparationtype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblRfrenceDuPosition = new Label(grpSparateur, SWT.NONE);
		lblRfrenceDuPosition.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRfrenceDuPosition.setText("Référence du position");
		
		VcomboReference = new ComboViewer(grpSparateur, SWT.READ_ONLY);
		Combo comboReference = VcomboReference.getCombo();
		comboReference.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label label_1 = new Label(grpSparateur, SWT.NONE);
		label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label_1.setText("Position de séparation");
		
	    spinnersepposition = new Spinner(grpSparateur, SWT.NONE);
	    GridData gd_spinnersepposition = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spinnersepposition.widthHint = 232;
		spinnersepposition.setLayoutData(gd_spinnersepposition);
		spinnersepposition.setMaximum(50000);
		
		Label label_2 = new Label(grpSparateur, SWT.NONE);
		label_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		label_2.setText("Type de position");
		
		comboViewer_1 = new ComboViewer(grpSparateur, SWT.READ_ONLY);
		Combo combo_positiontype = comboViewer_1.getCombo();
		combo_positiontype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblRetrait = new Label(grpSparateur, SWT.NONE);
		lblRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRetrait.setText("Retrait Depuis Facade");
		
		spnRetrait = new Spinner(grpSparateur, SWT.BORDER);
		spnRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnRetrait.setMaximum(50000);
		
		Label lblNewLabel = new Label(grpSparateur, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText("Retrait Deriere");
		
		spnRetraitDeriere = new Spinner(grpSparateur, SWT.BORDER);
		spnRetraitDeriere.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnRetraitDeriere.setMaximum(50000);
		btnIsimetrique = new Button(grpSparateur, SWT.CHECK);
		btnIsimetrique.setSelection(true);
		btnIsimetrique.setText("Séparateur 50%");
		new Label(grpSparateur, SWT.NONE);

		comboViewer.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer.setInput(SeprationAxe.values());
		
		comboViewer_1.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_1.setInput(PositionCalculationType.values());
		
		VcomboReference.setContentProvider((ArrayContentProvider.getInstance()));
		VcomboReference.setInput(PositionReferenceType.values());
		if (piece2DCreator != null) {
			m_bindingContext = initDataBindings();
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.controller.Piece2DCreator getPiece2DCreator() {
		return piece2DCreator;
	}

	public void setPiece2DCreator(dressing.controller.Piece2DCreator newPiece2DCreator) {
		setPiece2DCreator(newPiece2DCreator, true);
	}

	public void setPiece2DCreator(dressing.controller.Piece2DCreator newPiece2DCreator, boolean update) {
		piece2DCreator = newPiece2DCreator;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (piece2DCreator != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSelectionButtonsepfixeObserveWidget = WidgetProperties.buttonSelection().observe(buttonsepfixe);
		IObservableValue withsepratorPiece2DCreatorObserveValue = BeanProperties.value("withseprator").observe(piece2DCreator);
		bindingContext.bindValue(observeSelectionButtonsepfixeObserveWidget, withsepratorPiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionButton_septraversantObserveWidget = WidgetProperties.buttonSelection().observe(button_septraversant);
		IObservableValue sepratortransversalPiece2DCreatorObserveValue = BeanProperties.value("sepratortransversal").observe(piece2DCreator);
		bindingContext.bindValue(observeSelectionButton_septraversantObserveWidget, sepratortransversalPiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue seprationaxePiece2DCreatorObserveValue = BeanProperties.value("seprationaxe").observe(piece2DCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer, seprationaxePiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinnerseppositionObserveWidget = WidgetProperties.spinnerSelection().observe(spinnersepposition);
		IObservableValue separationpositionPiece2DCreatorObserveValue = BeanProperties.value("separationposition").observe(piece2DCreator);
		bindingContext.bindValue(observeSelectionSpinnerseppositionObserveWidget, separationpositionPiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnIsimetriqueObserveWidget = WidgetProperties.buttonSelection().observe(btnIsimetrique);
		IObservableValue isSepIsometriquePiece2DCreatorObserveValue = BeanProperties.value("isSepIsometrique").observe(piece2DCreator);
		bindingContext.bindValue(observeSelectionBtnIsimetriqueObserveWidget, isSepIsometriquePiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_1_1 = ViewerProperties.singleSelection().observe(comboViewer_1);
		IObservableValue positionCalculationTypePiece2DCreatorObserveValue = BeanProperties.value("positionCalculationType").observe(piece2DCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer_1_1, positionCalculationTypePiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionVcomboReference = ViewerProperties.singleSelection().observe(VcomboReference);
		IObservableValue sepPosRefTypePiece2DCreatorObserveValue = BeanProperties.value("sepPosRefType").observe(piece2DCreator);
		bindingContext.bindValue(observeSingleSelectionVcomboReference, sepPosRefTypePiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnRetraitObserveWidget = WidgetProperties.spinnerSelection().observe(spnRetrait);
		IObservableValue sepRetraitPiece2DCreatorObserveValue = BeanProperties.value("sepRetrait").observe(piece2DCreator);
		bindingContext.bindValue(observeSelectionSpnRetraitObserveWidget, sepRetraitPiece2DCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnRetraitDeriereObserveWidget = WidgetProperties.spinnerSelection().observe(spnRetraitDeriere);
		IObservableValue sepretraitderierePiece2DCreatorObserveValue = BeanProperties.value("sepretraitderiere").observe(piece2DCreator);
		bindingContext.bindValue(observeSelectionSpnRetraitDeriereObserveWidget, sepretraitderierePiece2DCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
