package dressing.ui.bloctiroir;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.BlocTirroirCreator;
import dressing.controller.CuisineCreator;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Project3D;
import dressing.model.evalutor.GeometricEngineException;

public class BlocTiroirWizard extends Wizard {
	BlocTiroirWizardPage cuisinepage;
	Cuisine cuisine;
	BlocTirroirCreator creator=new BlocTirroirCreator();
	public BlocTiroirWizard() {
		setWindowTitle("ajouter un bloc tiroir");
	}

	@Override
	public void addPages() {
		 cuisinepage=new BlocTiroirWizardPage("welcome Page", creator);
		this.addPage(cuisinepage);
	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				this.creator.create();
				cuisinepage.clearlistners();
			
				this.cuisine.addElement(creator.getInstance());		
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

					
			return true;
	}
	
public void setParent(Cuisine cuisine) {
	this.cuisine = cuisine;	
	this.creator.setParent(cuisine);
}
	

}
