package dressing.model.persistence.dpos;


import java.util.HashMap;

import dressing.model.DesignObject3D;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.object3d.DoorHandle;
import gdxapp.object3d.GolaProfile;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObjectFactory;
import jakarta.xml.bind.annotation.XmlRootElement;
import param.MechanicDesign;

@XmlRootElement(name="KitchenElement")
public class KitchenElementDPO extends Object3D implements DPO<KitchenElement>{

	private SceneTexture facadeTexture;
	private SceneTexture boxTexture;
	private SceneTexture backTexture;
	private String pathToFrontImage;
	private String pathToBackImage;
	private HashMap<String, DoorHandle> doorHandles;
	private GolaProfile profile;
	
	public KitchenElementDPO() {}
		
	
	@Override
	public KitchenElement getWorldActor() {
		DesignObject3D designObject3D = ProjectManager.instance.getCurrentKitchen().getElement(this.uuid);
		if(designObject3D!=null) {
			KitchenElement kitchenElement = new KitchenElement();
			kitchenElement.setSceneId(this.sceneID);
			kitchenElement.setRealWorldDimension(this.dimension);
			kitchenElement.setRealWorldPosition(this.position);
			kitchenElement.setRotation(this.rotation);
			kitchenElement.setFacadeTexture(this.facadeTexture);
			kitchenElement.setBoxTexture(this.boxTexture);
			kitchenElement.setBackTexture(this.backTexture);
			kitchenElement.setDoorHandles(this.doorHandles);
			kitchenElement.setProperties(this.properties);
			kitchenElement.setProfile(this.profile);
			WorldObjectFactory.getFactory().loadObjectFromDefinition(kitchenElement, designObject3D);
			return kitchenElement;
		
		}else {
			System.err.println("designObject3D non trouver");
			return null;
		}
	}



	@Override
	public DPO<KitchenElement> from(KitchenElement entity) {
		super.set(entity);
		set(entity);
		return this;
	}

	@Override
	public KitchenElement get() {
		KitchenElement element = new KitchenElement();
		element.setFacadeTexture(facadeTexture);
		element.setBoxTexture(boxTexture);
		element.setBackTexture(backTexture);
		element.setUuid(uuid);
		element.setRealWorldPosition(position);
		element.setRealWorldDimension(dimension);
		element.setRotation(rotation);
		element.setSceneId(sceneID);
		element.setProperties(properties);
		element.setDoorHandles(doorHandles);
		element.setProfile(profile);
		return element;
	}
	
	public void set(KitchenElement element) {
		setBackTexture(element.getBackTexture());
		setBoxTexture(element.getBoxTexture());
		setFacadeTexture(element.getFacadeTexture());
		setPathToBackImage(element.getPathToBackImage());
		setPathToFrontImage(element.getPathToFrontImage());
		setDoorHandles(element.getDoorHandles());
		setProfile(element.getProfile());
		
	}

	public SceneTexture getFacadeTexture() {
		return facadeTexture;
	}

	public void setFacadeTexture(SceneTexture facadeTexture) {
		this.facadeTexture = facadeTexture;
	}

	public SceneTexture getBoxTexture() {
		return boxTexture;
	}

	public void setBoxTexture(SceneTexture boxTexture) {
		this.boxTexture = boxTexture;
	}

	public SceneTexture getBackTexture() {
		return backTexture;
	}

	public void setBackTexture(SceneTexture backTexture) {
		this.backTexture = backTexture;
	}

	public String getPathToFrontImage() {
		return pathToFrontImage;
	}

	public void setPathToFrontImage(String pathToFrontImage) {
		this.pathToFrontImage = pathToFrontImage;
	}

	public String getPathToBackImage() {
		return pathToBackImage;
	}

	public void setPathToBackImage(String pathToBackImage) {
		this.pathToBackImage = pathToBackImage;
	}


	public HashMap<String, DoorHandle> getDoorHandles() {
		return doorHandles;
	}


	public void setDoorHandles(HashMap<String, DoorHandle> doorHandles) {
		this.doorHandles = doorHandles;
	}


	public GolaProfile getProfile() {
		return profile;
	}


	public void setProfile(GolaProfile profile) {
		this.profile = profile;
	}
	
	

	
	
}
