package dressing.model;

import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CuisineCaissonType;

public class CaissonCuisine extends Caisson {
	CuisineCaissonType caissoncuisineType=CuisineCaissonType.haut;
	

	public CuisineCaissonType getCaissoncuisineType() {
		return caissoncuisineType;
	}

	public void setCaissoncuisineType(CuisineCaissonType caissoncuisineType) {
		CuisineCaissonType oldValue = this.caissoncuisineType;
		this.caissoncuisineType = caissoncuisineType;
		firePropertyChange("caissoncuisinetype", oldValue, this.caissoncuisineType);
	}

	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return super.getXSize();
	}

	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return super.getYSize();
	}

	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return super.getZSize();
	}
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Piece2D||child instanceof Tirroir)
		{
			return true;
		}
		
		return false;
	}
	public String printDescription()
	{		
		String s="";
		s+=" 	Cuisson "  + getName() +"\n";
		s+=" 	Type "  + getCuissontype() +"\n";
		s+=" 	Longeur extenre "  + getLongeurext() +" mm \n";
		s+=" 	Hauteur extenre "  + getHauteurext() +" mm \n";
		s+=" 	Profondeur extenre "  + getProfondeurext() +" mm \n";
		
		s+=" 	Longeur interne "  + getLongeurint() +" mm \n";
		s+=" 	Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" 	Profondeur interne "  + getProfondeurint() +" mm \n";
		s+="	#################### Les sous elements ########## \n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	

	@Override
	public DesignObject3D clone() {
		CaissonCuisine space=new CaissonCuisine();
		try {
			space=(CaissonCuisine) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		CaissonCuisine caisson=(CaissonCuisine) object;
		caisson.setCaissoncuisineType(getCaissoncuisineType());
		caisson=(CaissonCuisine) super.copy(caisson);
		for(DesignObject3D design:caisson.getChilds()) {
			if(design instanceof Bande) {
				Bande bande=(Bande) design;
				bande.setParentCaissonCuisine(caisson);
			}
		}
		
		return caisson;
	}

}
