package dressing.handlers;
import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Cuisine;
import dressing.model.Dressing;
import dressing.model.Project3D;
import dressing.model.Space3D;
import dressing.ui.caissonciosine.CaissonCuisineDialog;
import dressing.ui.caissonciosine.CaissonCuisineWizard;
import dressing.ui.cuisine.CuisineWizard;

public class AddCaissonCuisineDialogHandler {




		@Inject ESelectionService selectionService;
		
		@Inject
		IEclipseContext  eclipsecontext;
		@Execute
		public void execute(Shell shell){

			Object o = selectionService.getSelection("dressing.part.tree");
			//Voire l element de l arbre selectionne
			if(o!=null && o instanceof Cuisine)
			{
//				CaissonCuisineDialog cuissondialog = ContextInjectionFactory.make(CaissonCuisineDialog.class,eclipsecontext);
//				CaissonCuisineDialog cuissondialog =new CaissonCuisineDialog(shell);
//				cuissondialog.create();
//				cuissondialog.setSpace3d((Space3D) o);
//				
//				if (cuissondialog.open() == Window.OK) {
//				    System.out.println("hi");
//				   
//				}
				Cuisine project =(Cuisine)o;
				CaissonCuisineWizard cuisinewizrad = ContextInjectionFactory.make(CaissonCuisineWizard.class,eclipsecontext);
				cuisinewizrad.setProject3d(project);
				WizardDialog dialog = new WizardDialog(shell, cuisinewizrad);
				dialog.open();
			}	
		}
		@CanExecute
		public boolean check()
		{
			Object o = selectionService.getSelection("dressing.part.tree");
			//Voire l element de l arbre selectionne
//			if(o!=null && o instanceof Project3D)
//			{
//				return true;
//			}	
			return true;
		}
	}

