package update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleException;
import frs.updater.dir.FileUtils;
import update.FRSUpdateManager;
import update.NetClientPost;
import update.UpdateServerConnexion;
import update.UpdatorNotification;
import update.UpdatorException;

public class FRSUpdateManager implements Runnable {

	private Thread thread;
	private Display display;
	private String login;
	private String pass;
	private String server;
	private String port;
	private String client = "UKNOWN";
	private String clientkey = "UKNOWN";
	private String hostname = "UKNOWN";
	private String releaseDate = null;
	NetClientPost post = null;// Scho 728 upate multi poste
	private boolean stop = false;
	private final int UPDATE_COUNT = 20;
	private final long PERIOD = 60 * 1000 * 30;// chaque 30 min check for update
	private int counter = 0;
	private boolean enabled = false;

	private boolean applyupdatenextstart = true;
	// Scho 700 ajout gestion de cache
	private boolean reloadcachefile = false;
	private boolean reloadcachefileerror = false;
	private String currentversion = null;
	private String PRODUCT = null;
	private boolean reportupdatebyuser = false;
	private String reportedversion = null;
	private String lastRelease;
	UpdateServerConnexion serverConnexion = new UpdateServerConnexion();

	private static final String UPDATE_CONFIG_PATH = System.getProperty("user.home") + File.separator + "AppData" + File.separator + "Local" + File.separator +
			 "SuperCad" + File.separator + "config" + File.separator + "update.properties";
	private static final String UPDATE_FOLDER_PATH = System.getProperty("user.home") + File.separator + "AppData" + File.separator + "Local" + File.separator +
			 "SuperCad" + File.separator + "Update";
	ArrayList<String> registrederror = new ArrayList<>();// Scho 728 upate multi poste
	private int migrationstatus = NO_MIGARTION;
	public static final int NO_MIGARTION = 0;
	public static final int MIGARTION_SUCCES = 1;
	public static final int MIGARTION_FAILURE = 2;
	ArrayList<UpdatorNotification> notifylist = new ArrayList<>();
	private String log = "";
	private static FRSUpdateManager updatemanager = null;
	private IWorkbench workbench;

	public static FRSUpdateManager getInstance() {
		if (updatemanager == null) {
			updatemanager = new FRSUpdateManager();
			return updatemanager;
		} else
			return updatemanager;
	}

	private FRSUpdateManager() {		
		final Properties props = new Properties();
		File f = new File(UPDATE_CONFIG_PATH);
		FileInputStream inputstream = null;
		if (f.exists()) {
			try {
				inputstream = new FileInputStream(f);
				props.load(inputstream);
				this.login = props.getProperty("login");
				this.pass = props.getProperty("pass");
				this.server = props.getProperty("httpserver");
				this.port = props.getProperty("port");
				this.client= props.getProperty("client");
				serverConnexion.setUsername(this.login);
				serverConnexion.setPassword(this.pass);
				serverConnexion.setServerhost("http://" + this.server + ":" + this.port + "/");
				serverConnexion.setClient(this.client);
				inputstream.close();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					if (inputstream != null)
						inputstream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		} else {
			System.out.println("Mise à jour désactivées (fichier de configuration manquant)");
		}
	}

	@Override
	public void run() {
		System.err.println("UpdateManager started");
		System.out.println("app path:"  + System.getProperty("eclipse.launcher"));
		while (!stop) {
			if (counter < UPDATE_COUNT) {
				// recuper les version et la logique a partir des webservices
				post = new NetClientPost(serverConnexion);
				try {
					hostname = InetAddress.getLocalHost().getHostName();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					System.err.println("Impossible to get Machine Name");
				}
				post.setHostname(hostname);
				try {
					final Properties props = new Properties();
					System.err.println("Reading local infos");
					InputStream inputstream = getClass().getResourceAsStream("/builindinginfos");
					props.load(inputstream);
					currentversion = props.getProperty("build.number");
					PRODUCT = props.getProperty("app.name");
					releaseDate = props.getProperty("compilation.date");
					System.err.println("Product " + PRODUCT + " version" + currentversion);
					post.setClient(client);
					post.setProduct(PRODUCT);
					post.setCurrentversion(currentversion);
					System.err.println("Connecting to server");
					post.connectToServer();
					System.err.println("Connectinon to server succes");
					// register build
					System.err.println("Register Build");
					String retval = post.registerBuild(client, PRODUCT, currentversion, hostname);

					if (retval == null) {
						System.err.println("Registration Failed");
					} else {
						System.err.println("Registration Succes");
					}

					if (migrationstatus == MIGARTION_SUCCES) {
						post.LogX(NetClientPost.LOG_UPDATE_OK, "Installation Succes to " + currentversion);
					} else if (migrationstatus == MIGARTION_FAILURE) {
						post.LogX(NetClientPost.LOG_ERROR, "Migration failure to " + currentversion);
					}
					if (reloadcachefileerror) {
						post.LogX(NetClientPost.LOG_ERROR, "Un erreur rencontré au demarrage au niveau de cache");
					}
					migrationstatus = NO_MIGARTION;// scho 774 reset la variable pour ne pas envoyer deux fois le log
					lastRelease = post.getLastRelease(client, PRODUCT, currentversion);
					// Il y une mise a jour disponible
					if (lastRelease != null && !lastRelease.equalsIgnoreCase(reportedversion)) {
						System.err.println("New Version found" + lastRelease);
						System.err.println("Preparing patch");
						post.LogX("New Version found in server " + lastRelease + " Prepare patch from " + currentversion
								+ " to " + lastRelease);
						String rep = post.preparePatch(client, PRODUCT, currentversion, lastRelease);
						if (rep != null) {
							System.err.println("Patch created");
							post.LogX("Patch created from " + currentversion + " to " + lastRelease);
							check();
							if(!reportupdatebyuser) {
								downloadAndupdate(PRODUCT, currentversion, lastRelease, reportupdatebyuser);
							}
						} else {
							post.LogX(NetClientPost.LOG_ERROR,
									"Patch creation problem from " + currentversion + " to " + lastRelease);
						}

					} else if (lastRelease != null && lastRelease.equalsIgnoreCase(reportedversion)) {
						System.err.println("Une mise a jour est déja téléchargé en attente d'installation");
						System.err.println("La version "+reportedversion+" en attente d'installation");
					} else {
						System.err.println("Aucune mise à jour trouvé");
						clear();
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					if (e instanceof UpdatorException) {
						System.err.println("Un problème est survenue lors de téléchargement");
					} else {
						System.err.println("Un problème de communication avec le serveur");
					}
					stop = true;
					clear();
				} finally {
//					pushnewversionwaiting();
				}
				if (!stop) {
					try {
						// Sleep 1 minute
						Thread.sleep(PERIOD);
					} catch (InterruptedException e) {
						System.err.println("Thread Waked Up");
					}
				}
				counter++;
			} else {
				stop = true;
			}

		}
		System.err.println("UpdateManager stopped");
	}
	
	public  synchronized void start() {
		if (!this.isStarted()) {
			this.startWatcher();
		} else {
			throw new RuntimeException("UpdateManager already started");
		}
	}

	private void startWatcher() {
		if (this.enabled) {
			this.thread = new Thread(this);
			this.thread.setDaemon(false);
			this.thread.setPriority(Thread.MIN_PRIORITY);
			this.thread.start();
		}
	}

	private boolean isStarted() {
		if (thread == null) {
			return false;
		}
		return this.thread.isAlive();
	}
	
	
	public boolean checkLocal() {
		try {
			//read existing installed version
			File tempDir = new File(UPDATE_FOLDER_PATH);
			File versionfile = new File(UPDATE_FOLDER_PATH + File.separator + ".version");
			if(!tempDir.exists() || !versionfile.exists())
			{
				return false;
			}
			//Scho 730 add lock file
			File downloadlock = new File(UPDATE_FOLDER_PATH + File.separator + "downloadlock");
			if(downloadlock.exists())
			{
				//Supprimer le dossier update si tous est bon
				FileUtils.rm_R(tempDir);
				return false;
			}
			if(tempDir.exists() && versionfile.exists())
			{
				//Verfier si les versions sont egaux
				InputStream in = new FileInputStream(versionfile);
				String versionupdate = FileUtils.read(in) ;
				if(versionupdate!=null)
					versionupdate = versionupdate.trim();
				if(versionupdate!=null && versionupdate.equalsIgnoreCase(currentversion))
				{
					 //Scho 700 ajout gestion de cache
					setReloadcachefile(true); //Force system de reload cache suite a une mise ajour
					//Supprimer le dossier update si tous est bon
					FileUtils.rm_R(tempDir);
					return false;
				}
				else
				{
					return true;
				}	
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
		return false;
	}
	
	public synchronized void check() {

		this.checkLocalApplicationUpdates();
	}
	
	
	public void checkLocalApplicationUpdates() {
		System.err.println(log);
		final Properties props = new Properties();
		InputStream inputstream=null;
		try {
//			inputstream = FRSUpdateManager.class.getResourceAsStream("/builindinginfos");
//			props.load(inputstream);			
//			String currentVersion = props.getProperty("build.number");
//			String product = props.getProperty("app.name");
//			System.err.println("Product "+product+" version "+currentVersion);
//			currentversion = currentVersion;
//			PRODUCT = product;
			//read existing installed version
			File tempDir = new File(UPDATE_FOLDER_PATH);
			File versionfile = new File(UPDATE_FOLDER_PATH + File.separator + ".version");
			if(!tempDir.exists() || !versionfile.exists())
			{
				System.err.println("Aucune mise a jour en attente");
				return;
			}
			
			//Scho 730 add lock file
			File downloadlock = new File(UPDATE_FOLDER_PATH + File.separator + "downloadlock");
			if(downloadlock.exists())
			{
				System.err.println("Telechargement interrompue");
				//Supprimer le dossier update si tous est bon
				FileUtils.rm_R(tempDir);
				return;
			}
			if(tempDir.exists() && versionfile.exists())
			{
				//Verfier si les versions sont egaux
				InputStream in = new FileInputStream(versionfile);
				String versionupdate = FileUtils.read(in) ;
				if(versionupdate!=null)
					versionupdate = versionupdate.trim();
				if(versionupdate!=null && versionupdate.equalsIgnoreCase(currentversion))
				{
					 //Scho 700 ajout gestion de cache
					setReloadcachefile(true); //Force system de reload cache suite a une mise ajour
					System.err.println("Aucune mise a jour en attente");
					//Supprimer le dossier update si tous est bon
					FileUtils.rm_R(tempDir);
					return;
				}
				else
				{
					//Une mise ajour on attente il faut la verifier
					try
					{
						int updateversion = Integer.parseInt(versionupdate);
						int currentversionnbr = Integer.parseInt(currentversion);
						if(updateversion>currentversionnbr)
						{
							//Verfier si le fichier zip et le update existe pour lancer la mise a jour
							File zipfile = new File(UPDATE_FOLDER_PATH + File.separator + currentversion +"to"+ updateversion + ".zip");
							File jarfile = new File(UPDATE_FOLDER_PATH + File.separator + "update.jar");
							if(!zipfile.exists() || !jarfile.exists() )
							{
								setLog("Les fichiers "+zipfile.getName()+" et/ou  "+jarfile.getName()+" n'existent pas");
								System.err.println(log);
								return;
							}

							//verifer
							// recuper les version et la logique a partir des webservices
							post = new NetClientPost(serverConnexion);
							try {
								hostname = InetAddress.getLocalHost().getHostName();
							}
							catch (Exception e) {
								// TODO Auto-generated catch block
								System.err.println("Impossible to get Machine Name");
							}
							post.setHostname(hostname);
							post.setClient(client);
							post.setProduct(PRODUCT);
							post.setCurrentversion(currentversion);
							
							System.err.println("Connecting to server");
							post.connectToServer();
							System.err.println("Connection to server succes");
							display.asyncExec(new Runnable() {
								
								@Override
								public void run() {
									try {
										updateAppStart( PRODUCT, ""+ currentversionnbr, ""+updateversion);
									} catch (BundleException e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}
									
								}
							});
							
							
						}
					}
					catch(Exception ex)
					{
						System.err.println("Impossible de recuperer les version ils ne semblent pas entiers");
						return;
					}	
				}	
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
		try {
			if(inputstream!=null)
			inputstream.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	public  synchronized void stop() {
		stop = true;
	}

	public  synchronized void forceUpdate() {
		counter = 0;//Scho 780 assistant de mise a our force update
		System.out.println("Forcing update");
		if(this.thread!=null)
		{
			if(this.thread.isAlive())
			{
				this.thread.interrupt();
			}
			else
			{
				this.thread=null;
			}
		}
		//Si le thread 
		if(this.thread==null)
		{
			stop = false;
			start();
		}
	}


	public IWorkbench getWorkbench() {
		return workbench;
	}

	public void setWorkbench(IWorkbench workbench) {
		this.workbench = workbench;
	}

	private void downloadAndupdate(String product, String fromversion, String toVersion, boolean updatenextstart)
			throws UpdatorException {
		
		String ftpzipfilename = fromversion + "to" + toVersion + ".zip";
		String ftpapdatefilename = "update.jar";
		String zipfileremotepath = "/" + product + "/" + ftpzipfilename;
		String jarfileremotepath = "/" + product + "/" + ftpapdatefilename;
		System.err.println("Patch file" + ftpzipfilename);
		System.err.println("Patch file in server" + zipfileremotepath);
		System.err.println("Préparation de la mise à jour");
		System.out.println("Update application");
		File tempDir = new File(UPDATE_FOLDER_PATH);
		if (tempDir.exists()) {
			FileUtils.rmR(tempDir);
		}
		tempDir.mkdirs();
		if (!tempDir.exists()) {
			post.LogX(NetClientPost.LOG_ERROR, "Directory Clearing problem");
			displayMessage("Impossible de créer le dossier Update\nVérifiez les permissions des fichiers ou lancez le logiciel en tant qu'administrateur");			
			throw new UpdatorException();
		}
		File f = new File( UPDATE_FOLDER_PATH + File.separator + ".version");
		File downloadlock = new File(  UPDATE_FOLDER_PATH + File.separator + "downloadlock");// Scho 730 add lock file
		try {
			downloadlock.createNewFile();
			System.out.println("Create lock file");
		} catch (IOException e2) {
			// TODO Auto-generated catch blocke2.
			e2.printStackTrace();
			post.LogX(NetClientPost.LOG_ERROR, "Creating Download file lock problem");
			throw new UpdatorException();
		}
		try {
			FileUtils.write(String.valueOf(toVersion) + "\n", f);
		} catch (IOException e1) {
			post.LogX(NetClientPost.LOG_ERROR, "Creating .version file problem");
			System.err.println("Impossible de créer le .version\nVérifiez les permissions des fichiers ou lancez le logiciel en tant qu'administrateur");		
			throw new UpdatorException();
		}

		try {
			try {
				System.err.println("Downloading" + zipfileremotepath);
				post.LogX("Start downloading " + zipfileremotepath);

				Long zipfilsize = post.getFileSize(zipfileremotepath);
				Long jarfilsize = post.getFileSize(jarfileremotepath);
				InputStream streaminpathfile = post.getStreamDownload(zipfileremotepath);
				if (streaminpathfile != null) {
					OutputStream out = new FileOutputStream(tempDir.getAbsolutePath() + "/" + ftpzipfilename);
					// Transfer bytes from in to out
					byte[] buf = new byte[1024];
					int len;
					while ((len = streaminpathfile.read(buf)) > 0) {
						out.write(buf, 0, len);
					}
					streaminpathfile.close();
					out.close();
				} else {
					post.LogX(NetClientPost.LOG_ERROR, "Failed due to null stream for the file  " + zipfileremotepath);
					throw new UpdatorException();
				}
				System.err.println("Downloading succes" + zipfileremotepath);
				System.err.println("Downloading " + jarfileremotepath);
				post.LogX("Start downloading " + jarfileremotepath);
				InputStream streaminjar = post.getStreamDownload(jarfileremotepath);
				if (streaminjar != null) {
					OutputStream out = new FileOutputStream(tempDir.getAbsolutePath() + "/" + ftpapdatefilename);
					// Transfer bytes from in to out
					byte[] buf = new byte[1024];
					int len;
					while ((len = streaminjar.read(buf)) > 0) {
						out.write(buf, 0, len);
					}
					streaminjar.close();
					out.close();
				} else {
					post.LogX(NetClientPost.LOG_ERROR, "Failed due to null stream for the file  " + jarfileremotepath);
					throw new UpdatorException();
				}
				System.err.println("Downloading succes " + jarfileremotepath);
				// Comparer avec les fichers telecharge
				File zipfiledowloaded = new File(tempDir.getAbsolutePath() + "/" + ftpzipfilename);
				File jarfiledowloaded = new File(tempDir.getAbsolutePath() + "/" + ftpapdatefilename);
				if (zipfiledowloaded.length() != zipfilsize) {
					post.LogX(NetClientPost.LOG_ERROR, "Failed zip size of file downloaded differnte remote : "
							+ zipfilsize + " local :" + zipfiledowloaded.length());
					throw new UpdatorException();
				}
				if (jarfiledowloaded.length() != jarfilsize) {
					post.LogX(NetClientPost.LOG_ERROR, "Failed jar size of file downloaded diffent remote : "
							+ jarfilsize + " local :" + jarfiledowloaded.length());
					throw new UpdatorException();
				}

				post.LogX(NetClientPost.LOG_DOWNLOAD_OK, "Dowloading succes from " + fromversion + " to " + toVersion);
				System.out.println("Delete lock file");
				downloadlock.delete();// Scho 730 add lock file
				System.out.println("Téléchargement effectué avec succes");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				System.err.println("Downloading failed ");
				post.LogX(NetClientPost.LOG_ERROR, "Dowloading failed from " + fromversion + " to " + toVersion);
				System.err.println("Téléchargement interrompue");
				throw new UpdatorException();
			}

			System.out.println("Téléchargement terminé");
			if (!updatenextstart) {
				display.asyncExec(new Runnable() {

					@Override
					public void run() {
						// TODO Auto-generated method stub
						try {
							updateAppStart(product, fromversion, toVersion);
						} catch (BundleException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					
				});
				
			}

		} catch (Exception e) {
			e.printStackTrace();
			post.LogX(NetClientPost.LOG_ERROR, "Error when downloading  " + fromversion + " to " + toVersion);
//			displayMessage("Téléchargement interrompue");
			throw new UpdatorException();
		}

	}

	private void displayMessage(String message) {
		MessageDialog.openInformation(display.getActiveShell(), "", message);
		
	}

	private void updateAppStart(String product, String fromversion, String toVersion) throws BundleException {
		String ftpzipfilename = fromversion + "to" + toVersion + ".zip";
		String ftpapdatefilename = "update.jar";
		String zipfileremotepath = File.separator + product + File.separator + ftpzipfilename;
		String jarfileremotepath = File.separator + product + File.separator + ftpapdatefilename;
		File tempDir = new File(UPDATE_FOLDER_PATH);
		System.err.println("Patch file" + ftpzipfilename);
		System.err.println("Patch file in server" + zipfileremotepath);

		File zipfile = new File(tempDir.getAbsolutePath() + File.separator + ftpzipfilename);
		File updatefile = new File(tempDir.getAbsolutePath() + File.separator + ftpapdatefilename);

		String[] options = { "Maintenant", "Au prochain démarrage" };
		// customized MessageDialog with configured buttons
		int res;
		String msg = "il y un nouveau mise à jour, voulez vous l'installer maintenant";
				MessageDialog dialog = new MessageDialog(display.getActiveShell(), "update manager", null, msg,
						0, options,1);	
		res = dialog.open();
		if (res == 1) {
			reportupdatebyuser = true;
			reportedversion = toVersion;
			post.LogX("Reporting installation to next app start" + fromversion + " to " + toVersion);
			return;
		}

		post.LogX("Start application migration " + fromversion + " to " + toVersion);
		String zipfilepath = zipfile.getAbsolutePath();
		String updaterFilename = tempDir.getAbsolutePath() + File.separator + ftpapdatefilename;
		String launcher = System.getProperty("eclipse.launcher");
		File file = new File(launcher);
		if(!file.exists()) {
			System.err.println("can t find launcher!");
			return;
		}
		
		String apppath = file.getParentFile().getAbsolutePath();
		System.out.println("app path:" + apppath);
		try {
			String javahome = System.getProperty("java.home");
			System.out.println(javahome);
			String javapath = javahome + File.separator + "bin" + File.separator +"java";
			Runtime rt = Runtime.getRuntime();
			Process p = null;
			ProcessBuilder pb;
			String cmd = "java -jar " + updaterFilename + " \"" + zipfilepath + "\"" + " \"" + apppath + "\""; 
			System.err.println("executing command:" + cmd);
			p = Runtime.getRuntime().exec(cmd );
			// Les arguments doivent etre imeprativement sans des espaces
			// sinon l erreur. Could not create the Java Virtual Machine
			// occure
			// la commande java prend celui de javva quiu appele le
			// programme en cours
			// aention au espace ellefait unbe errier apares avec trailing
			// char
			
//			pb = new ProcessBuilder("java", "-Xms256M", "-jar", updaterFilename, "\"" + zipfilepath + "\"",
//					"\"" + apppath + "\"");
//			p = pb.start();
			
		} catch (Exception e) {
			e.printStackTrace();
			post.LogX(NetClientPost.LOG_ERROR,
					"Error when start application migration " + fromversion + " to " + toVersion);
			MessageDialog.openError(display.getActiveShell(), "erreur", "Erreur de mise a jour");
		}
		
		if(workbench!=null) {
			workbench.close();
		}

	}
	
	
	private void clear() {
		reportupdatebyuser = false;
		reportedversion = null;
		File tempDir = new File("Update");
		if (tempDir.exists()) {
			FileUtils.rmR(tempDir);
		}
	}

	public String getLogin() {
		return login;
	}

	public void setLogin(String login) {
		this.login = login;

	}

	public String getPass() {
		return pass;
	}

	public void setPass(String pass) {
		this.pass = pass;
	}

	public String getServer() {
		return server;
	}

	public void setServer(String server) {
		this.server = server;
	}

	public String getPort() {
		return port;
	}

	public void setPort(String port) {
		this.port = port;
	}

	public String getClient() {
		return client;
	}

	public void setClient(String client) {
		this.client = client;
	}

	public String getHostname() {
		return hostname;
	}

	public void setHostname(String hostname) {
		this.hostname = hostname;
	}

	public int getCounter() {
		return counter;
	}

	public void setCounter(int counter) {
		this.counter = counter;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public boolean isApplyupdatenextstart() {
		return applyupdatenextstart;
	}

	public void setApplyupdatenextstart(boolean applyupdatenextstart) {
		this.applyupdatenextstart = applyupdatenextstart;
	}

	public boolean isReloadcachefile() {
		return reloadcachefile;
	}

	public void setReloadcachefile(boolean reloadcachefile) {
		this.reloadcachefile = reloadcachefile;
	}

	public boolean isReloadcachefileerror() {
		return reloadcachefileerror;
	}

	public void setReloadcachefileerror(boolean reloadcachefileerror) {
		this.reloadcachefileerror = reloadcachefileerror;
	}

	public String getCurrentversion() {
		return currentversion;
	}

	public void setCurrentversion(String currentversion) {
		this.currentversion = currentversion;
	}

	public String getPRODUCT() {
		return PRODUCT;
	}

	public void setPRODUCT(String pRODUCT) {
		PRODUCT = pRODUCT;
	}

	public boolean isReportupdatebyuser() {
		return reportupdatebyuser;
	}

	public void setReportupdatebyuser(boolean reportupdatebyuser) {
		this.reportupdatebyuser = reportupdatebyuser;
	}

	public String getReportedversion() {
		return reportedversion;
	}

	public void setReportedversion(String reportedversion) {
		this.reportedversion = reportedversion;
	}

	public void setClientkey(String clientkey) {
		this.clientkey = clientkey;
	}

	public String getClientkey() {
		return clientkey;
	}
	
	public final NetClientPost getPost() {
		return post;
	}

	public String getReleaseDate() {
		return releaseDate;
	}

	public void setReleaseDate(String releaseDate) {
		this.releaseDate = releaseDate;
	}

	public String getLog() {
		return log;
	}

	public void setLog(String log) {
		System.err.println("firePropertyChange");
		this.log = log;
	}

	public Display getDisplay() {
		return display;
	}

	public void setDisplay(Display display) {
		this.display = display;
	}
	

	public String getLastRelease() {
		return lastRelease;
	}

	public void setLastRelease(String lastRelease) {
		this.lastRelease = lastRelease;
	}

	public boolean lookupForUpdates() {
		boolean result = false;
		try {
			post.connectToServer();
			lastRelease = post.getLastRelease(client, PRODUCT, currentversion);
			if(lastRelease != null && (Integer.parseInt(lastRelease) > Integer.parseInt(currentversion))){
				result =  true;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
	}
	
	public void downloadUpdate() throws UpdatorException {
		String ftpzipfilename = currentversion + "to" + lastRelease + ".zip";
		String ftpapdatefilename = "update.jar";
		String zipfileremotepath = "/" + PRODUCT + "/" + ftpzipfilename;
		String jarfileremotepath = "/" + PRODUCT + "/" + ftpapdatefilename;
		System.err.println("Patch file" + ftpzipfilename);
		System.err.println("Patch file in server" + zipfileremotepath);
		System.err.println("Préparation de la mise à jour");
		System.out.println("Update application");
		File tempDir = new File(UPDATE_FOLDER_PATH);
		if (tempDir.exists()) {
			FileUtils.rmR(tempDir);
		}
		tempDir.mkdirs();
		if (!tempDir.exists()) {
			post.LogX(NetClientPost.LOG_ERROR, "Directory Clearing problem");
			displayMessage("Impossible de créer le dossier Update\nVérifiez les permissions des fichiers ou lancez le logiciel en tant qu'administrateur");			
			throw new UpdatorException();
		}
		File f = new File( UPDATE_FOLDER_PATH + File.separator + ".version");
		File downloadlock = new File(  UPDATE_FOLDER_PATH + File.separator + "downloadlock");// Scho 730 add lock file
		try {
			downloadlock.createNewFile();
			System.out.println("Create lock file");
		} catch (IOException e2) {
			// TODO Auto-generated catch blocke2.
			e2.printStackTrace();
			post.LogX(NetClientPost.LOG_ERROR, "Creating Download file lock problem");
			throw new UpdatorException();
		}
		try {
			FileUtils.write(String.valueOf(lastRelease) + "\n", f);
		} catch (IOException e1) {
			post.LogX(NetClientPost.LOG_ERROR, "Creating .version file problem");
			System.err.println("Impossible de créer le .version\nVérifiez les permissions des fichiers ou lancez le logiciel en tant qu'administrateur");		
			throw new UpdatorException();
		}

		try {
			try {
				System.err.println("Downloading" + zipfileremotepath);
				post.LogX("Start downloading " + zipfileremotepath);

				Long zipfilsize = post.getFileSize(zipfileremotepath);
				Long jarfilsize = post.getFileSize(jarfileremotepath);
				
				InputStream streaminpathfile = post.getStreamDownload(zipfileremotepath);
				if (streaminpathfile != null) {
					OutputStream out = new FileOutputStream(tempDir.getAbsolutePath() + "/" + ftpzipfilename);
					// Transfer bytes from in to out
					byte[] buf = new byte[1024];
					int len;
					while ((len = streaminpathfile.read(buf)) > 0) {
						out.write(buf, 0, len);
					}
					streaminpathfile.close();
					out.close();
				} else {
					post.LogX(NetClientPost.LOG_ERROR, "Failed due to null stream for the file  " + zipfileremotepath);
					throw new UpdatorException();
				}
				System.err.println("Downloading succes" + zipfileremotepath);
				System.err.println("Downloading " + jarfileremotepath);
				post.LogX("Start downloading " + jarfileremotepath);
				InputStream streaminjar = post.getStreamDownload(jarfileremotepath);
				if (streaminjar != null) {
					OutputStream out = new FileOutputStream(tempDir.getAbsolutePath() + "/" + ftpapdatefilename);
					// Transfer bytes from in to out
					byte[] buf = new byte[1024];
					int len;
					while ((len = streaminjar.read(buf)) > 0) {
						out.write(buf, 0, len);
					}
					streaminjar.close();
					out.close();
				} else {
					post.LogX(NetClientPost.LOG_ERROR, "Failed due to null stream for the file  " + jarfileremotepath);
					throw new UpdatorException();
				}
				System.err.println("Downloading succes " + jarfileremotepath);
				// Comparer avec les fichers telecharge
				File zipfiledowloaded = new File(tempDir.getAbsolutePath() + "/" + ftpzipfilename);
				File jarfiledowloaded = new File(tempDir.getAbsolutePath() + "/" + ftpapdatefilename);
				if (zipfiledowloaded.length() != zipfilsize) {
					post.LogX(NetClientPost.LOG_ERROR, "Failed zip size of file downloaded differnte remote : "
							+ zipfilsize + " local :" + zipfiledowloaded.length());
					throw new UpdatorException();
				}
				if (jarfiledowloaded.length() != jarfilsize) {
					post.LogX(NetClientPost.LOG_ERROR, "Failed jar size of file downloaded diffent remote : "
							+ jarfilsize + " local :" + jarfiledowloaded.length());
					throw new UpdatorException();
				}

				post.LogX(NetClientPost.LOG_DOWNLOAD_OK, "Dowloading succes from " + currentversion + " to " + lastRelease);
				System.out.println("Delete lock file");
				downloadlock.delete();// Scho 730 add lock file
				System.out.println("Téléchargement effectué avec succes");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				System.err.println("Downloading failed ");
				post.LogX(NetClientPost.LOG_ERROR, "Dowloading failed from " + currentversion + " to " + lastRelease);
				System.err.println("Téléchargement interrompue");
				throw new UpdatorException();
			}
	
			System.out.println("Téléchargement terminé");
			display.asyncExec(new Runnable() {
					@Override
					public void run() {
						// TODO Auto-generated method stub
						try {
							updateAppStart(PRODUCT, currentversion, lastRelease);
						} catch (BundleException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					
				});

		} catch (Exception e) {
			e.printStackTrace();
			post.LogX(NetClientPost.LOG_ERROR, "Error when downloading  " + currentversion + " to " + lastRelease);
			display.asyncExec( new Runnable() {
				
				@Override
				public void run() {
					MessageDialog.openError(display.getActiveShell(), "", "télechargement interrompu!");
				}
			});
			throw new UpdatorException();
		}
	}
	
}
