package unbboolean.gui.solidpanels;

import unbboolean.solids.BoxSolid;
import unbboolean.solids.ConeSolid;
import unbboolean.solids.CylinderSolid;
import unbboolean.solids.PrimitiveSolid;
import unbboolean.solids.SphereSolid;

/**
 * Manage the use of primitive panels  
 * 
 * @author Danilo Balby Silva Castanheira(danbalby@yahoo.com)
 */
public class PrimitivePanelsManager
{
	/** panel for the box */
	private BoxPanel boxPanel;

	/** primitives list */
	private static final String[] primitivesList = {"box", "sphere", "cone", "cylinder"};
	
	/** Constructs a default PrimitivePanelsManager object */
	public PrimitivePanelsManager()
	{
		boxPanel = new BoxPanel();

	}
	
	/**
	 * Gets the solid panel relative to a solid
	 * 
	 * @param solid solid whose panel is required
	 * @return solid panel required 
	 */
	public SolidPanel getSolidPanel(PrimitiveSolid solid)
	{
		if(solid instanceof BoxSolid)
		{
			boxPanel.setValues(solid);
			return boxPanel;
		}
		
		
		else return null;
	}
	
	/**
	 * Gets the solid panel relative to a solid
	 * 
	 * @param solid string defining a solid whose panel is required
	 * @return solid panel required 
	 */
	public SolidPanel getSolidPanel(String solid)
	{
		if(solid.equals("box"))
		{
			return boxPanel;
		}
	
		else return null;
	}
	
	/**
	 * Gets the solid panel relative to a solid
	 * 
	 * @param pos position on the list of the solid whose panel is required
	 * @return solid panel required 
	 */
	public SolidPanel getSolidPanel(int pos)
	{
		if(pos==0)
		{
			return boxPanel;
		}
		
		else return null;
	}
	
	/**
	 * Gets the list of primitives
	 * 
	 * @return the list of primitives
	 */
	public String[] getPrimitivesList()
	{
		return primitivesList;
	}
}