 package tech.frsdev.graphunit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class HachedShape extends PGraph implements Serializable
{
        private static final long serialVersionUID = 352L;
	public Point Startpoint;
	public int Width,Height;
	public Rectangle2D.Double rec;
	public double angle=45;
	public double distance=20.0;
	public Shape shape;
	public float hatchStrokeWidth = 0.1f; //epaisseur hachage
	public Color hatchColor = Color.black;
	PText  text;
	String texte=" ";
	//public String chaine;
	Point temppoint;
	public int textsize=15;
	public Font f;
	//352-0
	
	public HachedShape(Point ipoint,int iWidth,int iHeight) 
	{

	       this.Startpoint = new Point();
	       this.Startpoint = ipoint;
	       
	       this.Width = iWidth;
	       this.Height =iHeight;
	       
	       this.rec = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
	      // this.createtext();
	       f = new Font("SansSerif", Font.BOLD, textsize);
	       this.dohash();
				
	}
	public HachedShape(Point ipoint,int iWidth,int iHeight, double iangle, double idistance, String  itext) 
	{
           //construire un rectangle 
	       this.Startpoint = new Point();
	       this.Startpoint = ipoint;
	       
	       this.Width = iWidth;
	       this.Height =iHeight;
	       
	       this.rec = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
	       
	       this.angle=iangle;
	       this.distance=idistance;
	       
	       this.texte=itext;
	    //   this.createtext();
	       f = new Font("SansSerif", Font.BOLD, textsize);
	       this.dohash();      		
	      
		
	}
	/*private void createtext()
	{
		   
		  text = new PText("default piece");
	      text.setColor(Color.red);
	      text.setFontSize(15);
	       
	      
	      
	     
	       temppoint=new Point();
	       temppoint.x = this.Startpoint.x + this.Width/2;
	       temppoint.y = this.Startpoint.y + this.Height/2;
	       text.setStartpoint(temppoint);
	}*/
	
	private void dohash()
	{
		 //code de hachure
	       Path2D path = new Path2D.Double();
			Rectangle2D bounds = rec.getBounds2D(); //retourne les dimensions de Area, ici : (x=0.0,y=0.0,w=100.0,h=150.0)
			double cx = bounds.getCenterX();         //retourne le centre du width ici : 50
			double cy = bounds.getCenterY();          //retourne le centre du height ici : 75
			double d = Math.max(bounds.getHeight(), bounds.getWidth()); ////retourne le max entre w et h ici : 150 
			double y = cy - d;
			while (y < cy + d) {
				path.moveTo(cx - d, y);
				path.lineTo(cx + d, y);
				y += this.distance;
			}
			double theta = this.angle * Math.PI / 180;  // de degr� en radian
			AffineTransform at = AffineTransform.getRotateInstance(theta, cx, cy);//construire matrice de transformation
			//AffineTransform at = AffineTransform.getRotateInstance( cx, cy);
			shape = path.createTransformedShape(at);//cr�er un shape from path en utilisant la matrice de transformation at
	
		
	}
	public void draw(Graphics g)
	{
	     Graphics2D g2d = (Graphics2D)g;
	     //g2d.setColor(this.color);
	     //g2d.setStroke(this.stroke);	     
	  
	     //le rectangle
	     g2d.draw(this.rec);
	      
	     // les hachures
	     //g2d.setStroke(new BasicStroke(hatchStrokeWidth));
	     g2d.setClip(rec);
	     g2d.setColor(hatchColor);
	     g2d.draw(shape);
		 
             //le texte
	     //text.draw(g);  //il faut mettre tjrs le texte le dernier pouqu'il soit visible 
		
	     //le texte centr� au rectangle des 2 cot�s
	     g2d.setFont(f);
	     g2d.setColor(Color.BLUE);
	     drawCenteredString(this.texte, this.Width, this.Height, g2d);

		
	}
	 public void drawCenteredString(String s, int w, int h, Graphics g)
	  {
		 Graphics2D g2d = (Graphics2D)g;
		 temppoint=new Point();
	     temppoint.x = this.Startpoint.x;
	     temppoint.y = this.Startpoint.y;
	    // System.out.println(temppoint.x);
		 
		  FontMetrics fm = g2d.getFontMetrics();
		 
		  while((w - fm.stringWidth(s))<0)  //difference entre w et largeur du texte
		  {
		    	  this.textsize--;
		    	  f = new Font("SansSerif", Font.BOLD, textsize); //mise � jour du fond
		    	  g2d.setFont(f); //adapter nouveau fond au graphic
		    	  fm = g2d.getFontMetrics();  //mise � jour de la taille du texte
		  }
    	 
		  this.textsize--;
    	  f = new Font("SansSerif", Font.BOLD, textsize);
    	  g2d.setFont(f);
    	  fm = g2d.getFontMetrics();  
    	  
		  int x = ((w - fm.stringWidth(s)) / 2)+temppoint.x;
		  int y = ((fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2))+temppoint.y;
		  g2d.drawString(s, x, y);
	  }


}
