package gdxapp.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.ui.Slider.SliderStyle;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener.ChangeEvent;

import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;

public class ColorPalette extends Table {
	private Color color = Color.BLACK;
	private Slider slider;
	private Image colorRectangle;
	private Image preview;
	private Container previewContainer;
	
	public ColorPalette() {
		setWidth(400);
		setHeight(300);

	}
	
	public void construct() {
		clear();
		Texture blueStripe = DrawingHelper.createUniColorPalette(Color.BLUE,10);
		Texture rgSquare = DrawingHelper.drawPalette(Color.RED, Color.GREEN);
		SliderStyle sliderStyle = new SliderStyle();
		slider = new Slider(0,255,1,false,AssetsTextures.getInstance().getSkin());
		sliderStyle.knob = slider.getStyle().knob;
		sliderStyle.background = new TextureRegionDrawable(blueStripe);
		slider.setStyle(sliderStyle);
		slider.addListener(new ChangeListener() {
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				float value = slider.getValue();
				color.b = value/255f;
				update();
			}
		});
		
		
		colorRectangle = new Image(rgSquare);
		colorRectangle.addListener(new InputListener() {
			@Override
			public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
				color.r = x/colorRectangle.getWidth();
				color.g = (colorRectangle.getHeight() - y)/colorRectangle.getHeight();
				update();
				return true;
			}

			@Override
			public void touchDragged(InputEvent event, float x, float y, int pointer) {
				DrawingHelper.drawCercle(x, y, 50, getStage().getBatch());
				color.r = x/colorRectangle.getWidth();
				color.g = (colorRectangle.getHeight() - y)/colorRectangle.getHeight();
				
				update();
			}
			
		});
		preview = new Image(DrawingHelper.createUniform(color, 50, 50));
		previewContainer = new Container<Actor>();
		previewContainer.setActor(preview);
		row().height(150);
		add(previewContainer).width(100);
		add(colorRectangle).width(256);
		row();
		add(slider).colspan(2).fill();
	}
	
	public void update() {
		preview.remove();
		preview = new Image(DrawingHelper.createUniform(new Color(color), 50, 50));
		previewContainer.setActor(preview);
		previewContainer.debug();

	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public Slider getSlider() {
		return slider;
	}

	public Image getColorRectangle() {
		return colorRectangle;
	}

	public Image getPreview() {
		return preview;
	}

	public Container getPreviewContainer() {
		return previewContainer;
	}

}
