package dressing.ui.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.util.EcoreUtil;

import dressing.model.ModelProvider;
import dressing.model.debitage.Debitage;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import param.DesignClasse;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicDesignGroup;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.ModelRoot;
import param.impl.MechanicPrivateParamImpl;
import param.impl.MechanicPublicParamImpl;
import param.impl.ParamFactoryImpl;
import param.Option;
import param.TypeDef;
import param.TypeDefElement;

public class paramManagerModel{
	private boolean isCopy=false;
	private DesignClasse classe;
	private MechanicDesignGroup family;
	private MechanicDesign design;
	
	private DesignClasse classetoRemove;
	private MechanicDesignGroup familytoRemove;
	private MechanicDesign designtoRemove;
	
	private List<DesignClasse> includedclasses=new ArrayList<DesignClasse>();
	private List<DesignClasse> excludedclasses=new ArrayList<DesignClasse>();

	private List<MechanicDesignGroup> includedfamily=new ArrayList<MechanicDesignGroup>();
	private List<MechanicDesignGroup> excludedfamily=new ArrayList<MechanicDesignGroup>();

	private List<MechanicDesign> includeddesign=new ArrayList<MechanicDesign>();
	private List<MechanicDesign> excludeddesign=new ArrayList<MechanicDesign>();
	private List<MechanicDesignElment> includeddesignElemnts=new ArrayList<MechanicDesignElment>();
	private List<MechanicDesignElment> excludeddesignElemnts=new ArrayList<MechanicDesignElment>();
	private List<Option> includeddesignOptions=new ArrayList<Option>();
	private List<Option> excludeddesignOptions=new ArrayList<Option>();

	private List<TypeDefElement> includedPieceTypes=new ArrayList<TypeDefElement>();
	private List<TypeDefElement> excludedPieceTypes=new ArrayList<TypeDefElement>();
	
	private boolean type=true;
	private boolean value=false;
	private boolean label=false;

	//
	//
	private boolean isprivate=true,ispublic; 
	public paramManagerModel() {
		super();
		init();
	}
	public paramManagerModel(boolean copy) {
		super();
		this.isCopy=copy;
		init();

	}
	public void init() {
		includedclasses=new ArrayList<DesignClasse>();
		excludedclasses=new ArrayList<DesignClasse>();

		includedfamily=new ArrayList<MechanicDesignGroup>();
		excludedfamily=new ArrayList<MechanicDesignGroup>();

		includeddesign=new ArrayList<MechanicDesign>();
		excludeddesign=new ArrayList<MechanicDesign>();
		includeddesignOptions=new ArrayList<Option>();
		excludeddesignOptions=new ArrayList<Option>();
		ModelRoot root=ModelProvider.getModelroot();
		TypeDef type=ModelProvider.getTypeDef("PieceType");
		includedPieceTypes.clear();
		includedPieceTypes.addAll(type.getTypedefelement());
		if(this.isCopy) {
			root=EcoreUtil.copy( ModelProvider.getModelroot());
		}
		for(DesignClasse group:root.getClasses().getDesignClasse()) {
			addClasse(group);
		}
		
	}
	public void addClasses(List<DesignClasse> classes) {
		for(DesignClasse classe:classes) {
			addClasse(classe);
		}
		
	}

	public void addClasse(DesignClasse classe) {
		if(classe!=null) {
			if(excludedclasses.contains(classe)) {
				excludedclasses.remove(classe);
			}
			if(!includedclasses.contains(classe))
			{
				includedclasses.add(classe);
			}
			for(MechanicDesignGroup group:classe.getCategorie()) {
				addFamily(group);
			}
		}	
	}
	public void addFamilies(List<MechanicDesignGroup> families) {
		for(MechanicDesignGroup classe:families) {
			addFamily(classe);
		}
		
	}
	public void addFamily(MechanicDesignGroup family) {
		if(family!=null) {
			if(excludedfamily.contains(family)) {
				excludedfamily.remove(family);
			}
			if(!includedfamily.contains(family))
			{
				includedfamily.add(family);
			}
			for(MechanicDesign group:family.getMechanicdesign()) {
				addDesign(group);
			}
		}	
	}
	public void addDesigns(List<MechanicDesign> designs) {
		for(MechanicDesign design:designs) {
			addDesign(design);
		}
		
	}
	public void addDesign(MechanicDesign design) {
		if(design!=null) {
			if(excludeddesign.contains(design)) {
				excludeddesign.remove(design);
			}
			if(!includeddesign.contains(design))
			{
				includeddesign.add(design);
			}
			for(MechanicDesignElment designelement:design.getMechanicelementgroup().getMechanicdesignelment()) {
				addDesignElement(designelement);
			}
			addDesignsOptions(design.getOptions().getOptions());
		}	
	}
	public void removeDesigns(List<MechanicDesign> designs) {
		for(MechanicDesign design:designs) {
			removeDesign(design);
		}
		
	}
	public void removeDesign(MechanicDesign design) {
		if(design!=null) {
			if(includeddesign.contains(design)) {
				includeddesign.remove(design);
			}
			if(!excludeddesign.contains(design))
			{
				excludeddesign.add(design);
			}
			for(MechanicDesignElment designelement:design.getMechanicelementgroup().getMechanicdesignelment()) {
				removeDesignElement(designelement);
			}
			removeDesignsOptions(design.getOptions().getOptions());
		}	
	}
	//
	public void addDesignsOptions(List<Option> designs) {
		for(Option design:designs) {
			addDesignOption(design);
		}
		
	}
	public void addDesignOption(Option design) {
		if(design!=null) {
			if(excludeddesignOptions.contains(design)) {
				excludeddesignOptions.remove(design);
			}
			if(!includeddesignOptions.contains(design))
			{
				includeddesignOptions.add(design);			
			}
		}	
	}
	public void removeDesignsOptions(List<Option> options) {
		for(Option design:options) {
			removeOption(design);
		}
		
	}
	public void removeOption(Option design) {
		if(design!=null) {
			if(includeddesignOptions.contains(design)) {
				includeddesignOptions.remove(design);
			}
			if(!excludeddesignOptions.contains(design))
			{
				excludeddesignOptions.add(design);
			}
			
		}	
	}
	public void removeFamilies(List<MechanicDesignGroup> families) {
		for(MechanicDesignGroup classe:families) {
			removeFamily(classe);
		}
		
	}
	public void removeFamily(MechanicDesignGroup family) {
		if(family!=null) {
			if(includedfamily.contains(family)) {
				includedfamily.remove(family);
			}
			if(!excludedfamily.contains(family))
			{
				excludedfamily.add(family);
			}
			for(MechanicDesign design:family.getMechanicdesign()) {
				removeDesign(design);
			}
		}	
	}
	public void removeClasses(List<DesignClasse> classes) {
		for(DesignClasse classe:classes) {
			removeClasse(classe);
		}
		
	}
	public void removeClasse(DesignClasse classe) {
		if(classe!=null) {
			if(includedclasses.contains(classe)) {
				includedclasses.remove(classe);
			}
			if(!excludedclasses.contains(classe))
			{
				excludedclasses.add(classe);
			}
			for(MechanicDesignGroup group:classe.getCategorie()) {
				removeFamily(group);
			}
		}	
	}
	public void addDesignElements(List<MechanicDesignElment> elements) {
		for(MechanicDesignElment element:elements) {
			addDesignElement(element);
		}
		
	}
	public void addDesignElement(MechanicDesignElment design) {
		if(design!=null && design.getTypedefelement()!=null 
				&& includedPieceTypes!=null && includedPieceTypes.contains(design.getTypedefelement())) {
			if(excludeddesignElemnts.contains(design)) {
				excludeddesignElemnts.remove(design);
			}
			if(!includeddesignElemnts.contains(design))
			{
				includeddesignElemnts.add(design);
			}
		}	
	}
	public void removeDesignElements(List<MechanicDesignElment> elements) {
		for(MechanicDesignElment element:elements) {
			removeDesignElement(element);
		}
		
	}
	public void removeDesignElement(MechanicDesignElment design) {
		if(design!=null) {
			if(includeddesignElemnts.contains(design)) {
				includeddesignElemnts.remove(design);
			}
			if(!excludeddesignElemnts.contains(design))
			{
				excludeddesignElemnts.add(design);
			}
		}	
	}
	public void removePieceTypes(List<TypeDefElement> elements) {
		for(TypeDefElement element:elements) {
			removePieceType(element);
		}
		
	}
	public void removePieceType(TypeDefElement type) {
		if(type!=null) {
			if(includedPieceTypes.contains(type)) {
				includedPieceTypes.remove(type);
			}
			if(!excludedPieceTypes.contains(type))
			{
				excludedPieceTypes.add(type);
			}
			List<MechanicDesignElment> piecesToBeRemoved=new ArrayList<MechanicDesignElment>();
			for(MechanicDesignElment element:includeddesignElemnts) {
				if(element.getTypedefelement().equals(type)) {
					piecesToBeRemoved.add(element);
				}
			}
			removeDesignElements(piecesToBeRemoved);

		}	
	}
	public void addPieceTypes(List<TypeDefElement> elements) {
		for(TypeDefElement element:elements) {
			addPieceType(element);
		}
		
	}
	public void addPieceType(TypeDefElement type) {
		if(type!=null) {
			if(excludedPieceTypes.contains(type)) {
				excludedPieceTypes.remove(type);
			}
			if(!includedPieceTypes.contains(type))
			{
				includedPieceTypes.add(type);
			}
		}	
	}
	public DesignClasse getClassetoRemove() {
		return classetoRemove;
	}

	public void setClassetoRemove(DesignClasse classetoRemove) {
		DesignClasse oldValue=this.classetoRemove;
		this.classetoRemove = classetoRemove;
		firePropertyChange("classetoRemove", oldValue,classetoRemove);	
	}

	public MechanicDesignGroup getFamilytoRemove() {
		return familytoRemove;
	}
	
	public void setFamilytoRemove(MechanicDesignGroup familytoRemove) {
		MechanicDesignGroup oldValue=this.familytoRemove;
		this.familytoRemove = familytoRemove;
		firePropertyChange("familytoRemove", oldValue,familytoRemove);
	}

	public List<TypeDefElement> getIncludedPieceTypes() {
		return includedPieceTypes;
	}
	public void setIncludedPieceTypes(List<TypeDefElement> includedPieceTypes) {
		List<TypeDefElement> oldValue=this.includedPieceTypes;
		this.includedPieceTypes = includedPieceTypes;
		firePropertyChange("includedPieceTypes", oldValue,includedPieceTypes);
	}
	public List<TypeDefElement> getExcludedPieceTypes() {
		return excludedPieceTypes;
	}
	public void setExcludedPieceTypes(List<TypeDefElement> excludedPieceTypes) {	
		List<TypeDefElement> oldValue=this.excludedPieceTypes;
		this.excludedPieceTypes = excludedPieceTypes;
		firePropertyChange("excludedPieceTypes", oldValue,excludedPieceTypes);
	}
	public MechanicDesign getDesigntoRemove() {
		return designtoRemove;
	}

	public void setDesigntoRemove(MechanicDesign designtoRemove) {
		MechanicDesign oldValue=this.designtoRemove;
		this.designtoRemove = designtoRemove;
		firePropertyChange("designtoRemove", oldValue,designtoRemove);
	}

	public DesignClasse getClasse() {
		return classe;
	}

	public void setClasse(DesignClasse classe) {
		DesignClasse oldValue=this.classe;
		this.classe = classe;
		firePropertyChange("classe", oldValue,classe);	
	}

	public MechanicDesignGroup getFamily() {
		return family;
	}

	public void setFamily(MechanicDesignGroup family) {
		MechanicDesignGroup oldValue=this.family;
		this.family = family;
		firePropertyChange("family", oldValue,family);
	}

	public MechanicDesign getDesign() {
		return design;
	}

	public void setDesign(MechanicDesign design) {
		MechanicDesign oldValue=this.design;
		this.design = design;
		firePropertyChange("design", oldValue,design);
	}

	public List<DesignClasse> getIncludedclasses() {
		return includedclasses;
	}

	public void setIncludedclasses(List<DesignClasse> includedclasses) {
		List<DesignClasse> oldValue=this.includedclasses;
		this.includedclasses = includedclasses;
		firePropertyChange("includedclasses", oldValue,includedclasses);
	}

	public List<DesignClasse> getExcludedclasses() {
		return excludedclasses;
	}

	public void setExcludedclasses(List<DesignClasse> excludedclasses) {
		List<DesignClasse> oldValue=this.excludedclasses;
		this.excludedclasses = excludedclasses;
		firePropertyChange("excludedclasses", oldValue,excludedclasses);
	}

	public List<MechanicDesignGroup> getIncludedfamily() {
		return includedfamily;
	}

	public void setIncludedfamily(List<MechanicDesignGroup> includedfamily) {
		List<MechanicDesignGroup> oldValue=this.includedfamily;
		this.includedfamily = includedfamily;
		firePropertyChange("includedfamily", oldValue,includedfamily);
	}

	public List<MechanicDesignGroup> getExcludedfamily() {
		return excludedfamily;
	}

	public void setExcludedfamily(List<MechanicDesignGroup> excludedfamily) {
		List<MechanicDesignGroup> oldValue=this.excludedfamily;
		this.excludedfamily = excludedfamily;
		firePropertyChange("excludedfamily", oldValue,excludedfamily);
	}

	public List<MechanicDesign> getIncludeddesign() {
		return includeddesign;
	}

	public void setIncludeddesign(List<MechanicDesign> includeddesign) {
		List<MechanicDesign> oldValue=this.includeddesign;
		this.includeddesign = includeddesign;
		firePropertyChange("includeddesign", oldValue,includeddesign);
	}

	public List<MechanicDesign> getExcludeddesign() {
		return excludeddesign;
	}
	
	public void setExcludeddesign(List<MechanicDesign> excludeddesign) {
		List<MechanicDesign> oldValue=this.excludeddesign;
		this.excludeddesign = excludeddesign;
		firePropertyChange("excludeddesign", oldValue,excludeddesign);
	}
	public List<Option> getIncludeddesignOptions() {
		return includeddesignOptions;
	}

	public void setIncludeddesignOptions(List<Option> includeddesignOptions) {
		List<Option> oldValue=this.includeddesignOptions;
		this.includeddesignOptions = includeddesignOptions;
		firePropertyChange("includeddesignOptions", oldValue,includeddesignOptions);
	}

	public List<Option> getExcludeddesignOptions() {
		return excludeddesignOptions;
	}
	
	public void setExcludeddesignOptions(List<Option> excludeddesignOptions) {
		List<Option> oldValue=this.excludeddesignOptions;
		this.excludeddesignOptions = excludeddesignOptions;
		firePropertyChange("excludeddesignOptions", oldValue,excludeddesignOptions);
	}
	public List<MechanicDesignElment> getIncludeddesignElemnts() {
		return includeddesignElemnts;
	}
	public void setIncludeddesignElemnts(List<MechanicDesignElment> includeddesignElemnts) {
		List<MechanicDesignElment> oldValue=this.includeddesignElemnts;
		this.includeddesignElemnts = includeddesignElemnts;
		firePropertyChange("includeddesignElemnts", oldValue,includeddesignElemnts);
	}
	public List<MechanicDesignElment> getExcludeddesignElemnts() {
		return excludeddesignElemnts;
	}
	public void setExcludeddesignElemnts(List<MechanicDesignElment> excludeddesignElemnts) {
		List<MechanicDesignElment> oldValue=this.excludeddesignElemnts;
		this.excludeddesignElemnts = excludeddesignElemnts;
		firePropertyChange("excludeddesignElemnts", oldValue,excludeddesignElemnts);
	}
	public boolean isIsprivate() {
		return isprivate;
	}
	public void setIsprivate(boolean isprivate) {
		boolean oldValue=this.isprivate;
		this.isprivate = isprivate;
		firePropertyChange("isprivate", oldValue,isprivate);
	}
	public boolean isIspublic() {
		return ispublic;
	}
	public void setIspublic(boolean ispublic) {
		boolean oldValue=this.ispublic;
		this.ispublic = ispublic;
		firePropertyChange("ispublic", oldValue,ispublic);
	}

	public boolean isType() {
		return type;
	}
	public void setType(boolean type) {
		boolean oldValue=this.type;
		this.type = type;
		firePropertyChange("isType", oldValue,type);
	}
	public boolean isValue() {
		return value;
	}
	public void setValue(boolean value) {
		boolean oldValue=this.value;
		this.value = value;
		firePropertyChange("isType", oldValue,value);
	}
	public boolean isLabel() {
		return label;
	}
	public void setLabel(boolean label) {
		boolean oldValue=this.label;
		this.label = label;
		firePropertyChange("isType", oldValue,label);
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(
			this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName,
				listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
		
			propertyChangeSupport.firePropertyChange(propertyName, oldValue,
					newValue);
		
					
	}
	public PropertyChangeListener[] getListeners() {
		if(propertyChangeSupport==null) {
			return null;
		}
		return	propertyChangeSupport.getPropertyChangeListeners();
	}
	public void removeAllLsteners() {
		PropertyChangeListener[] listeners=getListeners();
		if(listeners==null) {
			return;
		}
		for(PropertyChangeListener listener:listeners) {
			propertyChangeSupport.removePropertyChangeListener(listener);
		}
	}
}
