package dressing.ui.caisson;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.util.SingleImageItemLabelProvider;

public class CaissonCompositeEditor extends Composite implements IUpdateStructure{

	private DataBindingContext m_bindingContext;
	private dressing.model.Space3D caisson = null;
	private ModelProvider modelprovider = new ModelProvider();
	private Label lblNewLabel;
	private Label lblCaisson;
	private Spinner spinner_longeur;
	private Spinner spinner_hauteur;
	private Spinner spinner_profondeur;
	private Text text_nom;
	private MDirtyable dirty;
	private StyledText styledText;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private Button btnCheckfreelongeur;
	private Button btnCheckfreehauteur;
	private Button btnCheckfreeprofondeur;
	private Label lblMatriea;
	private Label lblMatrieauxDeDos;
	private Combo combobasematerial;
	private ComboViewer comboViewer;
	private Combo combodosmaterial;
	private ComboViewer comboViewer_1;
	private Button btnLibrebasematrial;
	private Button btnLibrebackmaterial;
	private TableComboViewer tableComboViewermatprincipale;
	private TableComboViewer tableComboViewer_matdos;

	public CaissonCompositeEditor(Composite parent, int style, dressing.model.Space3D newCuisson,int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		this.setCuisson(newCuisson);
		if (caisson != null) {
			m_bindingContext = initDataBindings();
		}
	}

	public CaissonCompositeEditor(Composite parent, int style) {
		super(parent, style);
		setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		GridLayout gridLayout = new GridLayout(3, false);
		setLayout(gridLayout);
		
		lblCaisson = new Label(this, SWT.NONE);
		lblCaisson.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblCaisson.setForeground(SWTResourceManager.getColor(SWT.COLOR_DARK_GREEN));
		lblCaisson.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.BOLD));
		lblCaisson.setText("Caisson");
		
		styledText = new StyledText(this, SWT.BORDER);
		styledText.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
		styledText.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		styledText.setDoubleClickEnabled(false);
		styledText.setEditable(false);
		styledText.setAlwaysShowScrollBars(false);
		styledText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		Label label_8 = new Label(this, SWT.NONE);
		label_8.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_8.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_8.setText("Nom");
		
		text_nom = new Text(this, SWT.BORDER);
		text_nom.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblNewLabel.setText("   ");

		Label label_9 = new Label(this, SWT.NONE);
		label_9.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_9.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_9.setText("Longeur (mm)");
		
		spinner_longeur = new Spinner(this, SWT.BORDER);
		spinner_longeur.setEnabled(false);
		spinner_longeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_longeur.setMaximum(1000000000);
		spinner_longeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner_longeur.setMinimum(0);
		spinner_longeur.setSelection(500);
		spinner_longeur.setIncrement(1);
		spinner_longeur.setPageIncrement(1);
		btnCheckfreelongeur = new Button(this, SWT.CHECK);
		btnCheckfreelongeur.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});
		btnCheckfreelongeur.setText("Libre");

		Label label_7 = new Label(this, SWT.NONE);
		label_7.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_7.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_7.setText("Hauteur (mm)");
		
		spinner_hauteur = new Spinner(this, SWT.BORDER);
		spinner_hauteur.setEnabled(false);
		spinner_hauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_hauteur.setMaximum(10000000);
		spinner_hauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner_hauteur.setMinimum(0);
		spinner_hauteur.setSelection(500);
		spinner_hauteur.setIncrement(1);
		spinner_hauteur.setPageIncrement(1);
		btnCheckfreehauteur = new Button(this, SWT.CHECK);
		btnCheckfreehauteur.setText("Libre");

		Label label_6 = new Label(this, SWT.NONE);
		label_6.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_6.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_6.setText("Profondeur (mm)");
		
		spinner_profondeur = new Spinner(this, SWT.BORDER);
		spinner_profondeur.setEnabled(false);
		spinner_profondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_profondeur.setMaximum(100000);
		spinner_profondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner_profondeur.setMinimum(0);
		spinner_profondeur.setSelection(500);
		spinner_profondeur.setIncrement(1);
		spinner_profondeur.setPageIncrement(1);
		btnCheckfreeprofondeur = new Button(this, SWT.CHECK);
		btnCheckfreeprofondeur.setText("Libre");
		
		lblMatriea = new Label(this, SWT.NONE);
		lblMatriea.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblMatriea.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblMatriea.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatriea.setText("Matérieaux principale");
		
//		comboViewer = new ComboViewer(this, SWT.NONE);
//		combobasematerial = comboViewer.getCombo();
//		combobasematerial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatprincipale = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewermatprincipale.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatprincipale.getTableCombo().setShowTableHeader(true);
		tableComboViewermatprincipale.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
		tableComboViewermatprincipale.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		// do not allow editable
		tableComboViewermatprincipale.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewermatprincipale.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewermatprincipale.setInput(modelprovider.getMateriallist());
		
		//
		btnLibrebasematrial = new Button(this, SWT.CHECK);
		btnLibrebasematrial.setText("Libre");
		
		lblMatrieauxDeDos = new Label(this, SWT.NONE);
		lblMatrieauxDeDos.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblMatrieauxDeDos.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxDeDos.setText("Matérieaux de dos");
//		
//		comboViewer_1 = new ComboViewer(this, SWT.NONE);
//		combodosmaterial = comboViewer_1.getCombo();
//		combodosmaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matdos = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewer_matdos.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matdos.getTableCombo().setShowTableHeader(true);
		tableComboViewer_matdos.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewer_matdos.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewer_matdos.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		// do not allow editable
		tableComboViewer_matdos.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewer_matdos.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewer_matdos.setInput(modelprovider.getMateriallist());	
		
		btnLibrebackmaterial = new Button(this, SWT.CHECK);
		btnLibrebackmaterial.setText("Libre");

		if (caisson != null) {
			m_bindingContext = initDataBindings();
		}

		//Ajouter le controle de dirty
		makedirtycontroller();		

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.model.Space3D getCuisson() {
		return caisson;
	}

	public void setCuisson(dressing.model.Space3D newCuisson) {
		setCuisson(newCuisson, true);
	}

	public void setCuisson(dressing.model.Space3D newCuisson, boolean update) {
		caisson = newCuisson;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (caisson != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}

	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
			m_bindingContext.updateModels();
			try {
			
				caisson.propagateUpdateToChildrens(null);
				if(caisson!=null && caisson.getParentdesign()!=null
					&& caisson.getParentdesign() instanceof Dressing
					&& !(caisson.getParentdesign() instanceof Cuisine)) {
					try {
						((Dressing)caisson.getParentdesign()).update();
						caisson.setErrormsg("");
						caisson.setErrorexist(false);
					} catch (Exception e) {
						e.printStackTrace();
						caisson.setErrormsg(e.getMessage());
						caisson.setErrorexist(true);
					}
				}
				caisson.setErrormsg("");
				caisson.setErrorexist(false);
			} catch (GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				caisson.setErrormsg(e.getMessage());
				caisson.setErrorexist(true);
			}

	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makedirtycontroller()
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
				for(Control ctr : this.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
					if(ctr instanceof Spinner)
					{
						ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
					}
				}
	}

	@Override
	public void dispose() {
		this.m_bindingContext.dispose();
		this.m_bindingContext=null;
		super.dispose();
	}

	protected void makeerrorhandler(Control control)
	{
		ControlDecoration deco;
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSelectionSpinner_profondeurObserveWidget = WidgetProperties.widgetSelection().observe(spinner_profondeur);
		IObservableValue profondeurextCuissonObserveValue = BeanProperties.value("profondeurext").observe(caisson);
		bindingContext.bindValue(observeSelectionSpinner_profondeurObserveWidget, profondeurextCuissonObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_longeurObserveWidget = WidgetProperties.widgetSelection().observe(spinner_longeur);
		IObservableValue longeurextCuissonObserveValue = BeanProperties.value("longeurext").observe(caisson);
		bindingContext.bindValue(observeSelectionSpinner_longeurObserveWidget, longeurextCuissonObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_hauteurObserveWidget = WidgetProperties.widgetSelection().observe(spinner_hauteur);
		IObservableValue hauteurextCuissonObserveValue = BeanProperties.value("hauteurext").observe(caisson);
		bindingContext.bindValue(observeSelectionSpinner_hauteurObserveWidget, hauteurextCuissonObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeTextText_nomObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(text_nom);
		IObservableValue nameCuissonObserveValue = BeanProperties.value("name").observe(caisson);
		bindingContext.bindValue(observeTextText_nomObserveWidget, nameCuissonObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeTextStyledTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(styledText);
		IObservableValue errormsgCuissonObserveValue = BeanProperties.value("errormsg").observe(caisson);
		bindingContext.bindValue(observeTextStyledTextObserveWidget, errormsgCuissonObserveValue, null, null);
		//
		IObservableValue observeVisibleStyledTextObserveWidget = WidgetProperties.visible().observe(styledText);
		IObservableValue errorexistCuissonObserveValue = BeanProperties.value("errorexist").observe(caisson);
		bindingContext.bindValue(observeVisibleStyledTextObserveWidget, errorexistCuissonObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckfreelongeurObserveWidget = WidgetProperties.widgetSelection().observe(btnCheckfreelongeur);
		IObservableValue longeurextfreeCaissonObserveValue = BeanProperties.value("longeurextfree").observe(caisson);
		bindingContext.bindValue(observeSelectionBtnCheckfreelongeurObserveWidget, longeurextfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckfreehauteurObserveWidget = WidgetProperties.widgetSelection().observe(btnCheckfreehauteur);
		IObservableValue hauteurextfreeCaissonObserveValue = BeanProperties.value("hauteurextfree").observe(caisson);
		bindingContext.bindValue(observeSelectionBtnCheckfreehauteurObserveWidget, hauteurextfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckfreeprofondeurObserveWidget = WidgetProperties.widgetSelection().observe(btnCheckfreeprofondeur);
		IObservableValue profondeurextfreeCaissonObserveValue = BeanProperties.value("profondeurextfree").observe(caisson);
		bindingContext.bindValue(observeSelectionBtnCheckfreeprofondeurObserveWidget, profondeurextfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibrebasematrialObserveWidget = WidgetProperties.widgetSelection().observe(btnLibrebasematrial);
		IObservableValue basematerialfreeCaissonObserveValue = BeanProperties.value("basematerialfree").observe(caisson);
		bindingContext.bindValue(observeSelectionBtnLibrebasematrialObserveWidget, basematerialfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibrebackmaterialObserveWidget = WidgetProperties.widgetSelection().observe(btnLibrebackmaterial);
		IObservableValue backmaterialfreeCaissonObserveValue = BeanProperties.value("backmaterialfree").observe(caisson);
		bindingContext.bindValue(observeSelectionBtnLibrebackmaterialObserveWidget, backmaterialfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeEnabledSpinner_longeurObserveWidget = WidgetProperties.enabled().observe(spinner_longeur);
		bindingContext.bindValue(observeEnabledSpinner_longeurObserveWidget, longeurextfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeEnabledSpinner_hauteurObserveWidget = WidgetProperties.enabled().observe(spinner_hauteur);
		bindingContext.bindValue(observeEnabledSpinner_hauteurObserveWidget, hauteurextfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeEnabledSpinner_profondeurObserveWidget = WidgetProperties.enabled().observe(spinner_profondeur);
		bindingContext.bindValue(observeEnabledSpinner_profondeurObserveWidget, profondeurextfreeCaissonObserveValue, null, null);
		//
		IObservableValue observeSingleSelectiontableComboViewer_matdos = ViewerProperties.singleSelection().observe(tableComboViewer_matdos);
		IObservableValue backmaterialCaissonObserveValue = BeanProperties.value("backmaterial").observe(caisson);
		bindingContext.bindValue(observeSingleSelectiontableComboViewer_matdos, backmaterialCaissonObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectionTableComboViewermatprincipale = ViewerProperties.singleSelection().observe(tableComboViewermatprincipale);
		IObservableValue basematerialCaissonObserveValue = BeanProperties.value("basematerial").observe(caisson);
		bindingContext.bindValue(observeSingleSelectionTableComboViewermatprincipale, basematerialCaissonObserveValue, null, null);
		//
		return bindingContext;
	}
}
