package dressing.model.evalutor;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import dressing.model.Caisson;

public class TestJavaScript {
    public static void main(String[] args) throws Exception {
        TestJavaScript test = new TestJavaScript();
        System.out.println(test.test(false, false));
        System.out.println(test.test(false, true ));
        System.out.println(test.test(true , false));
        System.out.println(test.test(true , true ));
        

        test.eval(" \"hhhh\".length > 2 " );
    }

    private ScriptEngine   jsEngine;
    private CompiledScript script;

    private TestJavaScript() throws ScriptException {
        this.jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        this.script = ((Compilable) this.jsEngine).compile("in1 && in2");
    }

    private boolean test(boolean in1, boolean in2) throws ScriptException {
        Bindings vars = this.jsEngine.createBindings();
        vars.put("in1", in1);
        vars.put("in2", in2);
        return (boolean) this.script.eval(vars);
    }
    
    private void eval(String s)
    {
    	try {
    	
    		Caisson c = new Caisson();
    		c.setLongeurext(190);
    		this.jsEngine.put("CAISSON", c);  
    		this.jsEngine.eval("function hello(name) { print('Hello, ' + name) }");    	
    		this.jsEngine.eval("function isTooLong( designobject , limit) { if ( designobject.getLongeurext()>limit) { return 'So long'} else {return 'so short'}}");  
    		
    		this.jsEngine.eval("print(isTooLong(CAISSON,150))");
    		this.jsEngine.eval(" hello('samih')");    	
    		System.out.println(this.jsEngine.eval(s));    		
    		this.jsEngine.eval("CAISSON.setLongeurext(200)");
    		this.jsEngine.eval("print(CAISSON.getLongeurext())");
    		
    		System.out.println("Java imapct "+c.getLongeurext());
		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}    	
    }
}