package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.EtagereDistances;
import dressing.model.Materiaux;
import dressing.model.Piece2D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.EtagereReferenceType;
import dressing.model.types.EtagereType;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;

public class EtagereCreator implements Creator{

	public final static double MIN_ETAGERE_INTER_DISTANCE = 100;

	double distanceref = 500;
	int etagerecount = 1;
	Boolean distanceAutomatique = true;
	Boolean intetrDistance = false;
	Boolean tableDesDistance = false;
	Boolean isometriqueAutomatique=false;
	double interDistanceManuel=100;
	EtagereType etagereType = EtagereType.MOBILE;
	String etagereTypeText;
	EtagereReferenceType etagereReferenceType = EtagereReferenceType.BAS;
	String referenceText;
	Materiaux basematerial;
	Materiaux material;
	Materiaux backmaterial;
	PositionCalculationType positionCalculationtype = PositionCalculationType.PROPORTIONAL;
	DesignObject3D parent;
	//Double[] listDistance;
	List<EtagereDistances> listDistance = new ArrayList<EtagereDistances>();
	
	List<DesignObject3D> etagereList = new ArrayList<DesignObject3D>();
	double sepRetrait=0;

	public double getSepRetrait() {
		return sepRetrait;
	}
	public void setSepRetrait(double sepRetrait) {
		double oldValue = this.sepRetrait;
		this.sepRetrait = sepRetrait;
		firePropertyChange("sepRetrait", oldValue, sepRetrait);
	}
	public String getEtagereTypeText() {
		return etagereTypeText;
	}

	public void setEtagereTypeText(String etagereTypeText) {
		this.etagereTypeText = etagereTypeText;
	}

	public String getReferenceText() {
		return referenceText;
	}

	public void setReferenceText(String referenceText) {
		this.referenceText = referenceText;
	}

	public double getInterDistanceManuel() {
		return interDistanceManuel;
	}

	public Materiaux getMaterial() {
		return material;
	}

	public void setMaterial(Materiaux material) {
		
		Materiaux oldValue = this.material;
		this.material = material;
		firePropertyChange("material", oldValue, material);
	}

	public Materiaux getBackmaterial() {
		return backmaterial;
	}

	public void setBackmaterial(Materiaux backmaterial) {
		this.backmaterial = backmaterial;
	}

	public void setInterDistanceManuel(double interDistanceManuel) {
		double  oldValue= this.interDistanceManuel;
		this.interDistanceManuel = interDistanceManuel;
		firePropertyChange("interDistanceManuel", oldValue, interDistanceManuel);
	}

	public List<DesignObject3D> getEtagereList() {
		return etagereList;
	}

	public void setEtagereList(List<DesignObject3D> etagereList) {
		List<DesignObject3D> oldValue= this.etagereList;
		this.etagereList = etagereList;
		firePropertyChange("etagereList", oldValue, etagereList);
		
	}

	public double getDistanceref() {
		return distanceref;
	}

	public void setDistanceref(double distanceref) {
		double oldValue = this.distanceref;
		this.distanceref = distanceref;
		firePropertyChange("distanceref", oldValue, distanceref);
	}

	public int getEtagerecount() {
		return etagerecount;
	}

	public void setEtagerecount(int etagerecount) {

		int oldValue = this.etagerecount;
		this.etagerecount = etagerecount;
		firePropertyChange("etagerecount", oldValue, etagerecount);
	}

	public Boolean getDistanceAutomatique() {
		return distanceAutomatique;
	}

	public void setDistanceAutomatique(Boolean distanceAutomatique) {

		Boolean oldValue = this.distanceAutomatique;
		this.distanceAutomatique = distanceAutomatique;
		firePropertyChange("distanceAutomatique", oldValue, distanceAutomatique);
	}

	public Boolean getIntetrDistance() {
		return intetrDistance;
	}

	public void setIntetrDistance(Boolean intetrDistance) {

		Boolean oldValue = this.intetrDistance;
		this.intetrDistance = intetrDistance;
		firePropertyChange("intetrDistance", oldValue, intetrDistance);
	}

	public Boolean getTableDesDistance() {
		return tableDesDistance;
	}

	public void setTableDesDistance(Boolean tableDesDistance) {
		Boolean oldValue = this.tableDesDistance;
		this.tableDesDistance = tableDesDistance;
		firePropertyChange("tableDesDistance", oldValue, tableDesDistance);
	}

	public Boolean getIsometriqueAutomatique() {
		return isometriqueAutomatique;
	}

	public void setIsometriqueAutomatique(Boolean isometriqueAutomatique) {
		Boolean oldValue = this.isometriqueAutomatique;
		this.isometriqueAutomatique = isometriqueAutomatique;
		firePropertyChange("isometriqueAutomatique", oldValue, isometriqueAutomatique);
	}

	public EtagereType getEtagereType() {
		return etagereType;
	}

	public void setEtagereType(EtagereType etagereType) {
		EtagereType oldValue = this.etagereType;
		this.etagereType = etagereType;
		firePropertyChange("etagereType", oldValue, etagereType);
	}

	public EtagereReferenceType getEtagereReferenceType() {
		return etagereReferenceType;
	}

	public void setEtagereReferenceType(EtagereReferenceType etagereReferenceType) {
		EtagereReferenceType oldValue = this.etagereReferenceType;
		this.etagereReferenceType = etagereReferenceType;
		firePropertyChange("referenceType", oldValue, etagereReferenceType);
	}

	public Materiaux getBasematerial() {
		return basematerial;
	}

	public void setBasematerial(Materiaux basematerial) {

		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}

	public PositionCalculationType getPositionCalculationtype() {
		return positionCalculationtype;
		
	}

	public void setPositiontype(PositionCalculationType positiontype) {
		PositionCalculationType oldValue = this.positionCalculationtype;
		this.positionCalculationtype = positiontype;
		firePropertyChange("positiontype", oldValue, positiontype);
	}

	public DesignObject3D getParent() {
		return parent;
	}

	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		firePropertyChange("parent", oldValue, parent);
	}



	public List<EtagereDistances> getListDistance() {
		return listDistance;
	}

	public void setListDistance(List<EtagereDistances> listDistance) {
		List<EtagereDistances> oldValue = this.listDistance;
		this.listDistance = listDistance;
		firePropertyChange("listDistance", oldValue, listDistance);
	}
/**
 * ce method est créer pour invoker le firePropertyChange virtuellement a cause de faire le calcul a nouveaux
 */
	public void trigerChangeCalculation()
	{
		
		firePropertyChange("autotrigger", "2", "1");
	}
	
	
	/**
	 * @return the active
	 */
	
	public void create() throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub

		createSubElements();
	}

	public void check() throws DesignException {
		if (getMaterial() == null)
		{
			throw new DesignException("Le matérieaux de base doit être rensigné");
		}
		if (getEtagereReferenceType() == null)
			throw new DesignException("Le Type de reference doit être rensigné");
		if (getEtagerecount() < 1)
			throw new DesignException("Le nombre des etagere doit être superieur ou égale à 1 ");

		if (getParent() == null)
			throw new DesignException("Le parent doit être renseigné");

		if (getPositionCalculationtype() == null)
			throw new DesignException("Le type de position de l'etagere doit être rensigné ");

	}

	public void createSubElements() throws DesignException, GeometricEngineException {
		etagereList.clear();
		check(); // On met le controle dans une seule fonction

		double lougeurrestante = parent.getHauteurint();
		double distanceinteretage = this.distanceref;
		setBasematerial(getParent().getBasematerial());
		setBackmaterial(getParent().getBackmaterial());
		double Ypos = 0;
		if(getEtagereReferenceType()==EtagereReferenceType.BAS) {
			Ypos=parent.getBasematerial().getEpaisseur();
			}else if(getEtagereReferenceType()==EtagereReferenceType.HAUT){
			Ypos=parent.getHauteurext()-parent.getBasematerial().getEpaisseur();
			}else {
				throw new DesignException("Le reference d'etgere est inconnue");
			}
			
		for (int i = 0; i < getEtagerecount(); i++) {

			if(MIN_ETAGERE_INTER_DISTANCE > lougeurrestante)
				throw new DesignException("La Distance interEtage minimale est insuffussante");

			Piece2DCreator piece2dCreator = new Piece2DCreator();

			piece2dCreator.setName("Etagere " + (i + 1));
			piece2dCreator.setBasematerial(getParent().getBasematerial());
			piece2dCreator.setBackmaterial(getParent().getBackmaterial());
			piece2dCreator.setMaterial(getMaterial());
			piece2dCreator.setSeprationaxe(SeprationAxe.YAXIS);
			piece2dCreator.setSepRetrait(getSepRetrait());
			if (getEtagereType() == EtagereType.FIXE)

				piece2dCreator.setPiecetype(PieceType.ETAGERE_FIXE);
			else if (getEtagereType() == EtagereType.MOBILE)
				piece2dCreator.setPiecetype(PieceType.ETAGERE_MOBILE);
			else
				throw new DesignException("Le type d'etgere est inconnue");
			
		
			piece2dCreator.setPositionCalculationType(getPositionCalculationtype());
			piece2dCreator.setParent(getParent());

			piece2dCreator.create();
			etagereList.add(piece2dCreator.getPiece2DInstance());

			// changer les ypos
			// algorithme
			
		if(getEtagerecount()==1 && distanceAutomatique == true ) {
			
			for(DesignObject3D dos: getParent().getChilds()) {
				if(dos instanceof Piece2D && ((Piece2D)dos).getPiecetype().equals(PieceType.ETAGERE_MOBILE)) {
					Ypos=dos.getYpos()+getMaterial().getEpaisseur();
				}
			}
			Ypos+=distanceref;
			if(Ypos>getParent().getHauteurint()-MIN_ETAGERE_INTER_DISTANCE) {
				throw new DesignException("Le position de l'etagere doit inferieur a la hauteur interieur moins la distance inter etage minimale ");
			}
		}else {
			
		
			
			if (distanceAutomatique == true) {
				if (distanceinteretage<MIN_ETAGERE_INTER_DISTANCE)
					throw new DesignException("La Distance Reference minimale est insuffussante");

				if (i == 0 ) {
					
					if (this.distanceref > parent.getHauteurint() - MIN_ETAGERE_INTER_DISTANCE)
						throw new DesignException("La Distance Reference maximale est dépassé");
					if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
						Ypos = distanceinteretage + Ypos;
					
					}else {
						Ypos -=  distanceinteretage +this.getMaterial().getEpaisseur();
					}
					
				}

				if (i >= 1) {

					if (i == 1) {
						distanceinteretage = (lougeurrestante / getEtagerecount())
								- this.getMaterial().getEpaisseur();
					}

					if (MIN_ETAGERE_INTER_DISTANCE > distanceinteretage) {
						throw new DesignException("La Distance reference minimale est insuffussante");
					}
					
					if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
						Ypos = Ypos+  distanceinteretage  + this.getMaterial().getEpaisseur();
					}else {
						Ypos = Ypos-( distanceinteretage + this.getMaterial().getEpaisseur());

					}
				}	
				lougeurrestante -= distanceinteretage+this.getMaterial().getEpaisseur();
				
			}else if (isometriqueAutomatique == true) {
				if (distanceinteretage<MIN_ETAGERE_INTER_DISTANCE)
					throw new DesignException("La Distance Reference minimale est insuffussante");

					if (i == 0) {
						distanceinteretage = ((parent.getHauteurint() - (this.getMaterial().getEpaisseur()*getEtagerecount()))/ (getEtagerecount()+1)) ;
						if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
							Ypos = Ypos+  distanceinteretage;
							}else {
							Ypos = Ypos-( distanceinteretage +this.getMaterial().getEpaisseur());

							}
					}

					if (MIN_ETAGERE_INTER_DISTANCE > distanceinteretage) {
						throw new DesignException("La Distance reference minimale est insuffussante");
					}
					if(i>=1) {
						if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
						Ypos = Ypos+  distanceinteretage+this.getMaterial().getEpaisseur();
						}else {
						Ypos = Ypos-( distanceinteretage +this.getMaterial().getEpaisseur());

						}
					}
			

				lougeurrestante -= distanceinteretage+this.getMaterial().getEpaisseur();
				
			}else if (this.intetrDistance) {
				if(MIN_ETAGERE_INTER_DISTANCE>getInterDistanceManuel())
					throw new DesignException("La Distance interEtage Manuel minimale est insuffussante");
				if(interDistanceManuel+MIN_ETAGERE_INTER_DISTANCE+this.getMaterial().getEpaisseur()>lougeurrestante)
					throw new DesignException("la somme des distances entre les etagere doit étre inferieur a la taille interieur du parent");
				
				if (i == 0) {
					distanceinteretage = interDistanceManuel;
					
					if((getInterDistanceManuel()*getEtagerecount()+1)+(getMaterial().getEpaisseur()*getEtagerecount())>parent.getHauteurint())
						throw new DesignException("La Distance interEtage Manuel minimale est insuffussante");
					if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
						Ypos += distanceinteretage ;

					}else {
						Ypos -=distanceinteretage ;

					}
				}
				if(i>=1) {
					if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
					Ypos += distanceinteretage + this.getMaterial().getEpaisseur();

					}else {
					Ypos -=distanceinteretage + this.getMaterial().getEpaisseur();

				}
				}
				
				lougeurrestante -= distanceinteretage+this.getMaterial().getEpaisseur();

			}else if(this.tableDesDistance) {
				if(this.listDistance==null) {
					throw new DesignException("le nombre des element de table des distance superieurs a 0");
				}

				Double x=0.0;
					if(i>=this.listDistance.size()){
						throw new DesignException("la taille de la liste des distance doit être égale à l'etagereCount ");
						}else {
							
							x=this.listDistance.get(i).getEtagereDistance();
							if(x<MIN_ETAGERE_INTER_DISTANCE)
								throw new DesignException("la distance entre les etagere doit étre superieur a la min distance inter Etage");
							if(x+MIN_ETAGERE_INTER_DISTANCE+this.getMaterial().getEpaisseur()>lougeurrestante)
								throw new DesignException("la somme des distances entre les etagere doit étre inferieur a la taille interieur du parent");
							
							piece2dCreator.getPiece2DInstance().setName(this.listDistance.get(i).getEtagereNom());
						}
					if(i==0) {
						if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
							Ypos+=x;

						}else {
							Ypos-=x;
						}	
					}
					else if(i>=1) {
						if(getEtagereReferenceType().equals(EtagereReferenceType.BAS)) {
							Ypos+=x+ this.getMaterial().getEpaisseur();

						}else {
							Ypos-=x+ this.getMaterial().getEpaisseur();
						}	
					}
					

				lougeurrestante -= (x+this.getMaterial().getEpaisseur());
			}

			else {
				throw new DesignException("non supporter");
			}
			
//		
		}
			
			piece2dCreator.getPiece2DInstance().setYpos(Ypos);

		}
		// Changer le dernier cuisson en autocalcul�
		// int debug = 0;
		// debug++;

	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

}
